/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.omGraphics.OMColor;
import java.awt.Color;
import java.awt.Paint;
import java.util.Properties;

public class ColorFactory {
    public static Color parseColorFromProperties(Properties p, String propName, String dfault) throws NumberFormatException {
        String colorString = p.getProperty(propName, dfault);
        return ColorFactory.parseColor(colorString, false);
    }

    public static Color parseColorFromProperties(Properties p, String propName, String dfault, boolean forceAlpha) throws NumberFormatException {
        String colorString = p.getProperty(propName, dfault);
        return ColorFactory.parseColor(colorString, forceAlpha);
    }

    public static Paint parseColorFromProperties(Properties p, String propName, Paint dfault) throws NumberFormatException {
        String colorString = p.getProperty(propName);
        if (colorString != null) {
            return ColorFactory.parseColor(colorString, false);
        }
        return dfault;
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        return ColorFactory.parseColor(colorString, false);
    }

    public static Color parseColor(String colorString, boolean forceAlpha) throws NumberFormatException {
        int value;
        try {
            value = (int)Long.parseLong(colorString, 16);
        }
        catch (NumberFormatException nfe) {
            value = Long.decode(colorString).intValue();
        }
        if (colorString.length() < 7 && !colorString.equals("0")) {
            return new Color(value);
        }
        return ColorFactory.createColor(value, forceAlpha);
    }

    public static Color createColor(float red, float green, float blue, float alpha) {
        return ColorFactory.createColor(red, green, blue, alpha, false);
    }

    public static Color createColor(float red, float green, float blue, float alpha, boolean forceAlpha) {
        int value = ((int)(alpha * 255.0f) & 0xFF) << 24 | ((int)(red * 255.0f) & 0xFF) << 16 | ((int)(green * 255.0f) & 0xFF) << 8 | (int)(blue * 255.0f) & 0xFF;
        return ColorFactory.createColor(value, forceAlpha);
    }

    public static Color createColor(int red, int green, int blue, int alpha) {
        return ColorFactory.createColor(red, green, blue, alpha, false);
    }

    public static Color createColor(int red, int green, int blue, int alpha, boolean forceAlpha) {
        int value = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return ColorFactory.createColor(value, forceAlpha);
    }

    public static Color createColor(int value) {
        return ColorFactory.createColor(value, false);
    }

    public static Color createColor(int value, boolean forceAlpha) {
        if (!OMColor.nativeAlpha) {
            return forceAlpha ? new OMColor(value) : new Color(value);
        }
        try {
            return (Color)OMColor.alphaValueConstructor.newInstance(new Integer(value), new Boolean(true));
        }
        catch (Exception e) {
            System.err.println("ColorFactory.parseColor(): internal error...");
            return forceAlpha ? new OMColor(value) : new Color(value);
        }
    }

    public static String getHexColorString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | color.getAlpha() << 24);
    }
}

