/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropertyStringFormatException;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;

public class PropUtils {
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    public static final String whiteSpaceChars = " \t\r\n\f";
    public static final String propertySeparators = "&";

    public static Vector parseSpacedMarkers(String markerList) {
        return PropUtils.parseMarkers(markerList, " ");
    }

    public static Vector parseMarkers(String markerList, String delim) {
        Vector<String> vector = null;
        if (markerList == null) {
            Debug.message("propertiesdetail", "PropUtils: marker list null!");
            return new Vector(0);
        }
        if (Debug.debugging("propertiesdetail")) {
            Debug.output("PropertyHandler: parsing marker list |" + markerList + "|");
        }
        markerList = markerList.replace('\"', '\u0000');
        StringTokenizer tokens = new StringTokenizer(markerList, delim);
        vector = new Vector<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().trim();
            vector.addElement(name);
        }
        return vector;
    }

    public static Properties parsePropertyList(String list) throws PropertyStringFormatException {
        return PropUtils.parsePropertyList(list, propertySeparators, keyValueSeparators);
    }

    public static Properties parsePropertyList(String list, String propertySeparators, String keyValueSeparators) throws PropertyStringFormatException {
        Properties props = new Properties();
        Vector keyValuePairs = PropUtils.parseMarkers(list, propertySeparators);
        int i = 0;
        while (i < keyValuePairs.size()) {
            StringTokenizer tokens = new StringTokenizer((String)keyValuePairs.elementAt(i), keyValueSeparators);
            try {
                String key = tokens.nextToken().trim();
                String value = tokens.nextToken().trim();
                props.put(key, value);
            }
            catch (NoSuchElementException nsee) {
                throw new PropertyStringFormatException(list);
            }
            ++i;
        }
        return props;
    }

    public static void copyProperties(Properties from, Properties to) {
        Enumeration<Object> keys = from.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            to.put(key, from.getProperty(key));
        }
    }

    public static boolean loadProperties(Properties props, String dir, String file) {
        block5: {
            File propsFile = new File(dir, file);
            try {
                FileInputStream propsStream = new FileInputStream(propsFile);
                props.load(propsStream);
                if (Debug.debugging("properties")) {
                    Debug.output("PropUtils: Found " + propsFile);
                }
                return true;
            }
            catch (FileNotFoundException e) {
                if (!Debug.debugging("properties")) break block5;
                Debug.output("PropUtils: File not found -  \"" + propsFile + "\"");
            }
            catch (IOException e) {
                Debug.error("PropUtils: Caught IO Exception reading \"" + propsFile + "\"");
                e.printStackTrace();
            }
            catch (AccessControlException ace) {}
            {
            }
        }
        return false;
    }

    public static boolean loadProperties(Properties properties, InputStream propsIn) {
        try {
            properties.load(propsIn);
            return true;
        }
        catch (IOException e) {
            if (Debug.debugging("properties")) {
                Debug.error("PropUtils: Caught IOException loading properties from InputStream.");
            }
            return false;
        }
    }

    public static Properties promptUserForProperties() {
        JFileChooser fileChooser = new JFileChooser();
        int retvalue = fileChooser.showOpenDialog(null);
        Properties props = new Properties();
        if (retvalue != 0) {
            return props;
        }
        try {
            FileInputStream inputStream = new FileInputStream(fileChooser.getSelectedFile());
            props.load(inputStream);
            return props;
        }
        catch (Exception ioe) {
            System.err.println("PropUtils.promptUserForProperties: Exception reading properties file.");
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
            return props;
        }
    }

    public static String getScopedPropertyPrefix(PropertyConsumer pc) {
        return PropUtils.getScopedPropertyPrefix(pc.getPropertyPrefix());
    }

    public static String getScopedPropertyPrefix(String pre) {
        if (pre == null) {
            return "";
        }
        if (pre.endsWith(".")) {
            return pre;
        }
        return pre + ".";
    }

    public static String unnull(String prop) {
        if (prop == null) {
            return "";
        }
        return prop;
    }

    public static String[] initPathsFromProperties(Properties p, String propName) {
        return PropUtils.stringArrayFromProperties(p, propName, ";");
    }

    public static int intFromProperties(Properties p, String propName, int defaultValue) {
        int ret;
        block2: {
            ret = defaultValue;
            String intString = p.getProperty(propName);
            if (intString == null) break block2;
            try {
                ret = Integer.parseInt(intString);
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static float floatFromProperties(Properties p, String propName, float defaultValue) {
        float ret;
        block2: {
            ret = defaultValue;
            String floatString = p.getProperty(propName);
            if (floatString == null) break block2;
            try {
                ret = Float.valueOf(floatString).floatValue();
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static boolean booleanFromProperties(Properties p, String propName, boolean defaultValue) {
        boolean ret = defaultValue;
        String booleanString = p.getProperty(propName);
        if (booleanString != null) {
            ret = booleanString.toLowerCase().equals("true");
        }
        return ret;
    }

    public static Object objectFromProperties(Properties p, String propName) {
        Object ret;
        block4: {
            ret = null;
            String objectName = p.getProperty(propName);
            if (objectName == null) break block4;
            try {
                ret = Class.forName(objectName).newInstance();
            }
            catch (InstantiationException e) {
                ret = null;
            }
            catch (IllegalAccessException e) {
                ret = null;
            }
            catch (ClassNotFoundException e) {
                ret = null;
            }
        }
        return ret;
    }

    public static String[] stringArrayFromProperties(Properties p, String propName, String tok) {
        String[] ret = null;
        String raw = p.getProperty(propName);
        if (raw != null) {
            try {
                StringTokenizer token = new StringTokenizer(raw, tok);
                int numPaths = token.countTokens();
                ret = new String[numPaths];
                int i = 0;
                while (i < numPaths) {
                    ret[i] = token.nextToken();
                    ++i;
                }
                return ret;
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static double doubleFromProperties(Properties p, String propName, double defaultValue) {
        double ret;
        block2: {
            ret = defaultValue;
            String doubleString = p.getProperty(propName);
            if (doubleString == null) break block2;
            try {
                ret = Double.valueOf(doubleString);
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static Color parseColorFromProperties(Properties p, String propName, String dfault) throws NumberFormatException {
        return ColorFactory.parseColorFromProperties(p, propName, dfault, false);
    }

    public static Paint parseColorFromProperties(Properties p, String propName, Paint dfault) throws NumberFormatException {
        return ColorFactory.parseColorFromProperties(p, propName, dfault);
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        return ColorFactory.parseColor(colorString, false);
    }

    public static String[] getPropertiesAsStringArray(Properties props) {
        int size = props.size();
        String[] ret = new String[size * 2];
        int count = 0;
        Enumeration<?> things = props.propertyNames();
        while (things.hasMoreElements()) {
            ret[count] = (String)things.nextElement();
            ret[count + 1] = props.getProperty(ret[count]);
            count += 2;
        }
        return ret;
    }

    public static URL getResourceOrFileOrURL(String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(null, name);
    }

    public static URL getResourceOrFileOrURL(Object askingClass, String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(askingClass.getClass(), name);
    }

    public static URL getResourceOrFileOrURL(Class askingClass, String name) throws MalformedURLException {
        boolean DEBUG = Debug.debugging("proputils");
        if (name == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): null file name");
            }
            return null;
        }
        URL retval = null;
        if (DEBUG) {
            Debug.output("PropUtils.getROFOU(): looking for " + name);
        }
        if (askingClass != null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking as resource");
            }
            retval = askingClass.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking in general classpath");
            }
            retval = Thread.currentThread().getContextClassLoader().getResource(name);
        }
        if (retval == null && !Environment.isApplet()) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking with ClassLoader");
            }
            retval = ClassLoader.getSystemResource("share/" + name);
        }
        if (retval == null && Environment.isApplet()) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking with URLClassLoader");
            }
            URL[] cba = new URL[]{Environment.getApplet().getCodeBase()};
            URLClassLoader ucl = URLClassLoader.newInstance(cba);
            retval = ucl.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): not found as resource");
            }
            try {
                File file = new File(name);
                if (file.exists()) {
                    retval = file.toURL();
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): found as file :)");
                    }
                } else {
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): Not a file, checking as URL");
                    }
                    retval = new URL(name);
                    InputStream is = retval.openStream();
                    is.close();
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): OK as URL :)");
                    }
                }
            }
            catch (IOException ioe) {
                retval = null;
            }
            catch (AccessControlException ace) {
                Debug.error("PropUtils: AccessControlException trying to access " + name);
                retval = null;
            }
            catch (Exception e) {
                Debug.error("PropUtils: caught exception " + e.getMessage());
                retval = null;
            }
        }
        if (DEBUG) {
            if (retval != null) {
                Debug.output("Resource " + name + "=" + retval.toString());
            } else {
                Debug.output("Resource " + name + " can't be found...");
            }
        }
        return retval;
    }
}

