/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMColorChooser;
import com.bbn.openmap.util.ColorFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ColorPropertyEditor
extends PropertyEditorSupport {
    JButton button = new JButton("Select color...");
    public static final String title = "Select color...";

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color startingColor;
                try {
                    startingColor = ColorFactory.parseColor(ColorPropertyEditor.this.getAsText(), true);
                }
                catch (NumberFormatException nfe) {
                    startingColor = OMColor.clear;
                }
                Color color = OMColorChooser.showDialog(ColorPropertyEditor.this.button, ColorPropertyEditor.title, startingColor);
                ColorPropertyEditor.this.setValue(color);
            }
        });
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        gridbag.setConstraints(this.button, c);
        panel.add(this.button);
        return panel;
    }

    public void setValue(Object someObj) {
        if (someObj instanceof String) {
            this.button.setText((String)someObj);
        } else if (someObj instanceof Color) {
            this.button.setText(Integer.toHexString(((Color)someObj).getRGB()));
        }
    }

    public String getAsText() {
        return this.button.getText();
    }

    public void actionPerformed(ActionEvent e) {
    }
}

