/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.examples.PicoIX;
import ix.util.Debug;
import ix.util.Predicate2;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.Hashtable;

public class PicoISim
extends PicoIX {
    static Symbol SYM(String string) {
        return Symbol.intern(string);
    }

    static abstract class SimEventHandler
    extends PicoIX.ActivityHandler {
        SimEventHandler(Object object) {
            super(object);
        }

        boolean isAble(SimEvent simEvent) {
            return true;
        }

        long getSimTime() {
            return ((IX_Simulator)this.system).simTime;
        }

        void postSimEvent(SimEvent simEvent) {
            ((IX_Simulator)this.system).postSimEvent(simEvent);
        }
    }

    static class SimEvent
    extends PicoIX.Activity {
        long est = 0L;

        SimEvent(Object object, Object object2, long l) {
            super(object, object2);
            this.est = l;
        }

        void execute(IX_Simulator iX_Simulator) {
        }

        public String toString() {
            return "SimEvent[" + Lisp.printToString(this.verb) + " " + Lisp.printToString(this.object) + " at " + this.est + "]";
        }
    }

    static class SimController
    extends PicoIX.Controller {
        LListCollector simEvents = new LListCollector();
        Hashtable simHandlerTable = new Hashtable();
        static final Predicate2 EARLIER_EST_P = new Predicate2(){

            public boolean trueOf(Object object, Object object2) {
                return ((SimEvent)object).est < ((SimEvent)object2).est;
            }
        };

        SimController() {
        }

        SimController(PicoIX.IX_System iX_System) {
            super(iX_System);
        }

        void addSimEvent(SimEvent simEvent) {
            Debug.noteln("Scheduling", (Object)simEvent);
            this.simEvents.insertElement(simEvent, EARLIER_EST_P);
        }

        void mainLoop() {
            while (true) {
                if (this.q.hasMessage()) {
                    this.addEventActivity(this.q);
                    continue;
                }
                if (!this.activities.isEmpty()) {
                    this.handleActivity(this.selectActivity());
                    continue;
                }
                if (!this.simEvents.isEmpty()) {
                    boolean bl = this.simulateIfPossible();
                    if (bl) continue;
                    this.q.waitForMessage();
                    continue;
                }
                this.whenIdle();
            }
        }

        void whenIdle() {
            if (((IX_Simulator)this.system).stopWhenIdle) {
                Debug.noteln("Simulator stopping because nothing to do");
                this.system.stop();
                Debug.expect(false, "continued after thread stop()");
            } else {
                this.q.waitForMessage();
            }
        }

        boolean simulateIfPossible() {
            Debug.noteln("Agenda", (Object)this.simEvents.contents());
            for (LList lList = this.simEvents.contents(); lList != Lisp.NIL; lList = lList.cdr()) {
                SimEvent simEvent = (SimEvent)lList.car();
                if (!this.canSimulate(simEvent)) continue;
                return this.simulateIfPossible(simEvent);
            }
            return false;
        }

        boolean simulateIfPossible(SimEvent simEvent) {
            this.simEvents.deleteElement(simEvent);
            this.setSimTime(simEvent.est);
            this.simulate(simEvent);
            return true;
        }

        boolean canSimulate(SimEvent simEvent) {
            SimEventHandler simEventHandler = this.findSimHandler(simEvent);
            if (simEventHandler.isAble(simEvent)) {
                return true;
            }
            Debug.noteln("Can't execute " + simEvent + " at this time");
            return false;
        }

        void simulate(SimEvent simEvent) {
            SimEventHandler simEventHandler = this.findSimHandler(simEvent);
            simEventHandler.handleActivity(simEvent);
        }

        void installSimEventHandlers(Object[] objectArray) {
            this.installActivityHandlers(objectArray, this.simHandlerTable);
        }

        SimEventHandler findSimHandler(PicoIX.Activity activity) {
            SimEventHandler simEventHandler = (SimEventHandler)this.simHandlerTable.get(activity.verb);
            Debug.expect(simEventHandler != null, "no sim handler for", activity.verb);
            return simEventHandler;
        }

        long getSimTime() {
            return ((IX_Simulator)this.system).simTime;
        }

        void setSimTime(long l) {
            ((IX_Simulator)this.system).setSimTime(l);
        }
    }

    static class IX_Simulator
    extends PicoIX.IX_System {
        long simTime = -1L;
        boolean stopWhenIdle = true;

        IX_Simulator() {
            this.controller = new SimController(this);
            this.model = new PicoIX.ModelManager(this);
            this.addActivityHandlers(this.makeBuiltinActivityHandlers());
            this.addSimEventHandlers(this.makeBuiltinSimEventHandlers());
        }

        IX_Simulator(PicoIX.Controller controller, PicoIX.ModelManager modelManager) {
            super(controller != null ? controller : new SimController(), modelManager);
            this.addActivityHandlers(this.makeBuiltinActivityHandlers());
            this.addSimEventHandlers(this.makeBuiltinSimEventHandlers());
        }

        public void addSimEventHandlers(Object[] objectArray) {
            ((SimController)this.controller).installSimEventHandlers(objectArray);
        }

        public void setStopWhenIdle(boolean bl) {
            this.stopWhenIdle = bl;
        }

        public void schedule(SimEvent simEvent) {
            this.newEvent(new PicoIX.Activity(PicoISim.SYM("schedule"), simEvent));
        }

        public void start() {
            this.setSimTime(0L);
            super.start();
        }

        void setSimTime(long l) {
            if (l > this.simTime) {
                Debug.noteln("\n- - - - - time now " + l + " - - - - -\n");
                this.simTime = l;
            }
        }

        void postSimEvent(SimEvent simEvent) {
            ((SimController)this.controller).addSimEvent(simEvent);
        }

        Object[] makeBuiltinActivityHandlers() {
            return new Object[]{new PicoIX.ActivityHandler(PicoISim.SYM("schedule")){

                void handleActivity(PicoIX.Activity activity) {
                    SimEvent simEvent = (SimEvent)activity.object;
                    ((IX_Simulator)this.system).postSimEvent(simEvent);
                }
            }};
        }

        Object[] makeBuiltinSimEventHandlers() {
            return new Object[0];
        }
    }
}

