/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.examples.PicoISim;
import ix.examples.PicoIX;
import ix.util.Debug;
import ix.util.Util;

public class PicoISimTest2
extends PicoISim {
    public static void main(String[] stringArray) {
        final TestSimulator testSimulator = new TestSimulator();
        testSimulator.setStopWhenIdle(false);
        testSimulator.setListener(new PicoIX.IX_SystemListener());
        testSimulator.schedule(new PicoISim.SimEvent("return", "foo", 15L));
        testSimulator.schedule(new PicoISim.SimEvent("return", "pre-foo", 10L));
        testSimulator.start();
        new Thread(){

            public void run() {
                while (true) {
                    Util.readLine(System.in);
                    testSimulator.schedule(new PicoISim.SimEvent("return", "ok", 0L));
                }
            }
        }.start();
    }

    static class TestSimController
    extends PicoISim.SimController {
        TestSimController() {
        }

        boolean simulateIfPossible(PicoISim.SimEvent simEvent) {
            long l = System.currentTimeMillis();
            long l2 = this.getSimTime();
            if (simEvent.est > l2) {
                long l3;
                long l4 = l3 = simEvent.est - l2;
                Debug.noteln("... sleeping " + l4 + " seconds ...");
                if (this.q.waitForMessage(l4 * 1000L)) {
                    long l5 = System.currentTimeMillis() - l;
                    long l6 = Math.round(l5 / 1000L);
                    Debug.noteln("But something happened after " + l6);
                    this.setSimTime(l2 + l6);
                    return false;
                }
            }
            return super.simulateIfPossible(simEvent);
        }
    }

    static class TestSimulator
    extends PicoISim.IX_Simulator {
        TestSimulator() {
            super(new TestSimController(), null);
        }

        Object[] makeBuiltinSimEventHandlers() {
            return new Object[]{new PicoISim.SimEventHandler("return"){

                void handleActivity(PicoIX.Activity activity) {
                    this.system.notifyListener(activity.object);
                }
            }};
        }
    }
}

