/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.Annotated;
import ix.icore.Annotations;
import ix.icore.event.AnnotationEvent;
import ix.icore.event.AnnotationListener;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractAnnotatedObject
implements Annotated,
Serializable {
    protected Annotations annotations;
    protected List annotationListeners = new LinkedList();
    private static final Symbol S_COMMENTS = Symbol.intern("comments");

    protected Map annMap() {
        return this.annotations;
    }

    protected void makeAnnMap() {
        Debug.expect(this.annotations == null);
        this.annotations = new Annotations();
    }

    public Annotations getAnnotations() {
        Map map = this.annMap();
        return map == null ? null : (map.isEmpty() ? null : (map instanceof Annotations ? (Annotations)map : new Annotations(map)));
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    public Object getAnnotation(Object object) {
        Map map = this.annMap();
        if (map != null) {
            return map.get(object);
        }
        return null;
    }

    public void setAnnotation(Object object, Object object2) {
        Map map = this.annMap();
        if (map == null) {
            this.makeAnnMap();
            map = this.annMap();
        }
        map.put(object, object2);
        this.fireSetAnnotation(object, object2);
    }

    public void removeAnnotation(Object object) {
        Object object2 = this.getAnnotation(object);
        Debug.expect(object2 != null, "Deleting valueless key", object);
        this.annMap().remove(object);
        this.fireSetAnnotation(object, null);
    }

    public void clearAnnotations() {
        if (this.annMap() != null) {
            this.annMap().clear();
        }
    }

    public void takeAnnotations(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public String getComments() {
        return (String)this.getAnnotation(S_COMMENTS);
    }

    public void setComments(String string) {
        if (string != null) {
            this.setAnnotation(S_COMMENTS, string);
        } else if (this.getAnnotation(S_COMMENTS) != null) {
            this.removeAnnotation(S_COMMENTS);
        }
    }

    public void addAnnotationListener(AnnotationListener annotationListener) {
        this.annotationListeners.add(annotationListener);
    }

    public void fireSetAnnotation(Object object, Object object2) {
        if (!this.annotationListeners.isEmpty()) {
            AnnotationEvent annotationEvent = new AnnotationEvent(this, object, object2);
            for (AnnotationListener annotationListener : this.annotationListeners) {
                annotationListener.setAnnotation(annotationEvent);
            }
        }
    }
}

