/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.domain.Constraint;
import ix.util.lisp.Symbol;

public class GenericConstraint
extends AbstractAnnotatedObject {
    protected Symbol type;
    protected Symbol relation;
    protected String form;
    protected Object example;

    public GenericConstraint(Symbol symbol, Symbol symbol2) {
        if (symbol == null) {
            throw new NullPointerException("Trying to make GenericConstraint from null type");
        }
        this.type = symbol;
        this.relation = symbol2;
    }

    public GenericConstraint(Constraint constraint) {
        if (constraint != null) {
            if (constraint.getType() == null) {
                throw new NullPointerException("Trying to make GenericConstraint from illegal constraint (null type) " + constraint.toString());
            }
        } else {
            throw new NullPointerException("Trying to make GenericConstraint from null constraint");
        }
        this.setType(constraint.getType());
        this.setRelation(constraint.getRelation());
        this.setExample(constraint.getParameters());
    }

    public GenericConstraint(String string, String string2) {
        this(Symbol.intern(string), Symbol.intern(string2));
    }

    public Symbol getType() {
        return this.type;
    }

    public void setType(Symbol symbol) {
        this.type = symbol;
    }

    public Symbol getRelation() {
        return this.relation;
    }

    public void setRelation(Symbol symbol) {
        this.relation = symbol;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String string) {
        this.form = string;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object object) {
        this.example = object;
    }

    public boolean hasForm() {
        return this.form != null && this.form != "";
    }

    public boolean hasExample() {
        return this.example != null;
    }

    public String toString() {
        String string = this.type + " - " + this.relation + ": " + this.form;
        if (this.example != null) {
            string = string + " (e.g. " + this.example + ")";
        }
        return string;
    }
}

