/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.AbstractIXObject;
import ix.icore.Annotations;
import ix.icore.Issue;
import ix.icore.LinkedListOfIssue;
import ix.icore.ListOfIssue;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.LinkedListOfNodeSpec;
import ix.icore.domain.LinkedListOfOrdering;
import ix.icore.domain.LinkedListOfPatternAssignment;
import ix.icore.domain.LinkedListOfVariableDeclaration;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.MissingValuesException;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.SyntaxException;
import ix.iplan.ServiceSymbols;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.Name;
import ix.util.ObjectWalker;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.StructuralEquality;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Refinement
extends AbstractIXObject
implements Named,
Cloneable {
    protected String name;
    protected LList pattern;
    protected ListOfVariableDeclaration variableDeclarations;
    protected ListOfNodeSpec nodes;
    protected ListOfOrdering orderings;
    protected ListOfConstraint constraints;
    protected ListOfIssue issues;
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    public static final Symbol S_COMPUTE = Symbol.intern("compute");
    public static final Symbol S_MULTIPLE_ANSWER = Symbol.intern("multiple-answer");
    public static final Symbol S_SELF = Symbol.intern("self");

    public Refinement() {
    }

    public Refinement(String string, LList lList) {
        this.name = string;
        this.pattern = lList;
        Debug.noteln("New blank refinement " + Util.quote(string) + " for", (Object)lList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
    }

    public ListOfVariableDeclaration getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public void setVariableDeclarations(ListOfVariableDeclaration listOfVariableDeclaration) {
        this.variableDeclarations = listOfVariableDeclaration;
    }

    public ListOfNodeSpec getNodes() {
        return this.nodes;
    }

    public void setNodes(ListOfNodeSpec listOfNodeSpec) {
        this.nodes = listOfNodeSpec;
    }

    public ListOfOrdering getOrderings() {
        return this.orderings;
    }

    public void setOrderings(ListOfOrdering listOfOrdering) {
        this.orderings = listOfOrdering;
    }

    public ListOfConstraint getConstraints() {
        return this.constraints;
    }

    public void setConstraints(ListOfConstraint listOfConstraint) {
        this.constraints = listOfConstraint;
    }

    public ListOfIssue getIssues() {
        return this.issues;
    }

    public void setIssues(ListOfIssue listOfIssue) {
        this.issues = listOfIssue;
    }

    public String getComments() {
        String string = super.getComments();
        return string == null ? "" : string;
    }

    public void setVariableDeclarations(List list) {
        this.setVariableDeclarations(list == null ? null : new LinkedListOfVariableDeclaration((Collection)list));
    }

    public void setNodes(List list) {
        this.setNodes(list == null ? null : new LinkedListOfNodeSpec((Collection)list));
    }

    public void setOrderings(List list) {
        this.setOrderings(list == null ? null : new LinkedListOfOrdering((Collection)list));
    }

    public void setConstraints(List list) {
        this.setConstraints(list == null ? null : new LinkedListOfConstraint((Collection)list));
    }

    public void setIssues(List list) {
        this.setIssues(list == null ? null : new LinkedListOfIssue((Collection)list));
    }

    public ListOfConstraint getFilterConstraints() {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        Iterator iterator = Collect.iterator(this.constraints);
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint.getType() != S_COMPUTE && (constraint.getType() != S_WORLD_STATE || constraint.getRelation() != S_CONDITION)) continue;
            linkedListOfConstraint.add(constraint);
        }
        return linkedListOfConstraint;
    }

    public ListOfPatternAssignment getConditions() {
        LinkedListOfPatternAssignment linkedListOfPatternAssignment = new LinkedListOfPatternAssignment();
        Iterator iterator = Collect.iterator(this.constraints);
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint.getType() != S_WORLD_STATE || constraint.getRelation() != S_CONDITION) continue;
            PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
            linkedListOfPatternAssignment.add(patternAssignment);
        }
        return linkedListOfPatternAssignment;
    }

    public ListOfPatternAssignment getEffects() {
        LinkedListOfPatternAssignment linkedListOfPatternAssignment = new LinkedListOfPatternAssignment();
        Iterator iterator = Collect.iterator(this.constraints);
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint.getType() != S_WORLD_STATE || constraint.getRelation() != S_EFFECT) continue;
            PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
            linkedListOfPatternAssignment.add(patternAssignment);
        }
        return linkedListOfPatternAssignment;
    }

    public ListOfConstraint getConstraints(Symbol symbol, Symbol symbol2) {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.getType() != symbol || constraint.getRelation() != symbol2) continue;
                linkedListOfConstraint.add(constraint);
            }
        }
        return linkedListOfConstraint;
    }

    public ListOfConstraint getConditionConstraints() {
        return this.getConstraints(S_WORLD_STATE, S_CONDITION);
    }

    public ListOfConstraint getEffectConstraints() {
        return this.getConstraints(S_WORLD_STATE, S_EFFECT);
    }

    public ListOfConstraint getOtherConstraints() {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        Iterator iterator = Collect.iterator(this.constraints);
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint.getType() == S_WORLD_STATE || constraint.getType() == S_COMPUTE || constraint.getType() == Ordering.S_TEMPORAL) continue;
            linkedListOfConstraint.add(constraint);
        }
        return linkedListOfConstraint;
    }

    public void checkConsistency() {
        this.checkNodeRefs();
        this.checkInputsAndOutputs();
    }

    protected void checkVariableRefs() {
        SortedSet sortedSet = this.getDeclaredVariables();
        SortedSet sortedSet2 = this.getVariablesUsed();
        Set set = (Set)Collect.difference(sortedSet2, sortedSet);
        Set set2 = (Set)Collect.difference(sortedSet, sortedSet2);
        Debug.noteln("Declared", (Object)sortedSet);
        Debug.noteln("Used", (Object)sortedSet2);
        Debug.noteln("Undeclared", (Object)set);
        Debug.noteln("Unused", (Object)set2);
        Debug.expectEquals(sortedSet2, this.getVariablesUsed2());
        if (!set2.isEmpty() && !set.isEmpty()) {
            throw new SyntaxException("Incorrect variable declarations in refinement " + this.name + ".  Declared but not used: " + Strings.conjunction(set2) + ".  Used but not declared: " + Strings.conjunction(set) + ".");
        }
        if (!set2.isEmpty()) {
            throw new SyntaxException("Unused variables in refinement " + this.name + ": " + Strings.conjunction(set2));
        }
        if (!set.isEmpty()) {
            throw new SyntaxException("Undeclared variables in refinement " + this.name + ": " + Strings.conjunction(set));
        }
    }

    public SortedSet getVariablesUsed() {
        final TreeSet treeSet = new TreeSet();
        this.instantiate(Matcher.emptyEnv, new Function1(){

            public Object funcall(Object object) {
                ItemVar itemVar = (ItemVar)object;
                treeSet.add(itemVar);
                return object;
            }
        });
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedSet getVariablesUsed2() {
        ListOfVariableDeclaration listOfVariableDeclaration = this.variableDeclarations;
        this.variableDeclarations = null;
        try {
            SortedSet sortedSet = (SortedSet)ObjectWalker.collectIf(this, new TreeSet(), Fn.isInstanceOf(ItemVar.class));
            return sortedSet;
        }
        finally {
            this.variableDeclarations = listOfVariableDeclaration;
        }
    }

    public SortedSet getDeclaredVariables() {
        return (SortedSet)Collect.map(new TreeSet(), Collect.ensureList(this.variableDeclarations), Fn.accessor(VariableDeclaration.class, "getName"));
    }

    protected boolean isDeclared(ItemVar itemVar) {
        if (this.variableDeclarations == null) {
            return false;
        }
        for (VariableDeclaration variableDeclaration : this.variableDeclarations) {
            if (variableDeclaration.getName() != itemVar) continue;
            return true;
        }
        return false;
    }

    protected void checkNodeRefs() {
        HashSet<Name> hashSet = new HashSet<Name>();
        TreeSet treeSet = new TreeSet();
        Iterator iterator = Collect.iterator(this.getNodes());
        while (iterator.hasNext()) {
            hashSet.add(((NodeSpec)iterator.next()).getId());
        }
        this.collectUndefinedNodeRefs(this.getOrderings(), hashSet, treeSet);
        this.collectUndefinedNodeRefs(this.getConstraints(), hashSet, treeSet);
        if (!treeSet.isEmpty()) {
            throw new SyntaxException("There are references to undefined nodes in refinement " + this.name + ": " + Strings.conjunction(treeSet));
        }
    }

    private void collectUndefinedNodeRefs(Object object, final Set set, final Set set2) {
        if (object == null) {
            return;
        }
        ObjectWalker objectWalker = new ObjectWalker(){

            public void walk(Object object) {
                if (object instanceof NodeEndRef) {
                    Name name = ((NodeEndRef)object).getNode();
                    if (!"self".equals(name.toString()) && !set.contains(name)) {
                        set2.add(name);
                    }
                } else {
                    super.walk(object);
                }
            }
        };
        objectWalker.walk(object);
    }

    protected void checkInputsAndOutputs() {
        this.checkParametersAgainstConstraints(ServiceSymbols.S_INPUT_OBJECTS, this.getConditions());
        this.checkParametersAgainstConstraints(ServiceSymbols.S_OUTPUT_OBJECTS, this.getEffects());
    }

    protected void checkParametersAgainstConstraints(Symbol symbol, List list) {
        Symbol symbol2;
        Object object;
        List list2 = (List)this.getAnnotation(symbol);
        if (list2 == null) {
            return;
        }
        HashMap<ItemVar, Symbol> hashMap = new HashMap<ItemVar, Symbol>();
        for (Object object2 : list) {
            List list3 = ((PatternAssignment)object2).getPattern();
            if (list3.size() != 2 || list3.get(0) != ServiceSymbols.S_TYPE || !((object = list3.get(1)) instanceof ItemVar)) continue;
            symbol2 = (ItemVar)object;
            if (!(((PatternAssignment)object2).getValue() instanceof Symbol)) continue;
            hashMap.put((ItemVar)symbol2, (Symbol)((PatternAssignment)object2).getValue());
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (List list3 : list2) {
            Symbol symbol3;
            object = Util.mustBe(ItemVar.class, list3.get(0));
            symbol2 = Util.mustBe(Symbol.class, list3.get(1));
            if (symbol2 == (symbol3 = (Symbol)hashMap.get(object))) continue;
            linkedHashMap.put(object, symbol3);
        }
        if (!linkedHashMap.isEmpty()) {
            throw new SyntaxException("The " + symbol + " annotation did not match the constraints." + "  Mismatches: " + linkedHashMap);
        }
    }

    public Refinement instantiate(MatchEnv matchEnv) {
        final TreeSet treeSet = new TreeSet();
        Refinement refinement = this.instantiate(matchEnv, new Function1(){

            public Object funcall(Object object) {
                ItemVar itemVar = (ItemVar)object;
                treeSet.add(itemVar);
                return itemVar;
            }
        });
        if (treeSet.isEmpty()) {
            return refinement;
        }
        throw new MissingValuesException(treeSet);
    }

    public Refinement instantiate(MatchEnv matchEnv, Function1 function1) {
        try {
            Object object;
            Object object2;
            Refinement refinement = (Refinement)this.clone();
            Debug.expect(new StructuralEquality().equal(this, refinement));
            refinement.pattern = (LList)matchEnv.instantiateTree(refinement.pattern, function1);
            if (refinement.nodes != null) {
                refinement.nodes = new LinkedListOfNodeSpec((Collection)refinement.nodes);
                object2 = refinement.nodes.listIterator();
                while (object2.hasNext()) {
                    object = (NodeSpec)object2.next();
                    object2.set(((NodeSpec)object).instantiate(matchEnv, function1));
                }
            }
            if (refinement.issues != null) {
                refinement.issues = new LinkedListOfIssue((Collection)refinement.issues);
                object2 = refinement.issues.listIterator();
                while (object2.hasNext()) {
                    object = (Issue)object2.next();
                    object2.set(((Issue)object).instantiate(matchEnv, function1));
                }
            }
            if (refinement.constraints != null) {
                refinement.constraints = new LinkedListOfConstraint((Collection)refinement.constraints);
                object2 = refinement.constraints.listIterator();
                while (object2.hasNext()) {
                    object = (Constraint)object2.next();
                    object2.set(((Constraint)object).instantiate(matchEnv, function1));
                }
            }
            if (refinement.getAnnotations() != null) {
                refinement.setAnnotations((Annotations)refinement.getAnnotations().clone());
                object2 = refinement.getAnnotation(ServiceSymbols.S_INPUT_OBJECTS);
                if (object2 != null) {
                    refinement.setAnnotation(ServiceSymbols.S_INPUT_OBJECTS, matchEnv.instantiate(object2, function1));
                }
                if ((object = refinement.getAnnotation(ServiceSymbols.S_OUTPUT_OBJECTS)) != null) {
                    refinement.setAnnotation(ServiceSymbols.S_OUTPUT_OBJECTS, matchEnv.instantiate(object, function1));
                }
            }
            return refinement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RethrownException(cloneNotSupportedException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Refinement[" + this.name + " expands " + this.pattern + "]";
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = ((Refinement)object).getName();
            String string2 = ((Refinement)object2).getName();
            return string.compareTo(string2);
        }
    }
}

