/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.Variable;
import ix.util.ConsistencyException;
import ix.util.Duration;
import ix.util.Inf;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Symbol;
import java.io.Serializable;

public class TimeWindow
implements Serializable {
    protected Object min;
    protected Object max;

    public TimeWindow() {
    }

    public TimeWindow(Object object, Object object2) {
        this.setMin(object);
        this.setMax(object2);
    }

    public TimeWindow(Duration duration, Duration duration2) {
        this.min = duration;
        this.max = duration2;
        this.checkRange();
    }

    public Duration getMinDuration() {
        return (Duration)this.min;
    }

    public Duration getMaxDuration() {
        return (Duration)this.max;
    }

    public long getMinMilliseconds() {
        return ((Duration)this.min).asMilliseconds();
    }

    public long getMaxMilliseconds() {
        return this.max == null ? Long.MAX_VALUE : ((Duration)this.max).asMilliseconds();
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object object) {
        this.min = this.toDurationIfPossible(object);
        this.checkRange();
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object object) {
        this.max = (object instanceof Symbol || object instanceof String) && Inf.isInfName(object) ? null : this.toDurationIfPossible(object);
        this.checkRange();
    }

    public boolean hasUnboundedMax() {
        return this.max == null;
    }

    private void checkRange() {
        if (this.min instanceof Duration && this.max instanceof Duration && ((Duration)this.min).compareTo((Duration)this.max) > 0) {
            throw new ConsistencyException("Min duration " + this.min + " is not <= max duration " + this.max);
        }
    }

    private Object toDurationIfPossible(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof Duration) {
            return object;
        }
        if (object instanceof ItemVar || object instanceof Variable) {
            return object;
        }
        if (object instanceof String) {
            return new Duration((String)object);
        }
        if (object instanceof Symbol) {
            return new Duration(object.toString());
        }
        if (object instanceof Number) {
            return new Duration(((Number)object).longValue());
        }
        throw new ClassCastException("Invalid duration: " + object);
    }

    public String toString() {
        if (this.min instanceof Duration) {
            return "TimeWindow[" + this.getMinDuration().toISOString() + ".." + (this.hasUnboundedMax() ? "inf" : this.getMaxDuration().toISOString()) + "]";
        }
        return "TimeWindow[" + this.min + ".." + this.max + "]";
    }
}

