/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.log;

import ix.icore.log.HistoryEvent;
import ix.util.Debug;
import ix.util.RethrownIOException;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLogReader {
    public List<HistoryEvent> readLog(String string) {
        try {
            return this.do_readLog(string);
        }
        catch (IOException iOException) {
            throw new RethrownIOException(iOException);
        }
    }

    protected List<HistoryEvent> do_readLog(String string) throws IOException {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        LinkedList<HistoryEvent> linkedList = new LinkedList<HistoryEvent>();
        while ((string2 = this.readBlock(bufferedReader)) != null) {
            if ((string2 = string2.trim()).equals("")) continue;
            HistoryEvent historyEvent = (HistoryEvent)XML.objectFromXML(string2);
            linkedList.add(historyEvent);
        }
        return linkedList;
    }

    protected String readBlock(BufferedReader bufferedReader) {
        StringBuffer stringBuffer;
        block2: {
            String string = this.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            stringBuffer = new StringBuffer();
            do {
                stringBuffer.append(string);
                stringBuffer.append("\n");
                string = this.readLine(bufferedReader);
                if (string == null) break block2;
            } while (!string.startsWith("</"));
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected String readLine(BufferedReader bufferedReader) {
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Debug.displayException(iOException);
            return null;
        }
    }
}

