/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.log;

import ix.icore.log.BindingEvent;
import ix.icore.log.HistoryComment;
import ix.icore.log.HistoryEvent;
import ix.icore.log.MessageReceived;
import ix.icore.log.MessageSent;
import ix.iface.util.Reporting;
import ix.ip2.log.ItemHandledEvent;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class PrintEventLog {
    private String logFileName;
    private BufferedReader in;
    protected PrintStream out = System.out;

    public static void main(String[] stringArray) throws Exception {
        Parameters.processCommandLineArguments(stringArray);
        new PrintEventLog().run();
    }

    protected void processCommandLineArguments() {
        this.logFileName = Parameters.getParameter("log");
    }

    protected void run() throws Exception {
        String string;
        this.processCommandLineArguments();
        FileInputStream fileInputStream = new FileInputStream(this.logFileName);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        this.in = new BufferedReader(inputStreamReader);
        while ((string = this.readBlock(this.in)) != null) {
            if ((string = string.trim()).equals("")) continue;
            HistoryEvent historyEvent = (HistoryEvent)XML.objectFromXML(string);
            this.describeEvent(historyEvent);
        }
    }

    private String readBlock(BufferedReader bufferedReader) {
        StringBuffer stringBuffer;
        block2: {
            String string = this.readLine();
            if (string == null) {
                return null;
            }
            stringBuffer = new StringBuffer();
            do {
                stringBuffer.append(string);
                stringBuffer.append("\n");
                string = this.readLine();
                if (string == null) break block2;
            } while (!string.startsWith("</"));
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String readLine() {
        try {
            return this.in.readLine();
        }
        catch (IOException iOException) {
            Debug.displayException(iOException);
            return null;
        }
    }

    protected void describeEvent(HistoryEvent historyEvent) {
        this.beginEventDescription(historyEvent);
        this.describeEventByType(historyEvent);
        this.endEventDescription(historyEvent);
    }

    protected void beginEventDescription(HistoryEvent historyEvent) {
        this.out.println(historyEvent.getDate() + " " + this.eventClassName(historyEvent));
    }

    protected void endEventDescription(HistoryEvent historyEvent) {
        this.out.println("- - - - - - - - - -");
    }

    protected void describeEventByType(HistoryEvent historyEvent) {
        if (historyEvent instanceof HistoryComment) {
            this.describeEvent((HistoryComment)historyEvent);
        } else if (historyEvent instanceof MessageSent) {
            this.describeEvent((MessageSent)historyEvent);
        } else if (historyEvent instanceof MessageReceived) {
            this.describeEvent((MessageReceived)historyEvent);
        } else if (historyEvent instanceof ItemHandledEvent) {
            this.describeEvent((ItemHandledEvent)historyEvent);
        } else if (historyEvent instanceof BindingEvent) {
            this.describeEvent((BindingEvent)historyEvent);
        }
    }

    protected String eventClassName(HistoryEvent historyEvent) {
        return Strings.afterLast(".", historyEvent.getClass().getName());
    }

    protected void describeEvent(HistoryComment historyComment) {
        this.out.println(" " + historyComment.getContents());
    }

    protected void describeEvent(MessageSent messageSent) {
        this.out.println(" " + Reporting.description(messageSent.getContents()));
    }

    protected void describeEvent(MessageReceived messageReceived) {
        this.out.println(" " + Reporting.description(messageReceived.getContents()));
    }

    protected void describeEvent(ItemHandledEvent itemHandledEvent) {
        this.out.println(" " + itemHandledEvent.getPattern());
        this.out.println(" " + itemHandledEvent.getAction());
    }

    protected void describeEvent(BindingEvent bindingEvent) {
        this.out.println(" " + bindingEvent.getBindings());
    }
}

