/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.plan;

import ix.icore.Activity;
import ix.icore.domain.Constrainer;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.LinkedListOfNodeSpec;
import ix.icore.domain.LinkedListOfOrdering;
import ix.icore.domain.LinkedListOfVariableDeclaration;
import ix.icore.domain.ListOfConstrainer;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.icore.plan.InvalidPlanException;
import ix.icore.plan.ListOfPlanNode;
import ix.icore.plan.ListOfPlanVariableDeclaration;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanNode;
import ix.icore.plan.PlanRefinement;
import ix.icore.plan.PlanVariable;
import ix.icore.plan.PlanVariableDeclaration;
import ix.ip2.ActivityItem;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Name;
import ix.util.ObjectWalker;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanAsDomain
extends Domain {
    static final Symbol EXPANDS = Symbol.intern("expands");
    static final Symbol WORLD_STATE = Symbol.intern("world-state");
    protected Map<Name, Activity> idToActivityMap;
    protected Map<Name, ItemVar> planVarIdToItemVarMap = new HashMap<Name, ItemVar>();
    protected Gensym.Generator nameGen = new Gensym.Generator();

    public PlanAsDomain() {
        this.nameGen.setSeparator(".");
    }

    public PlanAsDomain(Plan plan) {
        this.nameGen.setSeparator(".");
        this.idToActivityMap = this.makeIdToActivityMap(plan);
        this.planVarIdToItemVarMap = this.makePlanVarIdToItemVarMap(plan);
        this.addRefinement(this.makeTopLevelRefinement(plan));
        if (plan.getPlanRefinements() != null) {
            for (PlanRefinement planRefinement : plan.getPlanRefinements()) {
                this.addRefinement(this.makeRefinement(planRefinement));
            }
        }
    }

    Map<Name, Activity> makeIdToActivityMap(Plan plan) {
        final HashMap<Name, Activity> hashMap = new HashMap<Name, Activity>();
        final LinkedList linkedList = new LinkedList();
        PlanWalker planWalker = new PlanWalker(){

            public void walk(Object object) {
                if (object instanceof PlanNode) {
                    PlanNode planNode = (PlanNode)object;
                    if (hashMap.put(planNode.getId(), planNode.getActivity()) != null) {
                        linkedList.add(planNode);
                    }
                } else {
                    super.walk(object);
                }
            }
        };
        planWalker.walk(plan);
        if (!linkedList.isEmpty()) {
            throw new InvalidPlanException("Some nodes do not have unique ids: " + Strings.conjunction(linkedList));
        }
        return hashMap;
    }

    Map<Name, ItemVar> makePlanVarIdToItemVarMap(Plan plan) {
        final HashMap<Name, ItemVar> hashMap = new HashMap<Name, ItemVar>();
        final LinkedList linkedList = new LinkedList();
        PlanWalker planWalker = new PlanWalker(){

            public void walk(Object object) {
                if (object instanceof PlanVariableDeclaration) {
                    this.walkPVDcl((PlanVariableDeclaration)object);
                } else {
                    super.walk(object);
                }
            }

            void walkPVDcl(PlanVariableDeclaration planVariableDeclaration) {
                if (hashMap.put(planVariableDeclaration.getId(), PlanAsDomain.this.makeItemVar(planVariableDeclaration)) != null) {
                    linkedList.add(planVariableDeclaration);
                }
            }
        };
        planWalker.walk(plan);
        if (!linkedList.isEmpty()) {
            throw new InvalidPlanException("Some variables do not have unique ids: " + Strings.conjunction(linkedList));
        }
        return hashMap;
    }

    Refinement makeTopLevelRefinement(Plan plan) {
        Refinement refinement = new Refinement("plan-top-level", Lisp.list("Top level of the plan"));
        this.setVarDcls(refinement, plan.getPlanVariableDeclarations());
        this.setNodeSpecs(refinement, plan.getPlanNodes());
        this.setConstraintsAndOrderings(refinement, plan.getConstraints());
        if (plan.getWorldState() != null) {
            refinement.setAnnotation(WORLD_STATE, PatternAssignment.assignmentsToMap(plan.getWorldState()));
        }
        return refinement;
    }

    Refinement makeRefinement(PlanRefinement planRefinement) {
        Activity activity = this.idToActivityMap.get(planRefinement.getExpands());
        Refinement refinement = new Refinement("expand-" + planRefinement.getExpands(), this.patternForDomain(activity.getPattern()));
        refinement.setAnnotation(EXPANDS, Symbol.intern(planRefinement.getExpands().toString()));
        if (activity.getAnnotation(ActivityItem.EXPANSION_REFINEMENT_NAME) != null) {
            refinement.setAnnotation(ActivityItem.EXPANSION_REFINEMENT_NAME, activity.getAnnotation(ActivityItem.EXPANSION_REFINEMENT_NAME));
        }
        this.setVarDcls(refinement, planRefinement.getPlanVariableDeclarations());
        this.setNodeSpecs(refinement, planRefinement.getPlanNodes());
        this.setConstraintsAndOrderings(refinement, planRefinement.getConstraints());
        return refinement;
    }

    void setVarDcls(Refinement refinement, ListOfPlanVariableDeclaration listOfPlanVariableDeclaration) {
        if (listOfPlanVariableDeclaration == null) {
            return;
        }
        LinkedListOfVariableDeclaration linkedListOfVariableDeclaration = new LinkedListOfVariableDeclaration();
        for (PlanVariableDeclaration planVariableDeclaration : listOfPlanVariableDeclaration) {
            linkedListOfVariableDeclaration.add(new VariableDeclaration(this.getItemVar(planVariableDeclaration)));
        }
        refinement.setVariableDeclarations(linkedListOfVariableDeclaration);
    }

    void setNodeSpecs(Refinement refinement, ListOfPlanNode listOfPlanNode) {
        if (listOfPlanNode == null) {
            return;
        }
        LinkedListOfNodeSpec linkedListOfNodeSpec = new LinkedListOfNodeSpec();
        for (PlanNode planNode : listOfPlanNode) {
            LList lList = planNode.getActivity().getPattern();
            linkedListOfNodeSpec.add(new NodeSpec(planNode.getId(), this.patternForDomain(lList)));
        }
        refinement.setNodes(linkedListOfNodeSpec);
    }

    void setConstraintsAndOrderings(Refinement refinement, ListOfConstrainer listOfConstrainer) {
        if (listOfConstrainer == null) {
            return;
        }
        ListOfOrdering listOfOrdering = this.getOrderings(listOfConstrainer);
        ListOfConstraint listOfConstraint = this.getNonOrderings(listOfConstrainer);
        if (!listOfOrdering.isEmpty()) {
            refinement.setOrderings(listOfOrdering);
        }
        if (!listOfConstraint.isEmpty()) {
            refinement.setConstraints(listOfConstraint);
        }
    }

    ListOfOrdering getOrderings(ListOfConstrainer listOfConstrainer) {
        LinkedListOfOrdering linkedListOfOrdering = new LinkedListOfOrdering();
        for (Constrainer constrainer : listOfConstrainer) {
            if (!(constrainer instanceof Ordering)) continue;
            linkedListOfOrdering.add((Ordering)constrainer);
        }
        return linkedListOfOrdering;
    }

    ListOfConstraint getNonOrderings(ListOfConstrainer listOfConstrainer) {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        for (Constrainer constrainer : listOfConstrainer) {
            if (constrainer instanceof Ordering) continue;
            linkedListOfConstraint.add((Constraint)constrainer);
        }
        return linkedListOfConstraint;
    }

    LList patternForDomain(List list) {
        LListCollector lListCollector = new LListCollector();
        for (Object e : list) {
            if (e instanceof PlanVariable) {
                lListCollector.add(this.getItemVar((PlanVariable)e));
                continue;
            }
            if (e instanceof List) {
                lListCollector.add(this.patternForDomain((List)e));
                continue;
            }
            lListCollector.add(e);
        }
        return lListCollector.contents();
    }

    ItemVar getItemVar(PlanVariable planVariable) {
        ItemVar itemVar = this.planVarIdToItemVarMap.get(planVariable.getId());
        if (itemVar == null) {
            throw new InvalidPlanException("Undeclared variable: " + planVariable);
        }
        return itemVar;
    }

    ItemVar getItemVar(PlanVariableDeclaration planVariableDeclaration) {
        ItemVar itemVar = this.planVarIdToItemVarMap.get(planVariableDeclaration.getId());
        if (itemVar == null) {
            throw new ConsistencyException("Missed declaration:", planVariableDeclaration);
        }
        return itemVar;
    }

    ItemVar makeItemVar(PlanVariableDeclaration planVariableDeclaration) {
        return (ItemVar)this.nameGen.nextSymbol(planVariableDeclaration.getName().toString());
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("plan");
        String string2 = Parameters.getParameter("output");
        if (string == null || string2 == null) {
            System.out.println("Usage: Must specify plan= and output=");
            System.exit(1);
        }
        Plan plan = XML.readObject(Plan.class, string);
        PlanAsDomain planAsDomain = new PlanAsDomain(plan);
        XML.writeObject(planAsDomain, string2);
    }

    class PlanWalker
    extends ObjectWalker {
        PlanWalker() {
        }

        public void visitElement(Object object) {
            if (!(object instanceof Plan)) {
                this.walk(object);
            }
        }
    }
}

