/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.plan.build;

import ix.icore.Activity;
import ix.icore.Annotations;
import ix.icore.Issue;
import ix.icore.TaskItem;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstrainer;
import ix.icore.domain.ListOfConstrainer;
import ix.icore.plan.AbstractPlanItem;
import ix.icore.plan.AbstractRefinement;
import ix.icore.plan.LinkedListOfPlanIssue;
import ix.icore.plan.LinkedListOfPlanIssueRefinement;
import ix.icore.plan.LinkedListOfPlanNode;
import ix.icore.plan.LinkedListOfPlanRefinement;
import ix.icore.plan.ListOfPlanIssue;
import ix.icore.plan.ListOfPlanIssueRefinement;
import ix.icore.plan.ListOfPlanNode;
import ix.icore.plan.ListOfPlanRefinement;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanIssue;
import ix.icore.plan.PlanIssueRefinement;
import ix.icore.plan.PlanNode;
import ix.icore.plan.PlanRefinement;
import ix.icore.plan.build.PlanBuilder;
import ix.test.PlanBuilderTest;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.MultiHashMap;
import ix.util.MultiMap;
import ix.util.Name;
import java.util.LinkedList;
import java.util.List;

public class ExamplePlanBuilder
implements PlanBuilder {
    protected Gensym.Generator nameGen = new Gensym.Generator();
    protected List issues = new LinkedList();
    protected List activities = new LinkedList();
    protected ListOfConstrainer constraints = new LinkedListOfConstrainer();
    protected Annotations annotations = new Annotations();
    protected MultiMap itemToSubitems = new MultiHashMap();
    protected Plan plan = new Plan();
    protected ListOfPlanIssue planIssues = new LinkedListOfPlanIssue();
    protected ListOfPlanIssueRefinement issueRefinements = new LinkedListOfPlanIssueRefinement();
    protected ListOfPlanNode planNodes = new LinkedListOfPlanNode();
    protected ListOfPlanRefinement planRefinements = new LinkedListOfPlanRefinement();

    public void addIssue(Issue issue) {
        this.issues.add(issue);
    }

    public void addSubissue(Issue issue, Issue issue2) {
        this.itemToSubitems.addValue(issue, issue2);
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
    }

    public void addSubactivity(Activity activity, Activity activity2) {
        this.itemToSubitems.addValue(activity, activity2);
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void setAnnotation(Object object, Object object2) {
        this.annotations.put(object, object2);
    }

    protected Name genId(String string) {
        return this.nameGen.nextName(string);
    }

    protected List getSubitems(Object object) {
        return (List)this.itemToSubitems.get(object);
    }

    public Plan getPlan() {
        new IssueExpander(this.planIssues, this.issueRefinements).walk(this.issues);
        new ActivityExpander(this.planNodes, this.planRefinements).walk(this.activities);
        this.fillInPlan();
        return this.plan;
    }

    protected void fillInPlan() {
        if (!this.planIssues.isEmpty()) {
            this.plan.setPlanIssues(this.planIssues);
        }
        if (!this.issueRefinements.isEmpty()) {
            this.plan.setPlanIssueRefinements(this.issueRefinements);
        }
        if (!this.planNodes.isEmpty()) {
            this.plan.setPlanNodes(this.planNodes);
        }
        if (!this.planRefinements.isEmpty()) {
            this.plan.setPlanRefinements(this.planRefinements);
        }
        if (!this.constraints.isEmpty()) {
            this.plan.setConstraints(this.constraints);
        }
        if (!this.annotations.isEmpty()) {
            this.plan.setAnnotations(this.annotations);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new PlanBuilderTest().test(new ExamplePlanBuilder());
    }

    protected class ActivityExpander
    extends Expander {
        public ActivityExpander(List list, List list2) {
            super(list, list2);
        }

        protected AbstractPlanItem makePlanItem(TaskItem taskItem, AbstractPlanItem abstractPlanItem) {
            String string = abstractPlanItem == null ? "node" : abstractPlanItem.getId().toString();
            return new PlanNode(ExamplePlanBuilder.this.genId(string), (Activity)taskItem);
        }

        protected AbstractRefinement makePlanRefinement() {
            PlanRefinement planRefinement = new PlanRefinement();
            planRefinement.setId(ExamplePlanBuilder.this.genId("refinement"));
            return planRefinement;
        }
    }

    protected class IssueExpander
    extends Expander {
        public IssueExpander(List list, List list2) {
            super(list, list2);
        }

        protected AbstractPlanItem makePlanItem(TaskItem taskItem, AbstractPlanItem abstractPlanItem) {
            String string = abstractPlanItem == null ? "issue" : abstractPlanItem.getId().toString();
            return new PlanIssue(ExamplePlanBuilder.this.genId(string), (Issue)taskItem);
        }

        protected AbstractRefinement makePlanRefinement() {
            PlanIssueRefinement planIssueRefinement = new PlanIssueRefinement();
            planIssueRefinement.setId(ExamplePlanBuilder.this.genId("issue-refinement"));
            return planIssueRefinement;
        }
    }

    protected abstract class Expander {
        protected List planItems;
        protected List planRefinements;

        public Expander(List list, List list2) {
            this.planItems = list;
            this.planRefinements = list2;
        }

        public void walk(List list) {
            this.walk(list, this.planItems, null);
        }

        protected void walk(List list, List list2, AbstractPlanItem abstractPlanItem) {
            for (TaskItem taskItem : list) {
                List list3 = ExamplePlanBuilder.this.getSubitems(taskItem);
                AbstractPlanItem abstractPlanItem2 = this.makePlanItem(taskItem, abstractPlanItem);
                list2.add(abstractPlanItem2);
                if (list3 == null) continue;
                this.buildExpansion(abstractPlanItem2, list3);
            }
        }

        protected void buildExpansion(AbstractPlanItem abstractPlanItem, List list) {
            AbstractRefinement abstractRefinement = this.makePlanRefinement();
            this.planRefinements.add(abstractRefinement);
            abstractPlanItem.setExpansion(abstractRefinement.getId());
            abstractRefinement.setExpands(abstractPlanItem.getId());
            LinkedList linkedList = new LinkedList();
            abstractRefinement.setSubitems(linkedList);
            this.walk(list, linkedList, abstractPlanItem);
            Debug.expect(linkedList.size() == list.size());
        }

        protected abstract AbstractPlanItem makePlanItem(TaskItem var1, AbstractPlanItem var2);

        protected abstract AbstractRefinement makePlanRefinement();
    }
}

