/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process;

import ix.icore.HasStatus;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.Refinement;
import ix.icore.process.PNodeEnd;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.TimePoint;
import ix.ip2.Ip2ModelManager;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Name;
import ix.util.Proc1;
import ix.util.context.ContextValue;
import ix.util.context.LLQueue;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PNode
extends TimePoint
implements HasStatus {
    protected ProcessModelManager modelManager;
    protected int level = 0;
    protected PNode parent = null;
    protected PNodeEnd beginEnd;
    protected PNodeEnd endEnd;
    private LLQueue<PNode> children = new LLQueue();
    private ContextValue<Map<Name, PNode>> __nameToChildMap = new ContextValue<Object>(null);
    private ContextValue<Map> __expansionVarTable = new ContextValue<Object>(null);
    private ContextValue<Refinement> __expansionRefinement = new ContextValue<Object>(null);

    public PNode(PNode pNode) {
        this.parent = pNode;
        if (pNode != null) {
            this.level = pNode.level + 1;
        }
        this.beginEnd = new PNodeEnd(End.BEGIN, this);
        this.endEnd = new PNodeEnd(End.END, this);
        this.beginEnd.linkBefore(this.endEnd);
    }

    public abstract LList getPattern();

    public int getLevel() {
        return this.level;
    }

    public PNodeEnd getBegin() {
        return this.beginEnd;
    }

    public PNodeEnd getEnd() {
        return this.endEnd;
    }

    public PNodeEnd getEnd(End end) {
        return end == End.BEGIN ? this.beginEnd : this.endEnd;
    }

    public PNode getParentPNode() {
        return this.parent;
    }

    public List<PNode> getChildren() {
        return this.children.contents();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setChildren(List list) {
        this.children.setContents(list);
    }

    public Map<Name, PNode> getNameToChildMap() {
        return this.__nameToChildMap.get();
    }

    public void setNameToChildMap(Map<Name, PNode> map) {
        this.__nameToChildMap.set(map);
    }

    public ProcessModelManager getModelManager() {
        return this.modelManager;
    }

    public void setModelManager(ProcessModelManager processModelManager) {
        this.modelManager = processModelManager;
    }

    public Map getVarTable() {
        Map map = this.__expansionVarTable.get();
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    public void setVarTable(Map map) {
        this.__expansionVarTable.set(map);
    }

    public Refinement getRefinement() {
        return this.__expansionRefinement.get();
    }

    public void setRefinement(Refinement refinement) {
        this.__expansionRefinement.set(refinement);
    }

    @Override
    public abstract Status getStatus();

    public boolean isSiblingOf(PNode pNode) {
        return this.parent == pNode.parent;
    }

    public boolean isParentOf(PNode pNode) {
        return this == pNode.getParentPNode();
    }

    public boolean isAncestorOf(PNode pNode) {
        PNode pNode2 = pNode.parent;
        while (pNode2 != null) {
            if (this == pNode2) {
                return true;
            }
            pNode2 = pNode2.parent;
        }
        return false;
    }

    public boolean isDescendentOf(PNode pNode) {
        return pNode.isAncestorOf(this);
    }

    public void walk(Proc1<PNode> proc1) {
        proc1.call(this);
    }

    public void walkChildren(Proc1<PNode> proc1) {
        for (PNode pNode : this.getChildren()) {
            proc1.call(pNode);
        }
    }

    public boolean isExpanded() {
        return this.getVarTable() != null;
    }

    public void unlink() {
        this.beginEnd.unlink();
        this.endEnd.unlink();
    }

    public void addChild(PNode pNode, PNode pNode2) {
        Debug.expect(pNode.parent == null, "already has parent", pNode);
        if (pNode2 != null) {
            Debug.expect(this.children.contains(pNode2), "not a sibling", pNode2);
        }
        pNode.parent = this;
        pNode.level = this.level + 1;
        if (pNode2 == null) {
            this.children.add(pNode);
        } else {
            this.setChildren(Collect.insertBeforeFirst(pNode2, this.getChildren(), Lisp.list(pNode)));
        }
        PNodeEnd pNodeEnd = pNode.getBegin();
        PNodeEnd pNodeEnd2 = pNode.getEnd();
        if (pNodeEnd.getPredecessors().isEmpty()) {
            pNodeEnd.linkAfter(this.getBegin());
        }
        if (pNodeEnd2.getSuccessors().isEmpty()) {
            pNodeEnd2.linkBefore(this.getEnd());
        }
    }

    public void expandOneLevel(Refinement refinement, MatchEnv matchEnv) {
        HashMap hashMap = new HashMap();
        HashMap<Name, PNode> hashMap2 = new HashMap<Name, PNode>();
        this.setVarTable(hashMap);
        this.setNameToChildMap(hashMap2);
        Debug.expect(this.getRefinement() == null, "already expanded?", this);
        MakeVarIfUnbound makeVarIfUnbound = new MakeVarIfUnbound(hashMap);
        Refinement refinement2 = refinement.instantiate(matchEnv, makeVarIfUnbound);
        this.setRefinement(refinement2);
        Debug.noteln("varTable after expansion", hashMap);
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = Collect.iterator(refinement2.getNodes());
        while (iterator.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)iterator.next();
            LList lList = nodeSpec.getPattern();
            PNode pNode = this.makePNode(this, lList);
            lListCollector.add(pNode);
            hashMap2.put(nodeSpec.getId(), pNode);
        }
        this.setChildren(lListCollector.contents());
        if (refinement2.getOrderings() != null) {
            this.processOrderings(refinement2.getOrderings());
        }
        this.ensureChildrenLinkedToParent();
    }

    protected abstract PNode makePNode(PNode var1, LList var2);

    public PNodeEnd refToTimePoint(NodeEndRef nodeEndRef) {
        if ("self".equals(nodeEndRef.getNode().toString())) {
            return this.getEnd(nodeEndRef.getEnd());
        }
        Map<Name, PNode> map = this.getNameToChildMap();
        if (map == null) {
            throw new ConsistencyException(this + " has no map to " + nodeEndRef);
        }
        return PNodeEnd.fromRef(map, nodeEndRef);
    }

    public void processOrderings(ListOfOrdering listOfOrdering) {
        for (Ordering ordering : listOfOrdering) {
            PNodeEnd pNodeEnd = this.refToTimePoint(ordering.getFrom());
            PNodeEnd pNodeEnd2 = this.refToTimePoint(ordering.getTo());
            pNodeEnd.linkBefore(pNodeEnd2);
        }
    }

    public void ensureChildrenLinkedToParent() {
        PNodeEnd pNodeEnd = this.getBegin();
        PNodeEnd pNodeEnd2 = this.getEnd();
        for (PNode pNode : this.children) {
            PNodeEnd pNodeEnd3 = pNode.getBegin();
            PNodeEnd pNodeEnd4 = pNode.getEnd();
            if (pNodeEnd3.getPredecessors().isEmpty()) {
                pNodeEnd3.linkAfter(pNodeEnd);
            }
            if (!pNodeEnd4.getSuccessors().isEmpty()) continue;
            pNodeEnd4.linkBefore(pNodeEnd2);
        }
    }

    @Override
    public void computeStatus() {
        if (!((Ip2ModelManager)this.modelManager).computeStatus) {
            return;
        }
        this.beginEnd.computeStatus();
        this.endEnd.computeStatus();
        if (this.getStatus() == Status.EXECUTING && !this.children.isEmpty() && PNode.allHaveStatus(this.children, Status.COMPLETE)) {
            this.setStatus(Status.COMPLETE);
        }
    }

    @Override
    public void setStatus(Status status) {
        Debug.noteln("Setting status of " + this + " to " + status);
        Debug.expect(((Ip2ModelManager)this.modelManager).computeStatus);
        if (this.modelManager != null) {
            this.modelManager.statusChanged(this);
        }
        if (status == Status.BLANK) {
            this.beginEnd.setStatus(Status.BLANK);
            this.endEnd.setStatus(Status.BLANK);
        } else if (status == Status.COMPLETE) {
            this.beginEnd.setStatus(Status.COMPLETE);
            this.endEnd.setStatus(Status.COMPLETE);
            if (this.parent != null) {
                this.parent.computeStatus();
            }
        } else if (status == Status.EXECUTING) {
            this.beginEnd.setStatus(Status.COMPLETE);
        } else if (status == Status.POSSIBLE && !this.children.isEmpty() && (this.modelManager == null || Collect.isEmpty(this.modelManager.getNodeConditions(this)))) {
            this.setStatus(Status.EXECUTING);
        }
    }

    public void assignStatus(Status status) {
        if (status == Status.BLANK) {
            this.beginEnd.setStatus(Status.BLANK);
            this.endEnd.setStatus(Status.BLANK);
        } else if (status == Status.POSSIBLE) {
            this.beginEnd.setStatus(Status.POSSIBLE);
            this.endEnd.setStatus(Status.BLANK);
        } else if (status == Status.EXECUTING) {
            this.beginEnd.setStatus(Status.COMPLETE);
            this.endEnd.computeStatus();
        } else if (status == Status.COMPLETE) {
            this.beginEnd.setStatus(Status.COMPLETE);
            this.endEnd.setStatus(Status.COMPLETE);
        } else if (status == Status.IMPOSSIBLE) {
            this.beginEnd.setStatus(Status.IMPOSSIBLE);
        } else {
            throw new ConsistencyException();
        }
    }

    public Status statusFromNodeEnds() {
        Status status = this.beginEnd.getStatus();
        Status status2 = this.endEnd.getStatus();
        if (status == Status.BLANK || status == Status.POSSIBLE || status == Status.IMPOSSIBLE) {
            return status;
        }
        if (status == Status.COMPLETE) {
            if (status2 == Status.COMPLETE) {
                return Status.COMPLETE;
            }
            return Status.EXECUTING;
        }
        throw new ConsistencyException();
    }

    public static boolean allHaveStatus(List list, Status status) {
        for (HasStatus hasStatus : list) {
            if (hasStatus.getStatus() == status) continue;
            return false;
        }
        return true;
    }

    public static void allComputeStatus(List list) {
        for (HasStatus hasStatus : list) {
            hasStatus.computeStatus();
        }
    }

    protected class MakeVarIfUnbound
    implements Function1 {
        protected Map nameToVarMap;

        public MakeVarIfUnbound(Map map) {
            this.nameToVarMap = map;
        }

        public Object funcall(Object object) {
            Variable variable = (Variable)this.nameToVarMap.get(object);
            if (variable == null) {
                variable = new Variable(object);
                Debug.noteln("Creating variable " + variable + " for " + object);
                variable.setSourceNode(PNode.this);
                this.nameToVarMap.put(object, variable);
            }
            return variable;
        }
    }
}

