/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process;

import ix.icore.HasStatus;
import ix.icore.Status;
import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.icore.process.PNode;
import ix.icore.process.TimePoint;
import ix.ip2.Ip2ModelManager;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.TopologicalSorter;
import ix.util.context.ContextValue;
import ix.util.context.LLQueue;
import ix.util.context.TypedContextValue;
import ix.util.lisp.Lisp;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PNodeEnd
extends TimePoint
implements HasStatus {
    private End end;
    private PNode node;
    private long[] marks = new long[]{-1L, -1L};
    private ContextValue status = new TypedContextValue<Status>(Status.class, Status.BLANK);
    private LLQueue predecessors = new LLQueue();
    private LLQueue successors = new LLQueue();

    public PNodeEnd(End end, PNode pNode) {
        this.end = end;
        this.node = pNode;
    }

    public static PNodeEnd fromRef(Map map, NodeEndRef nodeEndRef) {
        PNode pNode = (PNode)map.get(nodeEndRef.getNode());
        End end = nodeEndRef.getEnd();
        Debug.expect(pNode != null, "Can't find node for", nodeEndRef);
        if (end == End.BEGIN) {
            return pNode.getBegin();
        }
        if (end == End.END) {
            return pNode.getEnd();
        }
        throw new ConsistencyException("Bad end in", nodeEndRef);
    }

    public static void addOrdering(Map map, Ordering ordering) {
        PNodeEnd pNodeEnd = PNodeEnd.fromRef(map, ordering.getFrom());
        PNodeEnd pNodeEnd2 = PNodeEnd.fromRef(map, ordering.getTo());
        pNodeEnd.linkBefore(pNodeEnd2);
    }

    public PNode getNode() {
        return this.node;
    }

    public End getEnd() {
        return this.end;
    }

    public PNodeEnd getOtherNodeEnd() {
        return this.end == End.BEGIN ? this.getNode().getEnd() : this.getNode().getBegin();
    }

    public Status getStatus() {
        return (Status)this.status.get();
    }

    public void setStatus(Status status) {
        this.status.set(status);
        PNode.allComputeStatus(this.getSuccessors());
    }

    public void computeStatus() {
        if (!((Ip2ModelManager)this.node.modelManager).computeStatus) {
            return;
        }
        Status status = this.getStatus();
        if (status == Status.BLANK && PNode.allHaveStatus(this.getPredecessors(), Status.COMPLETE)) {
            this.setStatus(Status.POSSIBLE);
            if (this.end == End.BEGIN) {
                this.node.setStatus(Status.POSSIBLE);
            }
        }
    }

    public List getPredecessors() {
        return this.predecessors.contents();
    }

    public List getSuccessors() {
        return this.successors.contents();
    }

    public void linkBefore(PNodeEnd pNodeEnd) {
        if (pNodeEnd.node != this.node) {
            Debug.noteln("-- " + this + " --> " + pNodeEnd);
        }
        if (!this.successors.contains(pNodeEnd)) {
            this.successors.add(pNodeEnd);
            pNodeEnd.predecessors.add(this);
        }
    }

    public void linkAfter(PNodeEnd pNodeEnd) {
        if (pNodeEnd.node != this.node) {
            Debug.noteln("-- " + pNodeEnd + " --> " + this);
        }
        if (!pNodeEnd.successors.contains(this)) {
            pNodeEnd.successors.add(this);
            this.predecessors.add(pNodeEnd);
        }
    }

    public void unlink() {
        for (PNodeEnd pNodeEnd : this.predecessors) {
            for (PNodeEnd pNodeEnd2 : this.successors) {
                pNodeEnd.linkBefore(pNodeEnd2);
            }
        }
        for (PNodeEnd pNodeEnd : this.predecessors) {
            pNodeEnd.successors.remove(this);
        }
        for (PNodeEnd pNodeEnd : this.successors) {
            pNodeEnd.predecessors.remove(this);
        }
    }

    public boolean isMarked(int n, long l) {
        return this.marks[n] == l;
    }

    public long getMark(int n) {
        return this.marks[n];
    }

    public long markShadowedEnds(int n) {
        long l = ((Ip2ModelManager)this.node.modelManager).nextMark();
        this.markShadowedEnds(this, n, l);
        return l;
    }

    private void markShadowedEnds(PNodeEnd pNodeEnd, int n, long l) {
        if (pNodeEnd.marks[n] == l) {
            return;
        }
        pNodeEnd.marks[n] = l;
        for (PNodeEnd pNodeEnd2 : pNodeEnd.getSuccessors()) {
            this.markShadowedEnds(pNodeEnd2, n, l);
        }
    }

    public long markEndsBefore(int n) {
        long l = ((Ip2ModelManager)this.node.modelManager).nextMark();
        this.markEndsBefore(this, n, l);
        return l;
    }

    private void markEndsBefore(PNodeEnd pNodeEnd, int n, long l) {
        if (pNodeEnd.marks[n] == l) {
            return;
        }
        pNodeEnd.marks[n] = l;
        for (PNodeEnd pNodeEnd2 : pNodeEnd.getPredecessors()) {
            this.markEndsBefore(pNodeEnd2, n, l);
        }
    }

    public List getShadowedEnds() {
        TopologicalSorter topologicalSorter = new TopologicalSorter(){

            protected Collection getChildren(Object object) {
                return ((PNodeEnd)object).getSuccessors();
            }
        };
        return topologicalSorter.sort(Lisp.list(this));
    }

    public String toString() {
        return this.end + "_of " + this.node;
    }
}

