/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.iface.domain.LTF_Writer;
import ix.util.ConsistencyException;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.WithCleanup;
import ix.util.xml.XML;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ITF_Writer {
    public void writeDomain(final Domain domain, File file) throws IOException {
        final BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        Util.run(new WithCleanup(){

            public void body() throws IOException {
                ITF_Writer.this.writeDomain(domain, bufferedWriter);
                bufferedWriter.flush();
            }

            public void cleanup() throws IOException {
                bufferedWriter.close();
            }
        });
    }

    public void writeDomain(Domain domain, Writer writer) throws IOException {
        StringListLtfWriter stringListLtfWriter = new StringListLtfWriter();
        stringListLtfWriter.outDomain(domain);
        for (String string : new LineTrimmer(stringListLtfWriter.getLines()).trimLines()) {
            writer.write(string);
            writer.write("\n");
        }
        writer.flush();
    }

    private int indentLevel(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return i;
        }
        throw new IllegalArgumentException("blank lines have no indent level");
    }

    private boolean isAllSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.requireParameter("domain");
        Domain domain = XML.readObject(Domain.class, XML.toURL(string));
        ITF_Writer iTF_Writer = new ITF_Writer();
        iTF_Writer.writeDomain(domain, new OutputStreamWriter(System.out));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringListLtfWriter
    extends LTF_Writer {
        private List<String> lines = new LinkedList<String>();
        private StringBuilder line = new StringBuilder();

        private StringListLtfWriter() {
        }

        List<String> getLines() {
            return this.lines;
        }

        @Override
        void out(String string) {
            this.line.append(string);
        }

        @Override
        void outln(String string) {
            this.out(string);
            this.lines.add(this.line.toString());
            this.line.delete(0, this.line.length());
        }

        @Override
        void outOrdering(Ordering ordering) {
            NodeEndRef nodeEndRef = ordering.getFrom();
            NodeEndRef nodeEndRef2 = ordering.getTo();
            this.outNodeEndRef(nodeEndRef, End.END);
            this.out(" --> ");
            this.outNodeEndRef(nodeEndRef2, End.BEGIN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineTrimmer {
        private List<String> lines;
        private LinkedList<Integer> indentStack;
        private ListIterator<String> lineIter;
        private LinkedList<String> result;
        int indentLevel;

        private LineTrimmer(List<String> list) {
            this.lines = list;
        }

        private List<String> trimLines() {
            this.indentStack = new LinkedList();
            this.lineIter = this.lines.listIterator();
            this.result = new LinkedList();
            this.indentLevel = 0;
            while (this.lineIter.hasNext()) {
                int n;
                String string = this.trimTrailingSpaces(this.lineIter.next());
                if (ITF_Writer.this.isAllSpaces(string)) {
                    this.result.add("");
                    continue;
                }
                int n2 = ITF_Writer.this.indentLevel(string);
                if (n2 > this.indentLevel) {
                    this.pushIndent(n2, string);
                }
                if (n2 < this.indentLevel) {
                    this.popIndent(n2, string);
                }
                if ((n = this.countParens(string)) == 0) {
                    this.result.add(this.trimOuterParens(string));
                    continue;
                }
                if (n == 1) {
                    this.result.add(this.trimOuterOpenParen(string));
                    continue;
                }
                if (n < 0) {
                    while (n < 0) {
                        string = this.trimOuterCloseParen(string);
                        ++n;
                    }
                    this.result.add(this.trimOuterParens(string));
                    continue;
                }
                throw new ConsistencyException("Can't handle line: " + string);
            }
            return this.result;
        }

        int countParens(String string) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '(') {
                    ++n;
                    continue;
                }
                if (c != ')') continue;
                --n;
            }
            return n;
        }

        void pushIndent(int n, String string) {
            this.indentStack.add(this.indentLevel);
            this.indentLevel = n;
        }

        void popIndent(int n, String string) {
            while (n < this.indentLevel) {
                this.indentLevel = this.indentStack.removeFirst();
            }
        }

        String trimTrailingSpaces(String string) {
            int n;
            int n2;
            for (n2 = n = string.length() - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
            }
            return n2 == n ? string : string.substring(0, n2 + 1);
        }

        String trimOuterParens(String string) {
            return this.trimOuterOpenParen(this.trimOuterCloseParen(string));
        }

        String trimOuterOpenParen(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != ' ') {
                    if (c != '(') break;
                    return stringBuilder.append(string.substring(i + 1)).toString();
                }
                stringBuilder.append(c);
            }
            return string;
        }

        String trimOuterCloseParen(String string) {
            return string.endsWith(")") ? string.substring(0, string.length() - 1) : string;
        }
    }
}

