/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.plan;

import ix.icore.domain.LinkedListOfPatternAssignment;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.Plan;
import ix.iface.domain.SyntaxException;
import ix.util.Debug;
import ix.util.MultiHashMap;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class InitLoader {
    public Plan readInit(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        String string = Util.readLine(inputStream);
        inputStream.close();
        if (Strings.beforeFirst("=", string).indexOf(46) > 0) {
            return this.readInitOldSyntax(uRL.openStream());
        }
        return this.readInitNewSyntax(uRL);
    }

    Plan readInitNewSyntax(URL uRL) throws IOException {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(Util.openURLReader(uRL));
        LinkedListOfPatternAssignment linkedListOfPatternAssignment = new LinkedListOfPatternAssignment();
        while ((object = bufferedReader.readLine()) != null) {
            if (((String)(object = ((String)object).trim())).equals("") || ((String)object).startsWith(";")) continue;
            linkedListOfPatternAssignment.add(this.parseConstraint((String)object));
        }
        object = new Plan();
        if (!linkedListOfPatternAssignment.isEmpty()) {
            ((Plan)object).setWorldState(linkedListOfPatternAssignment);
        }
        return object;
    }

    PatternAssignment parseConstraint(String string) {
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (string3.equals("")) {
            string3 = "true";
        }
        LList lList = PatternParser.parse(string2);
        Object object = this.parseValue(string3);
        return new PatternAssignment(lList, object);
    }

    Plan readInitOldSyntax(InputStream inputStream) throws IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Properties properties = new Properties();
        properties.load(inputStream);
        MultiHashMap multiHashMap = new MultiHashMap(){

            public Collection makeValueCollection(Object object) {
                TreeSet<Object> treeSet = new TreeSet<Object>();
                treeSet.add(object);
                return treeSet;
            }
        };
        Object object4 = properties.propertyNames();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = Strings.breakAtFirst(".", (String)object3);
            object = object2[0];
            string = object2[1];
            if (((String)object).equals("") || string.equals("")) {
                throw new SyntaxException("Missing object or field in " + (String)object3);
            }
            multiHashMap.addValue(object, string);
        }
        object4 = new Plan();
        object3 = new LinkedListOfPatternAssignment();
        object2 = new TreeSet(multiHashMap.keySet());
        object = object2.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            Set set = (Set)multiHashMap.get(string);
            if (set == null) {
                throw new SyntaxException("No fields for " + string);
            }
            for (String string2 : set) {
                String string3 = properties.getProperty(string + "." + string2);
                Debug.expect(string3 != null);
                Cons cons = Lisp.list(Symbol.intern(string2), Symbol.intern(string));
                PatternAssignment patternAssignment = new PatternAssignment(cons, this.parseValue(string3));
                object3.add(patternAssignment);
            }
        }
        if (!object3.isEmpty()) {
            ((Plan)object4).setWorldState((ListOfPatternAssignment)object3);
        }
        return object4;
    }

    Object parseValue(String string) {
        try {
            LList lList = Lisp.elementsFromString(string);
            if (lList.size() == 1) {
                return lList.get(0);
            }
            Debug.note("More than one object in " + Strings.quote(string) + "; ");
        }
        catch (Exception exception) {
            Debug.noteException(exception, false);
        }
        Debug.noteln("Treating as string:", (Object)Strings.quote(string));
        return string;
    }
}

