/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.AbstractIFormModel;
import ix.iface.ui.EditableObject;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GenericIFormModel
extends AbstractIFormModel {
    public GenericIFormModel(Class clazz) {
        super(clazz);
    }

    public GenericIFormModel(EditableObject editableObject) {
        super(editableObject);
    }

    public void setFields() {
        if (this.baseObjectClass == null) {
            Debug.noteln("Cannot set fields for a null base object class.");
            return;
        }
        this.nameFields = this.deriveNameFields();
        this.displayFields = this.deriveDisplayFields();
        ArrayList arrayList = new ArrayList(this.nameFields);
        arrayList.addAll(this.displayFields);
        this.deriveNames(arrayList);
        this.deriveClasses(arrayList);
    }

    protected void deriveNames(List list) {
        this.fieldNames.clear();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                this.fieldNames.put(string, this.deriveName(string));
            }
            catch (Exception exception) {}
        }
    }

    protected String deriveName(String string) {
        return UIUtil.toCapitalised(string);
    }

    protected void deriveClasses(List list) {
        this.fieldClasses.clear();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                Class clazz = this.deriveClass(string);
                this.fieldClasses.put(string, clazz);
            }
            catch (Exception exception) {}
        }
    }

    protected Class deriveClass(String string) {
        try {
            Field field = this.stringToField(string);
            return field.getType();
        }
        catch (Exception exception) {
            Debug.note("Working on class " + this.getObjectClass().getName());
            Debug.noteln("Fields are: " + UIUtil.fieldsToNames(this.getObjectClass().getFields()));
            Debug.noteln(" Problem deriving class for field " + string);
            Debug.noteException(exception);
            return null;
        }
    }

    protected List deriveNameFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        List<String> list = new LListCollector();
        list = (List)GenericIFormModel.addIfField(list, clazz, "name");
        if ((list = (List)GenericIFormModel.addIfField(list, clazz, "Name")).isEmpty()) {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string = fieldArray[i].getName().toUpperCase();
                if (string.indexOf("NAME") == -1) continue;
                list.add(fieldArray[i].getName());
            }
        }
        list = (List)GenericIFormModel.addIfField(list, clazz, "id");
        list = (List)GenericIFormModel.addIfField(list, clazz, "Id");
        list = (List)GenericIFormModel.addIfField(list, clazz, "ID");
        return list;
    }

    protected List deriveDisplayFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(clazz.getFields()));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Field field : arrayList) {
            if (!this.useField(field)) continue;
            arrayList2.add(field.getName());
        }
        return arrayList2;
    }

    protected boolean useField(Field field) {
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n) && !this.nameFields.contains(field.getName());
    }

    public String show() {
        return this.getObjectClass().getName() + UIUtil.lineSeparator + UIUtil.show(this.getNameNames()) + UIUtil.lineSeparator + UIUtil.show(this.getDisplayNames());
    }

    public void setValue(String string, Object object) {
        super.setValue(string, object);
    }

    public boolean setValue(EditableObject editableObject, String string, Object object) {
        return super.setValue(editableObject, string, object);
    }
}

