/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.icore.domain.Constraint;
import ix.icore.event.ObjectChangeEvent;
import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXRenderer;
import ix.iface.ui.JConstraintEditor;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.event.FormDataListener;
import ix.iface.ui.event.FormModelListener;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.TypedList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IFormPanel
extends JPanel
implements ActionListener,
FormModelListener {
    protected IFormModel model;
    protected HashMap nameBits = new HashMap();
    protected HashMap displayBits = new HashMap();
    protected HashMap fieldRenderers = new HashMap();
    protected HashSet simpleFields = new HashSet();
    protected HashSet listeners = new HashSet();
    protected HashMap hideBits = new HashMap();
    protected Container parent;
    FieldChooser fieldEditor;

    public IFormPanel() {
        super(new GridBagLayout());
        this.setRenderers();
    }

    public IFormPanel(IFormModel iFormModel) {
        super(new GridBagLayout());
        this.setModel(iFormModel);
        this.setRenderers();
    }

    public IFormPanel(IFormModel iFormModel, FormDataListener formDataListener) {
        super(new GridBagLayout());
        this.setModel(iFormModel, formDataListener);
        this.setRenderers();
    }

    public void setModel(IFormModel iFormModel, FormDataListener formDataListener) {
        this.setModel(iFormModel);
        this.model.addDataListener(formDataListener);
    }

    public void setModel(IFormModel iFormModel) {
        IFormModel iFormModel2 = this.model;
        this.model = iFormModel;
        if (iFormModel2 != null && this.model != null) {
            Iterator iterator = iFormModel2.getModelListeners().iterator();
            while (iterator.hasNext()) {
                this.model.addModelListener((FormModelListener)iterator.next());
            }
            iterator = iFormModel2.getDataListeners().iterator();
            while (iterator.hasNext()) {
                this.model.addDataListener((FormDataListener)iterator.next());
            }
        }
        this.ensurePanelBits(iFormModel);
        this.displayModelData();
        iFormModel.addModelListener(this);
    }

    public IFormModel getModel() {
        return this.model;
    }

    public void setRenderer(String string, IXRenderer iXRenderer) {
        this.fieldRenderers.put(string, iXRenderer);
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    public boolean isListField(String string) {
        Class clazz = this.model.getFieldClass(string);
        return List.class.isAssignableFrom(clazz);
    }

    public void setSimpleField(String string) {
        this.simpleFields.add(new String(string));
    }

    public void unsetSimpleField(String string) {
        this.simpleFields.remove(new String(string));
    }

    public boolean isSimpleField(String string) {
        return this.simpleFields.contains(new String(string));
    }

    public void ensurePanelBits(IFormModel iFormModel) {
        if (iFormModel == null) {
            return;
        }
        this.model = iFormModel;
        iFormModel.startUpdate();
        Dimension dimension = this.getSize();
        if (!this.checkNameBits()) {
            this.makeNameBits();
        }
        if (!this.checkDisplayBits()) {
            this.makeDisplayBits();
        }
        this.setSize(dimension);
        iFormModel.ignoreUpdate();
    }

    private boolean checkNameBits() {
        return this.checkBits(this.model.getNameFields(), this.nameBits);
    }

    private boolean checkDisplayBits() {
        return this.checkBits(this.model.getDisplayFields(), this.displayBits);
    }

    private boolean checkBits(List list, HashMap hashMap) {
        if (list == null && hashMap == null) {
            return true;
        }
        if (list == null && hashMap.size() == 0) {
            return true;
        }
        if (list.size() == 0 && hashMap == null) {
            return true;
        }
        if (list == null || hashMap == null) {
            return false;
        }
        if (hashMap.size() != list.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (hashMap.containsKey((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private void makeNameBits() {
        IFormPanel.clearBits(this.nameBits);
        List list = this.model.getNameFields();
        if (list.isEmpty()) {
            return;
        }
        int n = 0;
        for (String string : list) {
            this.makeNameBit(string, n);
            ++n;
        }
    }

    private void makeNameBit(final String string, int n) {
        JTextField jTextField = new JTextField();
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)this, this.model.getFieldName(string), jTextField);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                IFormPanel.this.saveFieldData(string);
            }
        });
        this.nameBits.put(string, thingEditorPanel);
        this.addNameBit(string, thingEditorPanel, n);
    }

    private void makeDisplayBits() {
        IFormPanel.clearBits(this.displayBits);
        HashMap hashMap = new HashMap(this.hideBits);
        this.hideBits.clear();
        int n = this.model.getNameFields().size();
        List list = this.model.getDisplayFields();
        if (list.isEmpty()) {
            return;
        }
        int n2 = 1;
        for (String string : list) {
            IXEditorPanel iXEditorPanel = this.makeDisplayBit(string);
            IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
            if (iXRenderer != null) {
                iXEditorPanel.setRenderer(iXRenderer);
            }
            this.displayBits.put(string, iXEditorPanel);
            if (hashMap.containsKey(string)) {
                this.hideBits.put(string, iXEditorPanel);
            }
            this.addDisplayBit(string, (JPanel)((Object)iXEditorPanel), n2, n);
            ++n2;
        }
    }

    private void addRenderer(String string, IXEditorPanel iXEditorPanel) {
        IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
        if (iXRenderer != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    private void ensureFieldEditor(Frame frame) {
        if (this.fieldEditor == null) {
            this.fieldEditor = new FieldChooser(frame);
        }
        this.fieldEditor.setVisible(false);
    }

    public void editFields(Frame frame) {
        this.ensureFieldEditor(frame);
        this.fieldEditor.start((Object)this, this.hideBits.keySet());
        this.fieldEditor.setVisible(true);
    }

    public void gotConstraint(JConstraintEditor jConstraintEditor, Object object, Object object2) {
        if (object2 == null) {
            this.setHideBits(null);
        } else if (object2 instanceof Constraint) {
            List list = ((Constraint)object2).getParameters();
            this.setHideBits(list);
        }
    }

    protected void hideBits() {
        try {
            Iterator iterator = this.getAllFields();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object v = this.hideBits.get(e);
                if (v != null) {
                    ((JComponent)v).setVisible(false);
                    continue;
                }
                JComponent jComponent = (JComponent)((Object)this.getFieldBit(e.toString()));
                jComponent.setVisible(true);
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    protected void setHideBits(Collection collection) {
        this.hideBits.clear();
        if (collection == null) {
            return;
        }
        for (Object e : collection) {
            IXEditorPanel iXEditorPanel = this.getFieldBit(e.toString());
            this.hideBits.put(e, iXEditorPanel);
        }
        this.updateHideBits();
    }

    protected void updateHideBits() {
        if (this.hideBits == null || this.hideBits.isEmpty()) {
            return;
        }
        for (Object v : this.hideBits.values()) {
            if (!(v instanceof JComponent)) continue;
            ((JComponent)v).setVisible(false);
        }
    }

    protected static void clearBits(HashMap hashMap) {
        Collection collection = hashMap.values();
        if (collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setVisible(false);
        }
        hashMap.clear();
    }

    private void addNameBit(String string, JComponent jComponent, int n) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, d, 0.0, 11, 2, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    private void addDisplayBit(String string, JComponent jComponent, int n, int n2) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, n2, 1, 1.0, d, 17, 1, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected IXEditorPanel makeDisplayBit(final String string) {
        AbstractEditorPanel abstractEditorPanel;
        String string2 = this.model.getFieldName(string);
        Class clazz = this.model.getFieldClass(string);
        if (Number.class.isAssignableFrom(clazz) || Symbol.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            JTextField jTextField = new JTextField();
            abstractEditorPanel = new ThingEditorPanel((EventListener)this, string2, jTextField);
            jTextField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    IFormPanel.this.saveFieldData(string);
                }
            });
        } else if ((Collection.class.isAssignableFrom(clazz) || Array.class.isAssignableFrom(clazz)) && !this.isSimpleField(string)) {
            String[] stringArray = new String[]{"Add", "Edit", "Delete"};
            JList jList = new JList();
            jList.setVisibleRowCount(3);
            abstractEditorPanel = new ListEditorPanel((EventListener)this, string2, true, jList, stringArray);
        } else {
            JTextArea jTextArea = new JTextArea();
            jTextArea.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    IFormPanel.this.saveFieldData(string);
                }
            });
            abstractEditorPanel = new ThingEditorPanel((EventListener)this, string2, true, (JComponent)jTextArea);
        }
        abstractEditorPanel.setEnabled(this.model.isEditable(string));
        return abstractEditorPanel;
    }

    public void displayModelData() {
        if (this.model == null) {
            return;
        }
        this.clearFields();
        if (this.model.getObject() == null) {
            return;
        }
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.displayFieldData((String)iterator.next());
        }
    }

    public void displayFieldData(String string) {
        this.clearField(string);
        Object object = this.model.getValue(string);
        if (object == null) {
            return;
        }
        this.setFieldData(string, object);
    }

    public void setFieldData(String string, Object object) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            Object object2 = this.renderValue(string, object);
            iXEditorPanel.setData(object2);
            ((JComponent)((Object)iXEditorPanel)).paintImmediately(((JComponent)((Object)iXEditorPanel)).getBounds());
        }
    }

    public void clearFields() {
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.clearField((String)iterator.next());
        }
    }

    public void clearField(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            return;
        }
        iXEditorPanel.removeData();
    }

    protected Object renderValue(String string, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AbstractCollection) {
            return ((AbstractCollection)object).toArray();
        }
        return object;
    }

    protected Object deRenderValue(String string, Object object) {
        Class<?> clazz;
        if (object == null) {
            if (this.isListField(string)) {
                return Lisp.NIL;
            }
            return null;
        }
        Class clazz2 = this.model.getFieldClass(string);
        if (clazz2.isAssignableFrom(clazz = object.getClass())) {
            return object;
        }
        if (clazz.isArray()) {
            try {
                if (TypedList.class.isAssignableFrom(clazz2)) {
                    return UIUtil.newTypedList(clazz2, object);
                }
                if (Collection.class.isAssignableFrom(clazz2)) {
                    Collection collection = (Collection)clazz2.newInstance();
                    collection.addAll(Arrays.asList((Object[])object));
                    return collection;
                }
            }
            catch (Exception exception) {
                Debug.noteln("deRenderValue: caught problem with field " + string);
                Debug.noteln("Data is of type " + object.getClass());
                Debug.noteException(exception);
                return object;
            }
        }
        return object;
    }

    protected void setRenderers() {
    }

    public IXEditorPanel getFieldBit(String string) {
        IXEditorPanel iXEditorPanel = (IXEditorPanel)this.nameBits.get(string);
        if (iXEditorPanel == null) {
            iXEditorPanel = (IXEditorPanel)this.displayBits.get(string);
        }
        return iXEditorPanel;
    }

    public Object getFieldData(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            return null;
        }
        return iXEditorPanel.getData();
    }

    public void saveFieldData(String string) {
        Object object = this.getFieldData(string);
        Object object2 = this.deRenderValue(string, object);
        this.model.setValue(string, object2);
    }

    public void saveToObject() {
        EditableObject editableObject = this.model.getObject();
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        for (String string : lListCollector) {
            Object object = this.getFieldData(string);
            Object object2 = this.deRenderValue(string, object);
            this.model.setValue(string, object2);
        }
    }

    public void saveToObject(EditableObject editableObject) {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        for (String string : lListCollector) {
            Object object = this.getFieldData(string);
            Object object2 = this.deRenderValue(string, object);
            this.model.setValue(editableObject, string, object2);
        }
    }

    private Iterator getAllFields() {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        return lListCollector.iterator();
    }

    public void clear() {
        this.model.clearData();
    }

    public void formModelChanged(String string, ObjectChangeEvent objectChangeEvent) {
        if (string.equals("object") || string.equals("allFields")) {
            this.displayModelData();
        } else if (string.equals("fieldNames")) {
            List list = this.model.getNameFields();
            this.updateNames(list, this.nameBits);
            list = this.model.getDisplayFields();
            this.updateNames(list, this.displayBits);
        } else if (string.equals("Field")) {
            String string2 = objectChangeEvent.getField();
            this.displayFieldData(string2);
        } else {
            this.model.startUpdate();
            this.setModel(this.model);
            this.model.ignoreUpdate();
        }
    }

    public void updateNames(List list, HashMap hashMap) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            String string2 = this.model.getFieldName(string);
            if (string2 == null) continue;
            IXEditorPanel iXEditorPanel = (IXEditorPanel)hashMap.get(string);
            if (iXEditorPanel == null) {
                Debug.noteln("Cannot find bit for " + string2);
                continue;
            }
            iXEditorPanel.setLabel(string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void addFormActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public class FieldChooser
    extends JConstraintEditor {
        private JPanel fieldGrid;
        private HashMap fieldBits;

        public FieldChooser(Frame frame) {
            super(frame, "Please select the fields to show");
            this.fieldGrid = new JPanel(new GridLayout(3, 4));
        }

        protected Component makeBits() {
            return this.fieldGrid;
        }

        public void start() {
            Iterator iterator = IFormPanel.this.getAllFields();
            this.makeFieldToggles(iterator);
            this.initFromObject();
        }

        public void makeFieldToggles(Iterator iterator) {
            Component[] componentArray = this.fieldGrid.getComponents();
            if (componentArray.length != 0) {
                this.fieldGrid.removeAll();
            }
            this.fieldBits.clear();
            if (iterator == null) {
                return;
            }
            while (iterator.hasNext()) {
                Object e = iterator.next();
                JCheckBox jCheckBox = new JCheckBox(iterator.toString(), true);
                this.fieldGrid.add(jCheckBox);
                this.fieldBits.put(e, jCheckBox);
            }
        }

        public void initFromObject() {
            this.makeFieldToggles(IFormPanel.this.getAllFields());
        }

        public void setFromObject(Object object) {
            Set set;
            Collection collection = null;
            if (object instanceof Collection) {
                collection = (Collection)object;
            }
            if ((set = this.fieldBits.keySet()) == null) {
                return;
            }
            for (Object e : set) {
                Object v = this.fieldBits.get(e);
                if (v == null) {
                    Debug.noteln("IFP: No bit found for field", e);
                    continue;
                }
                ((JCheckBox)v).setSelected(!collection.contains(e));
            }
        }

        public Constraint collectConstraint() {
            Set set = this.fieldBits.keySet();
            ArrayList arrayList = new ArrayList();
            if (set == null) {
                return new Constraint("Viewer", "view-fields", arrayList);
            }
            for (Object e : set) {
                Object v = this.fieldBits.get(e);
                if (((JCheckBox)v).isSelected()) continue;
                arrayList.add(e);
            }
            return new Constraint("Viewer", "view-fields", arrayList);
        }
    }
}

