/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.HTMLFrame;
import ix.iface.ui.HelpFrame;
import ix.iface.ui.IXToolItem;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.ToolFrame;
import ix.util.Debug;
import ix.util.Util;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class JFrameMT
extends ToolFrame
implements ActionListener {
    CatchingActionListener catchingListener;
    int TBB_Y = 4;
    int TBB_WIDTH = 51;
    int TBB_HEIGHT = 27;
    int TB_HEIGHT = this.TBB_HEIGHT + 6;
    public JFileChooser fileChooser;
    public File directory;
    public File file;
    public ArrayList extensions = new ArrayList();
    public String fileType = "";
    public HelpFrame helpFrame;
    public String helpFile;
    public ImageIcon helpFrameIcon;
    public JPanel mainJPanel = new JPanel();
    public JPanel JPanel2 = new JPanel();
    public JMenuBar menuBar = new JMenuBar();
    public JToolBar toolBar = new JToolBar();
    public JMenu fileMenu = this.makeMenu(this.menuBar, "File");
    public JMenu editMenu = this.makeMenu(this.menuBar, "Edit");
    public JMenu viewMenu = this.makeMenu(this.menuBar, "View");
    public JMenu toolsMenu = this.makeMenu(this.menuBar, "Tools");
    public JMenu helpMenu = this.makeMenu(this.menuBar, "Help");
    public JMenu optionsMenu;
    protected ImageIcon newIcon = Util.resourceImageIcon("ix-new.gif");
    protected ImageIcon openIcon = Util.resourceImageIcon("ix-open.gif");
    protected ImageIcon saveIcon = Util.resourceImageIcon("ix-save.gif");
    protected ImageIcon revertIcon = Util.resourceImageIcon("ix-revert.gif");
    protected ImageIcon redoIcon = Util.resourceImageIcon("ix-redo.gif");
    protected ImageIcon cutIcon = Util.resourceImageIcon("ix-delete.gif");
    protected ImageIcon copyIcon = Util.resourceImageIcon("ix-copy.gif");
    protected ImageIcon pasteIcon = Util.resourceImageIcon("ix-paste.gif");
    protected ImageIcon helpIcon = Util.resourceImageIcon("ix-help.gif");
    public IXToolItem newItem = new IXToolItem(this.fileMenu, this.toolBar, (ActionListener)this, "new", "New", this.newIcon, 'N', "Create new item");
    public IXToolItem openItem = new IXToolItem(this.fileMenu, this.toolBar, this, "open", "Open...", "Open", this.openIcon, 'O', "Open file and load");
    public IXToolItem saveItem = new IXToolItem(this.fileMenu, this.toolBar, (ActionListener)this, "save", "Save", this.saveIcon, 'S', "Save to file");
    public IXToolItem saveAsItem = new IXToolItem(this.fileMenu, this, "saveAs", "Save As...", "Save to new file");
    public IXToolItem toolbarItem;
    public IXToolItem closeItem = new IXToolItem(this.fileMenu, (ActionListener)this, "close", "Close Window", 'C', "Close window");
    public IXToolItem exitItem = new IXToolItem(this.fileMenu, (ActionListener)this, "exit", "Exit", 'X', "Exit application");
    public IXToolItem revertItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "undo", "Undo", this.revertIcon, 'U', "Undo (revert changes)");
    public IXToolItem redoItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "redo", "Redo", this.redoIcon, 'R', "Redo the last undo");
    public IXToolItem cutItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "cut", "Cut", this.cutIcon, 'C', "Cut");
    public IXToolItem copyItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "copy", "Copy", this.copyIcon, 'C', "Copy");
    public IXToolItem pasteItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "paste", "Paste", this.pasteIcon, 'P', "Paste");
    public IXToolItem helpItem = new IXToolItem(this.helpMenu, this.toolBar, (ActionListener)this, "help", "Help", this.helpIcon, 'H', "Help");
    public IXToolItem manualItem = new IXToolItem(this.helpMenu, (ActionListener)this, "manual", "Manual", 'M', "Manual");
    public IXToolItem aboutItem = new IXToolItem(this.helpMenu, (ActionListener)this, "about", "About", 'A', "About the application");

    public JFrameMT() {
        this.catchingListener = new CatchingActionListener(this);
        this.makeFrame();
        this.makeMainPanel();
    }

    public JFrameMT(String string) {
        this();
        this.setTitle(string);
    }

    public void makeFrame() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(488, 309);
        this.setVisible(false);
    }

    private void makeMainPanel() {
        this.mainJPanel.setLayout(new GridBagLayout());
        this.getContentPane().add("Center", this.mainJPanel);
    }

    public void makeMenuToolBars() {
        this.setJMenuBar(this.menuBar);
        this.JPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.getContentPane().add("North", this.JPanel2);
        this.toolBar.setAlignmentY(0.222222f);
        this.JPanel2.add(this.toolBar);
    }

    public void ensureFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = this.directory == null ? new JFileChooser() : new JFileChooser(this.directory);
            this.fileChooser.setFileFilter(new FileFilter(){

                public String getDescription() {
                    return JFrameMT.this.fileType;
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return JFrameMT.this.validFileName(file.getName());
                }
            });
        }
    }

    public boolean validFileName(String string) {
        if (this.extensions == null || this.extensions.size() == 0) {
            return true;
        }
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            if (!string.endsWith("." + iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void makeDefaultMenu() {
        Debug.noteln("JFMT: making menu");
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeViewMenu();
        this.makeToolsMenu();
        this.menuBar.add(Box.createHorizontalGlue());
        this.makeHelpMenu();
        this.adaptDefaultMenu();
    }

    public void makeFileMenu() {
        this.newItem.showItem();
        this.openItem.showItem();
        this.saveItem.showItem();
        this.saveAsItem.showItem();
        this.fileMenu.addSeparator();
        this.makeOptionsMenu();
        this.fileMenu.add(this.optionsMenu);
        this.fileMenu.addSeparator();
        this.makeFileMenuExits();
    }

    public void makeFileMenuExits() {
        this.closeItem.showItem();
        this.exitItem.showItem();
    }

    public void makeOptionsMenu() {
        this.optionsMenu = this.makeMenu(this.fileMenu, "Options");
        this.makeToolbarItem(this.optionsMenu);
    }

    public void makeToolbarItem(JMenu jMenu) {
        this.toolbarItem = new IXToolItem(jMenu, this, "toolbar", "Toolbar", "Toggle toolbar on/off");
        JCheckBoxMenuItem jCheckBoxMenuItem = this.toolbarItem.makeCheckItem();
        jCheckBoxMenuItem.setState(true);
        this.toolbarItem.showItem();
    }

    public void makeEditMenu() {
        this.cutItem.showItem();
        this.copyItem.showItem();
        this.pasteItem.showItem();
    }

    public void makeViewMenu() {
    }

    public void makeToolsMenu() {
    }

    public void makeHelpMenu() {
        this.helpItem.showItem();
        this.manualItem.showItem();
        this.aboutItem.showItem();
    }

    public void MakeDefaultToolbar() {
        this.newItem.showButton();
        this.openItem.showButton();
        this.saveItem.showButton();
        this.toolBar.addSeparator();
        this.revertItem.showButton();
        this.redoItem.showButton();
        this.cutItem.showButton();
        this.copyItem.showButton();
        this.pasteItem.showButton();
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalGlue());
        this.helpItem.showButton();
        this.adaptDefaultToolbar();
    }

    public void makeDefaultMenuToolbar() {
        this.makeFileMenuTool(this.menuBar);
        this.makeEditMenuTool(this.menuBar);
        this.makeViewMenuTool(this.menuBar);
        this.makeToolsMenuTool(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        Debug.noteln("JFMT: made glue");
        this.makeHelpMenuTool(this.menuBar);
        this.adaptDefaultMenuToolbar();
    }

    public void adaptDefaultMenuToolbar() {
    }

    public void adaptDefaultMenu() {
    }

    public void adaptDefaultToolbar() {
    }

    public JMenu makeFileMenuTool(JComponent jComponent) {
        this.makeFileMenuToolFiles(this.fileMenu);
        this.makeOptionsMenuTool(this.fileMenu);
        this.makeFileMenuToolExits(this.fileMenu);
        return this.fileMenu;
    }

    public void makeFileMenuToolFiles(JMenu jMenu) {
        this.newItem.show();
        this.openItem.show();
        this.saveItem.show();
        this.saveAsItem.show();
        jMenu.addSeparator();
    }

    public void makeFileMenuToolExits(JMenu jMenu) {
        jMenu.addSeparator();
        this.closeItem.show();
        this.exitItem.show();
    }

    public JMenu makeOptionsMenuTool(JComponent jComponent) {
        this.makeOptionsMenu();
        return this.optionsMenu;
    }

    public JMenu makeEditMenuTool(JComponent jComponent) {
        this.makeEditMenu();
        this.toolBar.addSeparator();
        this.cutItem.showButton();
        this.copyItem.showButton();
        this.pasteItem.showButton();
        return this.editMenu;
    }

    public JMenu makeViewMenuTool(JComponent jComponent) {
        return this.viewMenu;
    }

    public JMenu makeToolsMenuTool(JComponent jComponent) {
        return this.toolsMenu;
    }

    public JMenu makeHelpMenuTool(JComponent jComponent) {
        this.makeHelpMenu();
        this.toolBar.addSeparator();
        this.helpItem.showButton();
        this.manualItem.showButton();
        this.aboutItem.showButton();
        return this.helpMenu;
    }

    public void placeToolbarButton(JButton jButton, int n) {
        jButton.setBounds(n, this.TBB_Y, this.TBB_WIDTH, this.TBB_HEIGHT);
    }

    public JRadioButtonMenuItem makeRadioMenuItem(JComponent jComponent, String string, String string2) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        jRadioButtonMenuItem.setActionCommand(string);
        jRadioButtonMenuItem.addActionListener(this.catchingListener);
        jComponent.add(jRadioButtonMenuItem);
        return jRadioButtonMenuItem;
    }

    public JMenu makeMenu(JComponent jComponent, String string) {
        JMenu jMenu = new JMenu(string);
        jMenu.setActionCommand(string);
        jMenu.setMnemonic((int)string.charAt(0));
        jComponent.add(jMenu);
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        Debug.noteln("JFrameMT: action command is", (Object)string);
        if (string == "open") {
            this.openFile();
        } else if (string == "save") {
            this.saveFile();
        } else if (string == "toolbar") {
            this.toggleToolbar(((JCheckBoxMenuItem)object).getState());
        } else if (string == "close") {
            this.close();
        } else if (string == "exit") {
            this.exit();
        } else if (string == "about") {
            this.aboutDialog();
        } else if (string == "saveAs") {
            this.saveFileAs();
        } else if (string.equals("manual")) {
            this.userManual();
        } else if (string.equals("help")) {
            this.userHelp();
        } else {
            String string2 = ((AbstractButton)object).getText();
            if (string2 == "" || string2 == null) {
                string2 = string;
            }
            UIUtil.notImplemented(this, string2);
        }
    }

    public void close() {
        if (this.fileChooser != null) {
            this.fileChooser.setVisible(false);
        }
        if (this.helpFrame != null) {
            this.helpFrame.setVisible(false);
        }
        this.setVisible(false);
    }

    public void exitApplication() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int n = JOptionPane.showConfirmDialog(this, "Do you really want to exit?", "JFC Application - Exit", 0, 3);
            if (n == 0) {
                this.close();
                this.dispose();
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openFile() {
        try {
            File file = this.userChooseFile();
            if (file != null) {
                this.file = file;
                this.openFile(this.file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File userChooseFile() {
        try {
            this.ensureFileChooser();
            int n = this.fileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                return file;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void saveFile() {
        try {
            if (this.file == null) {
                this.saveFileAs();
            } else {
                this.saveToFile(this.file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveFileAs() {
        try {
            this.ensureFileChooser();
            int n = this.fileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.saveToFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveToFile(File file) {
        UIUtil.notImplemented(this, "Saving to file");
    }

    public void openFile(File file) {
        UIUtil.notImplemented(this, "Opening files");
    }

    public void toggleToolbar(boolean bl) {
        int n;
        int n2;
        Rectangle rectangle = this.mainJPanel.getBounds();
        int n3 = this.JPanel2.getHeight();
        if (bl) {
            n2 = n3;
            n = (int)rectangle.getHeight() - n3;
        } else {
            n2 = 0;
            n = (int)rectangle.getHeight() + n3;
        }
        this.JPanel2.setVisible(bl);
        this.mainJPanel.setBounds(0, n2, (int)rectangle.getWidth(), n);
        this.mainJPanel.doLayout();
        this.validate();
    }

    public void exit() {
        try {
            this.exitApplication();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void aboutDialog() {
        JOptionPane.showMessageDialog(this, "About " + this.getTitle(), "About " + this.getTitle(), 1);
    }

    public void userManual() {
        UIUtil.notImplemented(this, "The user manual");
    }

    public void userHelp() {
        this.ensureHelpFrame();
        this.helpFrame.setVisible(true);
    }

    public HTMLFrame ensureHelpFrame() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame(this.helpFile, this.getTitle() + " - Help");
            this.helpFrame.setIconImage(this.helpFrameIcon.getImage());
            this.helpFrame.setVisible(false);
        }
        return this.helpFrame;
    }
}

