/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.tree;

import ix.iface.ui.tree.EditableTreeModel;
import ix.iface.ui.tree.IXNode;
import ix.iface.ui.tree.IXTreeNode;
import ix.util.Debug;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeModel;

public class IXTrees {
    public static final String ROOTNAME = "Root";

    public static TreeModel setupTreeModel(EditableTreeModel editableTreeModel, List list) {
        IXTreeNode iXTreeNode;
        if (editableTreeModel == null) {
            return null;
        }
        editableTreeModel.clearModel();
        List list2 = IXTrees.findRoots(list);
        if (list2 == null || list2.size() == 0) {
            if (list != null && !list.isEmpty()) {
                Debug.noteln("WARNING: IXTrees cannot find root in", (Object)list);
            }
            iXTreeNode = null;
        } else if (list2.size() == 1) {
            iXTreeNode = editableTreeModel.newIXTreeNode(list2.get(0));
        } else {
            Object object = editableTreeModel.makeUserObject(ROOTNAME, list2);
            iXTreeNode = editableTreeModel.newIXTreeNode(object);
        }
        editableTreeModel.setRoot(iXTreeNode);
        return editableTreeModel;
    }

    public static List findRoots(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<IXNode> arrayList = new ArrayList<IXNode>();
        for (IXNode iXNode : list) {
            List list2;
            if (iXNode == null || (list2 = iXNode.getParents()) != null && list2.size() != 0) continue;
            arrayList.add(iXNode);
        }
        return arrayList;
    }
}

