/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Parameters;
import java.awt.Font;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.OceanTheme;

public class IXOceanTheme
extends OceanTheme {
    private int secondary3_value = Parameters.getInt("metal-theme-secondary3", 0xCCCCCC);
    private ColorUIResource secondary3 = new ColorUIResource(this.secondary3_value);
    private boolean changeFont = Parameters.haveParameter("font-increment");
    private int fontIncrement = Parameters.getInt("font-increment", 0);

    public IXOceanTheme() {
        if (this.changeFont) {
            Debug.noteln("font-increment =", this.fontIncrement);
        }
        if (Parameters.haveParameter("metal-theme-secondary3")) {
            Debug.noteln("metal-theme-secondary3 = " + Integer.toHexString(this.secondary3_value));
        }
    }

    protected ColorUIResource getSecondary3() {
        if (Parameters.haveParameter("metal-theme-secondary3")) {
            return this.secondary3;
        }
        return super.getSecondary3();
    }

    public FontUIResource getControlTextFont() {
        return this.adjustFont(super.getControlTextFont());
    }

    public FontUIResource getSystemTextFont() {
        return this.adjustFont(super.getSystemTextFont());
    }

    public FontUIResource getUserTextFont() {
        return this.adjustFont(super.getUserTextFont());
    }

    public FontUIResource getMenuTextFont() {
        return this.adjustFont(super.getMenuTextFont());
    }

    public FontUIResource getWindowTitleFont() {
        return this.adjustFont(super.getWindowTitleFont());
    }

    public FontUIResource getSubTextFont() {
        return this.adjustFont(super.getSubTextFont());
    }

    protected FontUIResource adjustFont(FontUIResource fontUIResource) {
        if (!this.changeFont) {
            return fontUIResource;
        }
        Font font = fontUIResource.deriveFont(this.fontIncrement > 2 ? 0 : fontUIResource.getStyle(), fontUIResource.getSize() + this.fontIncrement);
        return new FontUIResource(font);
    }
}

