/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.AlphabetizingMenu;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.ToolController;
import ix.util.Debug;
import ix.util.Strings;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;

public class ToolManager {
    protected List controllers = new LinkedList();
    protected AlphabetizingMenu toolsMenu = new AlphabetizingMenu("Tools");

    public ToolManager() {
        this.toolsMenu.setEnabled(false);
    }

    public synchronized AlphabetizingMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public synchronized ToolController findTool(String string) {
        for (ToolController toolController : this.controllers) {
            if (!toolController.getToolName().equals(string)) continue;
            return toolController;
        }
        return null;
    }

    public ToolController findToolElseError(String string) {
        ToolController toolController = this.findTool(string);
        if (toolController != null) {
            return toolController;
        }
        throw new IllegalArgumentException("There is no tool named " + Strings.quote(string));
    }

    public synchronized void addTool(ToolController toolController) {
        if (this.findTool(toolController.getToolName()) != null) {
            throw new IllegalArgumentException("Attempt to add a second tool named " + Strings.quote(toolController.getToolName()));
        }
        this.controllers.add(toolController);
        this.toolsMenu.insert(this.makeMenuItem(toolController));
        this.toolsMenu.setEnabled(true);
    }

    protected JMenuItem makeMenuItem(final ToolController toolController) {
        JMenuItem jMenuItem = new JMenuItem(toolController.getToolName());
        jMenuItem.addActionListener(new CatchingActionListener(){

            protected void innerActionPerformed(ActionEvent actionEvent) {
                Debug.expect(actionEvent.getActionCommand().equals(toolController.getToolName()));
                ToolManager.this.activateTool(toolController);
            }
        });
        return jMenuItem;
    }

    protected void activateTool(ToolController toolController) {
        toolController.ensureToolVisible();
    }
}

