/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.YesNo;
import ix.icore.plan.Plan;
import ix.iface.util.CatchingActionListener;
import ix.ip2.ActivityInsertionEditor;
import ix.ip2.ActivityItem;
import ix.ip2.AgendaItem;
import ix.ip2.BindingViewer;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.LoadPlanHandler;
import ix.ip2.PanelController;
import ix.ip2.PlanMaker;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.Lisp;
import ix.util.xml.XMLSaver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractAgendaItemPopupMenu
extends JPopupMenu
implements ActionListener {
    protected Ip2 ip2;
    protected AgendaItem item;
    protected Set unboundVariables;
    protected JMenuItem foldItem = this.makeMenuItem("Fold");
    protected JMenuItem bindItem = this.makeMenuItem("Bind Variables");
    protected JMenuItem deleteItem = this.makeMenuItem("Delete");
    protected JMenuItem completeItem = this.makeMenuItem("Consider Done");
    protected JMenu insertMenu = new JMenu("Insert");
    protected JMenuItem insertBeforeItem = this.makeMenuItem("Before");
    protected JMenuItem insertAfterItem = this.makeMenuItem("After");
    protected JMenuItem forwardReportItem = null;
    protected static Map insertionEditors = new WeakHashMap();

    public AbstractAgendaItemPopupMenu(Ip2 ip2, AgendaItem agendaItem) {
        this.ip2 = ip2;
        this.item = agendaItem;
        this.add(this.makeMenuItem("Show Details"));
        this.add(this.foldItem);
        this.add(this.bindItem);
        this.foldItem.setEnabled(false);
        this.bindItem.setEnabled(false);
        this.add(this.deleteItem);
        this.deleteItem.setEnabled(false);
        this.insertMenu.add(this.insertBeforeItem);
        this.insertMenu.add(this.insertAfterItem);
        if (agendaItem instanceof ActivityItem) {
            this.add(this.insertMenu);
        }
        this.add(this.makeMenuItem("Copy to Messenger"));
        if (agendaItem.getAbout().getReportBack() == YesNo.YES) {
            this.add(this.makeMenuItem("Send Report to " + agendaItem.getAbout().getSenderId()));
        }
        if (agendaItem instanceof ActivityItem) {
            this.add(this.makeMenuItem("Send Subplan"));
            this.add(this.makeMenuItem("Send Subplan With Report-Back"));
            this.add(this.makeMenuItem("Save Subplan"));
        }
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void noticeItemState() {
        Name name;
        this.foldItem.setEnabled(!this.item.getChildren().isEmpty());
        this.foldItem.setText(this.isOpen() ? "Fold" : "Unfold");
        this.bindItem.setEnabled(!this.item.getUnboundVars().isEmpty());
        this.deleteItem.setEnabled(this.canDelete(this.item));
        if (this.item.getStatus() == Status.EXECUTING || this.item.getStatus() == Status.COMPLETE) {
            this.insertBeforeItem.setEnabled(false);
        }
        if ((name = this.item.getAbout().getForwardedTo()) != null && this.forwardReportItem == null) {
            this.forwardReportItem = this.makeMenuItem("Send Report to " + name);
            this.add(this.forwardReportItem);
        }
        this.ip2.getFrame().adjustAgendaItemPopup(this, this.item);
        if ((this.item.getStatus() == Status.EXECUTING || this.item.getStatus() == Status.IMPOSSIBLE) && this.item.getChildren().isEmpty()) {
            this.add(this.completeItem);
        }
    }

    protected boolean canDelete(AgendaItem agendaItem) {
        return agendaItem.getParent() == null && agendaItem.getChildren().isEmpty() && (agendaItem.getStatus() == Status.POSSIBLE || agendaItem.getStatus() == Status.BLANK);
    }

    abstract void showDetails();

    abstract boolean isOpen();

    abstract void fold();

    abstract void unfold();

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Item popup command", (Object)string);
        if (string.equals("Show Details")) {
            this.showDetails();
        } else if (string.equals("Fold")) {
            this.fold();
        } else if (string.equals("Unfold")) {
            this.unfold();
        } else if (string.equals("Bind Variables")) {
            Set set = this.item.getUnboundVars();
            Debug.expect(!set.isEmpty(), "No variables to bind.");
            this.unboundVariables = set;
            BindingViewer bindingViewer = new BindingViewer(this.ip2, set){

                public void handleBindings(Map map) {
                    if (map != null) {
                        AbstractAgendaItemPopupMenu.this.bind(map);
                    }
                }
            };
        } else if (string.equals("Delete")) {
            if (Util.dialogConfirms(this.ip2.getFrame(), "Are you sure you want to delete?")) {
                this.deleteItem();
            }
        } else if (string.equals("Before")) {
            this.insertBefore();
        } else if (string.equals("After")) {
            this.insertAfter();
        } else if (string.equals("Copy to Messenger")) {
            this.copyItemToMessenger();
        } else if (string.startsWith("Send Report")) {
            if (actionEvent.getSource() == this.forwardReportItem) {
                this.ip2.frame.getChatFrameVisible().initForwardReport(this.item.getAbout());
            } else {
                this.ip2.frame.getChatFrameVisible().initReportBackReport(this.item.getAbout());
            }
        } else if (string.equals("Send Subplan")) {
            ActivityItem activityItem = (ActivityItem)this.item;
            Plan plan = new PlanMaker(this.ip2).getPlan(activityItem);
            Activity activity = new Activity(Lisp.list(LoadPlanHandler.S_LOAD_PLAN, plan));
            this.ip2.frame.getSendPanelVisible().initActivity(activity);
        } else if (string.equals("Send Subplan With Report-Back")) {
            ActivityItem activityItem = (ActivityItem)this.item;
            Plan plan = new PlanMaker(this.ip2).getPlanWithReportBack(activityItem);
            Activity activity = new Activity(Lisp.list(LoadPlanHandler.S_LOAD_PLAN, plan));
            this.ip2.frame.getSendPanelVisible().initActivity(activity);
        } else if (string.equals("Save Subplan")) {
            ActivityItem activityItem = (ActivityItem)this.item;
            Plan plan = new PlanMaker(this.ip2).getPlan(activityItem);
            new XMLSaver(this.ip2.getFrame(), Plan.class).saveObject(plan);
        } else if (string.equals("Consider Done")) {
            this.item.setStatus(Status.COMPLETE);
        } else {
            throw new UnsupportedOperationException("Nothing to do for item popup command " + string);
        }
    }

    protected void bind(Map map) {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.ip2.getModelManager();
        try {
            ip2ModelManager.bindVariables(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.displayException(illegalArgumentException);
        }
        ip2ModelManager.logBindings(map);
    }

    protected void deleteItem() {
        PanelController panelController = this.ip2.getController();
        TaskItem taskItem = this.item.getAbout();
        if (taskItem instanceof Issue) {
            panelController.getIssueAgenda().removeItem(this.item);
        } else if (taskItem instanceof Activity) {
            panelController.getActivityAgenda().removeItem(this.item);
        } else {
            Debug.expect(false, "Can't delete", taskItem);
        }
    }

    protected void copyItemToMessenger() {
        TaskItem taskItem = this.item.getAbout();
        if (taskItem instanceof Issue) {
            this.ip2.frame.getSendPanelVisible().initIssue((Issue)taskItem);
        } else if (taskItem instanceof Activity) {
            this.ip2.frame.getSendPanelVisible().initActivity((Activity)taskItem);
        } else {
            Debug.expect(false, "Can't copy to Messenger", taskItem);
        }
    }

    protected void insertBefore() {
        this.ensureInsertionEditor().insertBefore(this.item);
    }

    protected void insertAfter() {
        this.ensureInsertionEditor().insertAfter(this.item);
    }

    protected ActivityInsertionEditor ensureInsertionEditor() {
        if (insertionEditors.get(this.ip2) == null) {
            insertionEditors.put(this.ip2, new ActivityInsertionEditor(this.ip2));
        }
        return (ActivityInsertionEditor)insertionEditors.get(this.ip2);
    }
}

