/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.ip2.ActivityEditor;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.ItemEditor;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.PatternParser;
import ix.util.lisp.Lisp;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class ActivityInsertionEditor
extends ActivityEditor {
    static final String BEFORE = "before";
    static final String AFTER = "after";
    Ip2 ip2;
    Ip2ModelManager ip2MM;
    JLabel descriptionLabel = new JLabel("Insert ...", 0);
    String placement = null;
    AgendaItem target;

    ActivityInsertionEditor(Ip2 ip2) {
        super(ip2.activityViewer, ip2.getAgentDisplayName() + " Activity Insertion Editor");
        this.ip2 = ip2;
        this.ip2MM = ip2.getIp2ModelManager();
        this.contentPane = this.frame.getContentPane();
        this.contentPane.add((Component)this.descriptionLabel, "North");
        this.editPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
        this.frame.pack();
    }

    void insertBefore(AgendaItem agendaItem) {
        this.setupForInsertion(BEFORE, agendaItem);
    }

    void insertAfter(AgendaItem agendaItem) {
        this.setupForInsertion(AFTER, agendaItem);
    }

    void setupForInsertion(String string, AgendaItem agendaItem) {
        this.showNewItem();
        this.placement = string;
        this.target = agendaItem;
        String string2 = PatternParser.unparse(agendaItem.getPattern());
        this.descriptionLabel.setText("Insert " + string + " " + string2);
    }

    protected ItemEditor.EditPanel makeEditPanel() {
        return new InsertionEditPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertItem(AgendaItem agendaItem) {
        block5: {
            this.ip2MM.beginUndoableTransaction("Insert " + this.placement);
            try {
                if (this.placement == BEFORE) {
                    this.insertBeforeTarget(agendaItem);
                    break block5;
                }
                if (this.placement == AFTER) {
                    this.insertAfterTarget(agendaItem);
                    break block5;
                }
                throw new ConsistencyException();
            }
            finally {
                this.ip2MM.endUndoableTransaction("Insert " + this.placement);
            }
        }
        this.ip2.resetViewers();
        this.ip2.reloadViewers();
    }

    void insertBeforeTarget(AgendaItem agendaItem) {
        Debug.expect(this.target.getStatus() != Status.EXECUTING && this.target.getStatus() != Status.COMPLETE);
        Debug.expect(this.target.getStatus() == Status.BLANK || this.target.getStatus() == Status.POSSIBLE);
        Agenda agenda = this.ip2.getController().getActivityAgenda();
        agenda.addItemsBefore(this.target, Lisp.list(agendaItem));
        this.ip2MM.linkBefore(agendaItem.getEnd(), this.target.getBegin());
        this.target.setStatus(Status.BLANK);
        AgendaItem agendaItem2 = this.target.getParent();
        if (agendaItem2 != null) {
            agendaItem2.addChild(agendaItem, this.target);
        }
    }

    void insertAfterTarget(AgendaItem agendaItem) {
        AgendaItem agendaItem2 = this.target;
        while (agendaItem2.getParent() != null && agendaItem2.getParent().getStatus() == Status.COMPLETE) {
            agendaItem2 = agendaItem2.getParent();
        }
        this.ip2MM.linkBefore(this.target.getEnd(), agendaItem.getBegin());
        Agenda agenda = this.ip2.getController().getActivityAgenda();
        AgendaItem agendaItem3 = (AgendaItem)this.itemAfter(agendaItem2, agenda.getItems());
        if (agendaItem3 != null) {
            agenda.addItemsBefore(agendaItem3, Lisp.list(agendaItem));
        } else {
            agenda.addItem(agendaItem);
        }
        AgendaItem agendaItem4 = agendaItem2.getParent();
        if (agendaItem4 != null) {
            AgendaItem agendaItem5 = (AgendaItem)this.itemAfter(agendaItem2, agendaItem4.getChildren());
            agendaItem4.addChild(agendaItem, agendaItem5);
            if (agendaItem4.getEnd().getStatus() == Status.POSSIBLE) {
                agendaItem4.getEnd().setStatus(Status.BLANK);
            }
        }
    }

    Object itemAfter(Object object, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != object) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return null;
    }

    class InsertionEditPanel
    extends ActivityEditor.ActivityEditPanel {
        InsertionEditPanel() {
        }

        void addItem() {
            Debug.expect(this.editingItem == null);
            AgendaItem agendaItem = this.getItem();
            if (agendaItem != null) {
                ActivityInsertionEditor.this.insertItem(agendaItem);
                this.showItem(agendaItem);
            }
        }
    }
}

