/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.event.AnnotationEvent;
import ix.iface.util.KeyValueTable;
import ix.ip2.AnnotationEditor;
import ix.ip2.AnnotationViewer;
import ix.ip2.Ip2;
import ix.ip2.PanelFrame;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class AnnotationViewTable
extends JPanel
implements AnnotationViewer {
    protected Ip2 ip2;
    protected ViewTable viewTable;
    protected AnnotationEditor annotationEditor;

    public AnnotationViewTable(Ip2 ip2) {
        this.ip2 = ip2;
        this.viewTable = new ViewTable();
        this.setLayout(new BorderLayout());
        JTable jTable = this.viewTable.getJTable();
        this.add((Component)jTable.getTableHeader(), "North");
        this.add((Component)jTable, "Center");
    }

    public Component getView(PanelFrame panelFrame) {
        return this.viewTable.getJTable();
    }

    public void reset() {
        this.viewTable.reset();
    }

    public void getNewItemFromUser() {
        this.editAnnotation("sample key", "sample value");
    }

    public void setAnnotation(AnnotationEvent annotationEvent) {
        Debug.noteln("Event", (Object)annotationEvent);
        if (annotationEvent.isDeletion()) {
            this.viewTable.deleteEntry(annotationEvent.getKey());
        } else {
            this.viewTable.recordNewValue(annotationEvent.getKey(), annotationEvent.getValue());
        }
    }

    protected void showDetails(Object object) {
        Object object2 = this.viewTable.getValue(object);
        this.editAnnotation(object, object2);
    }

    protected void editAnnotation(Object object, Object object2) {
        if (this.annotationEditor == null) {
            this.annotationEditor = new AnnotationEditor(this.ip2);
        }
        this.annotationEditor.editAnnotation(object, object2);
        this.annotationEditor.setVisible(true);
    }

    class ViewTable
    extends KeyValueTable {
        ViewTable() {
            super("Key", "Value");
        }

        protected KeyValueTable.RowPopupMenu makePopupMenu() {
            return new AnnotationPopupMenu();
        }

        protected void doPopupAction(ActionEvent actionEvent, int n, Object object) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Show Details")) {
                AnnotationViewTable.this.showDetails(object);
            } else if (string.equals("Delete")) {
                AnnotationViewTable.this.ip2.getModelManager().removeAnnotation(object);
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        class AnnotationPopupMenu
        extends KeyValueTable.RowPopupMenu {
            AnnotationPopupMenu() {
                this.add(this.makeMenuItem("Show Details"));
                this.add(this.makeMenuItem("Delete"));
            }
        }
    }
}

