/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.ConstraintManager;
import ix.icore.ConstraintManagerRegistry;
import ix.icore.domain.Constraint;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.Ip2ModelManager;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintAssociator
implements ConstraintManagerRegistry {
    protected Ip2ModelManager mm;
    protected Set<ConstraintManager> constraintManagers = new LinkedHashSet<ConstraintManager>();
    protected Map<Symbol, Map<Symbol, List<ConstraintManager>>> dispatchTable = new LinkedHashMap<Symbol, Map<Symbol, List<ConstraintManager>>>();

    public ConstraintAssociator(Ip2ModelManager ip2ModelManager) {
        this.mm = ip2ModelManager;
    }

    public void reset() {
        for (ConstraintManager constraintManager : this.constraintManagers) {
            constraintManager.reset();
        }
    }

    public void clear() {
        for (ConstraintManager constraintManager : this.constraintManagers) {
            constraintManager.clear();
        }
    }

    @Override
    public void addConstraintManager(ConstraintManager constraintManager, Symbol symbol, Symbol[] symbolArray) {
        Debug.noteln("Registering", (Object)constraintManager);
        this.constraintManagers.add(constraintManager);
        Map<Symbol, List<ConstraintManager>> map = this.dispatchTable.get(symbol);
        if (map == null) {
            map = new LinkedHashMap<Symbol, List<ConstraintManager>>();
            this.dispatchTable.put(symbol, map);
        }
        for (Symbol symbol2 : symbolArray) {
            List<ConstraintManager> list = map.get(symbol2);
            if (list == null) {
                list = new LinkedList<ConstraintManager>();
                map.put(symbol2, list);
            }
            list.add(constraintManager);
        }
    }

    public List<ConstraintManager> getConstraintManagers(Constraint constraint) {
        Symbol symbol = constraint.getType();
        Symbol symbol2 = constraint.getRelation();
        Map<Symbol, List<ConstraintManager>> map = this.dispatchTable.get(symbol);
        Debug.noteln("Lookup " + constraint, map);
        if (map == null) {
            return null;
        }
        return map.get(symbol2);
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        List<ConstraintManager> list = this.getConstraintManagers(constraint);
        if (list == null) {
            Debug.noteln("Can't add " + constraint + " at " + pNode);
            return;
        }
        for (ConstraintManager constraintManager : list) {
            constraintManager.addConstraint(pNode, constraint);
        }
    }

    public void evalAtBegin(PNodeEnd pNodeEnd, Constraint constraint) {
        List<ConstraintManager> list = this.getConstraintManagers(constraint);
        if (list == null) {
            Debug.noteln("Can't eval at begin " + constraint + " at " + pNodeEnd);
            return;
        }
        for (ConstraintManager constraintManager : list) {
            constraintManager.evalAtBegin(pNodeEnd, constraint);
        }
    }

    public void evalAtEnd(PNodeEnd pNodeEnd, Constraint constraint) {
        List<ConstraintManager> list = this.getConstraintManagers(constraint);
        if (list == null) {
            Debug.noteln("Can't eval at end " + constraint + " at " + pNodeEnd);
            return;
        }
        for (ConstraintManager constraintManager : list) {
            constraintManager.evalAtEnd(pNodeEnd, constraint);
        }
    }
}

