/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityHandler;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.SimpleUnreadyReason;
import ix.ip2.UnsatisfiedConditionsUnreadyReason;
import ix.ip2.event.AgendaItemAdapter;
import ix.ip2.event.AgendaItemEvent;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExpandHandler
extends ActivityHandler
implements DomainListener {
    protected Ip2 ip2;
    protected Agenda actAgenda;
    protected Ip2ModelManager modelManager;

    public ExpandHandler(Ip2 ip2) {
        super("Refine actions");
        this.ip2 = ip2;
        this.actAgenda = ip2.getController().getActivityAgenda();
        this.modelManager = ip2.getIp2ModelManager();
        ip2.getDomain().addDomainListener(this);
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        return !agendaItem.isExpanded();
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addItemListener(new ItemListener());
        for (Refinement refinement : this.ip2.getDomain().getRefinements()) {
            MatchEnv matchEnv = this.matchRefinement(agendaItem, refinement);
            if (matchEnv == null) continue;
            agendaItem.addAction(this.makeExpandAction(agendaItem, refinement, matchEnv));
        }
    }

    protected ExpandAction makeExpandAction(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        return new ExpandAction(agendaItem, refinement, matchEnv);
    }

    protected MatchEnv matchRefinement(AgendaItem agendaItem, Refinement refinement) {
        if (this.modelManager.getAdviceManager().isUsableRefinement(refinement)) {
            return Matcher.match(refinement.getPattern(), agendaItem.getPattern());
        }
        return null;
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        Refinement refinement = refinementEvent.getRefinement();
        Debug.noteln("Expand Handler noting new ", (Object)refinement);
        this.ip2.getController().reconsiderHandler(this, refinement);
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        Refinement refinement = (Refinement)object;
        MatchEnv matchEnv = this.matchRefinement(agendaItem, refinement);
        if (matchEnv == null) {
            return;
        }
        Debug.noteln("New expansion for", (Object)agendaItem);
        agendaItem.insertAction(new ExpandAction(agendaItem, refinement, matchEnv));
    }

    public HandlerAction makeManualExpandAction(AgendaItem agendaItem, Refinement refinement) {
        return new ManualExpandAction(agendaItem, refinement);
    }

    private class ManualExpandAction
    extends ExpandAction {
        ManualExpandAction(AgendaItem agendaItem, Refinement refinement) {
            super(agendaItem, refinement, new MatchEnv());
            this.shortDescription = "Expand as below";
        }

        public void handle(AgendaItem agendaItem) {
            this.do_expansion(agendaItem);
            if (agendaItem.getStatus() == Status.POSSIBLE) {
                agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
            }
        }
    }

    public class ExpandAction
    extends HandlerAction {
        AgendaItem item;
        Refinement refinement;
        MatchEnv env;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;

        ExpandAction(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
            this.item = agendaItem;
            this.refinement = refinement;
            this.env = matchEnv;
            this.filters = refinement.getFilterConstraints();
            this.shortDescription = "Refine using " + refinement.getName();
        }

        public boolean isStillValid() {
            if (this.item.isExpanded()) {
                return false;
            }
            this.env = ExpandHandler.this.matchRefinement(this.item, this.refinement);
            return this.env != null;
        }

        public boolean isReady() {
            return !this.item.isExpanded() && (this.filters.isEmpty() || !this.filterEnvs.isEmpty());
        }

        public void computeStatus() {
            if (!this.filters.isEmpty()) {
                this.filterEnvs = ExpandHandler.this.modelManager.evalFilters(this.filters, this.env);
            }
        }

        public ActionUnreadyReason getUnreadyReason() {
            if (this.item.isExpanded()) {
                return new SimpleUnreadyReason((HandlerAction)this, "Already expanded");
            }
            ListOfConstraint listOfConstraint = ExpandHandler.this.modelManager.testFilters(this.filters, this.env);
            return new UnsatisfiedConditionsUnreadyReason(this, this.filters, listOfConstraint, this.env);
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(this.isReady(), this + " asked to handle " + agendaItem + " when not ready");
            Debug.expect(!agendaItem.isExpanded(), "already expanded", agendaItem);
            Debug.expect(agendaItem == this.item);
            this.do_expansion(agendaItem);
            Debug.expect(agendaItem.getStatus() == Status.POSSIBLE);
            agendaItem.fireAgendaItemEdited();
            this.setSatusAfterExpansion(agendaItem);
        }

        protected void setSatusAfterExpansion(AgendaItem agendaItem) {
            agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
        }

        protected void do_expansion(AgendaItem agendaItem) {
            Object object;
            Object object2;
            Debug.noteln("Expanding using", (Object)this.refinement);
            MatchEnv matchEnv = this.getInstantiationEnv();
            Debug.noteln("Using env", (Object)matchEnv);
            Debug.noteln("Filters", (Object)this.filters);
            agendaItem.expandOneLevel(this.refinement, matchEnv);
            ExpandHandler.this.modelManager.applyEnv(matchEnv);
            if (!this.filters.isEmpty()) {
                this.reevaluateFilters(agendaItem);
            }
            Object object3 = Collect.iterator(agendaItem.getChildren());
            while (object3.hasNext()) {
                object2 = (AgendaItem)object3.next();
                ExpandHandler.this.actAgenda.addItem((AgendaItem)object2);
            }
            object3 = agendaItem.getRefinement().getIssues();
            object2 = Collect.iterator((Collection)object3);
            while (object2.hasNext()) {
                object = (Issue)object2.next();
                ExpandHandler.this.ip2.getController().addIssue((Issue)object);
            }
            object2 = agendaItem.getRefinement().getOrderings();
            ExpandHandler.this.modelManager.addOrderingsAsTimeConstraints(agendaItem, (ListOfOrdering)object2);
            object = agendaItem.getRefinement().getConstraints();
            if (object != null) {
                ExpandHandler.this.modelManager.addConstraints(agendaItem, (List)object);
            }
            ExpandHandler.this.modelManager.getTPNManager().describeTPN(Debug.out);
        }

        protected MatchEnv getInstantiationEnv() {
            if (!this.filters.isEmpty() && this.filterEnvs.size() == 1) {
                return (MatchEnv)this.filterEnvs.get(0);
            }
            return this.env;
        }

        protected void reevaluateFilters(AgendaItem agendaItem) {
            ListOfConstraint listOfConstraint = agendaItem.getRefinement().getFilterConstraints();
            List list = ExpandHandler.this.modelManager.reevaluateFilters(listOfConstraint);
            Debug.expect(!list.isEmpty(), "Cannot match filter conditions " + listOfConstraint);
        }
    }

    protected class ItemListener
    extends AgendaItemAdapter {
        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem.isExpanded()) {
                ExpandHandler.this.ip2.getController().checkActionValidity(ExpandHandler.this, agendaItemEvent);
            }
        }
    }
}

