/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Variable;
import ix.icore.process.event.ProcessStatusEvent;
import ix.iface.util.IFUtil;
import ix.iface.util.ToolFrame;
import ix.iface.util.VerticalPanel;
import ix.ip2.AgendaItem;
import ix.ip2.BindingViewer;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.event.AgendaEvent;
import ix.iplan.CombinedPlanChangeListener;
import ix.iplan.IPlanOptionManager;
import ix.iplan.event.AbstractOptionListener;
import ix.iplan.event.OptionEvent;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVarTool {
    Ip2 ip2;
    View view = null;

    public IVarTool(Ip2 ip2) {
        this.ip2 = ip2;
    }

    protected void setup() {
        this.view = new View();
        this.ip2.addResetHook(new ResetHook());
        this.ip2.getOptionManager().addOptionListener(new OptListener());
        this.view.noteCurrentOption(this.ip2.getOptionManager().getOption());
        new ComboListener().connectYourself(this.ip2);
    }

    public void setVisible(boolean bl) {
        if (this.view == null) {
            this.setup();
        }
        this.view.setVisible(bl);
    }

    Set<Variable> getAllVariables() {
        return new TreeSet<Variable>(Variable.getAllVariables());
    }

    Set<Variable> getAllUnboundVariables() {
        Set<Variable> set = this.getAllVariables();
        Iterator<Variable> iterator = set.iterator();
        while (iterator.hasNext()) {
            Variable variable = iterator.next();
            if (!variable.isBound()) continue;
            iterator.remove();
        }
        return set;
    }

    protected void bind(Map map) {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.ip2.getModelManager();
        try {
            ip2ModelManager.bindVariables(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.displayException(illegalArgumentException);
        }
        ip2ModelManager.logBindings(map);
    }

    class View
    extends BindingViewer {
        View() {
            super(IVarTool.this.ip2, IVarTool.this.getAllVariables());
        }

        protected void setUpFrame() {
            this.frame = new ToolFrame(this.ip2.getAgentDisplayName() + " Variable Tool");
            this.frame.setJMenuBar(this.makeMenuBar());
            this.contentPane = this.frame.getContentPane();
            this.varPanel = new BindingViewer.VarPanel(this.vars);
            VerticalPanel verticalPanel = new VerticalPanel();
            verticalPanel.addFixedHeight(this.varPanel);
            verticalPanel.add(new JPanel());
            JScrollPane jScrollPane = new JScrollPane(verticalPanel);
            this.contentPane.add((Component)jScrollPane, "Center");
            this.contentPane.add((Component)this.makeButtonPanel(), "South");
            this.frame.pack();
            this.frame.setSize(400, 200);
            this.frame.validate();
        }

        JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            jMenu.add(IFUtil.makeMenuItem("Close", this));
            jMenuBar.add(Box.createHorizontalStrut(300));
            return jMenuBar;
        }

        protected BindingViewer.ButtonPanel makeButtonPanel() {
            return new BindingViewer.ButtonPanel("Assign Values");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("I-Var Tool action:", (Object)string);
            if (string.equals("Assign Values")) {
                this.bindCommand();
            } else if (string.equals("Close")) {
                this.closeCommand();
            } else {
                throw new ConsistencyException("Nothing to do for", string);
            }
        }

        public void setVisible(Boolean bl) {
            this.frame.setVisible(bl);
        }

        void reset() {
            this.reloadView();
        }

        void noteCurrentOption(IPlanOptionManager.Opt opt) {
            this.reloadView();
            this.setBorderTitle(opt.getName() + " Variables");
        }

        void reloadView() {
            this.reloadView(IVarTool.this.getAllVariables());
        }

        public void handleBindings(Map map) {
            IVarTool.this.bind(map);
        }

        void setBorderTitle(String string) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            this.varPanel.setBorder(titledBorder);
        }
    }

    class ComboListener
    extends CombinedPlanChangeListener {
        ComboListener() {
        }

        protected void eventReceived(EventObject eventObject) {
        }

        public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
            IVarTool.this.view.resetPossibleValues();
        }

        public void itemAdded(AgendaEvent agendaEvent, AgendaItem agendaItem) {
            if (Collect.haveCommonElements(agendaItem.getPatternVars(), IVarTool.this.view.getVars())) {
                IVarTool.this.view.reloadView();
            }
        }

        public void itemRemoved(AgendaEvent agendaEvent, AgendaItem agendaItem) {
            IVarTool.this.view.reloadView();
        }
    }

    class OptListener
    extends AbstractOptionListener {
        OptListener() {
        }

        public void optionSet(OptionEvent optionEvent) {
            IVarTool.this.view.noteCurrentOption(optionEvent.getOption());
        }

        public void optionRenamed(OptionEvent optionEvent, String string) {
            if (optionEvent.getOption() == IVarTool.this.ip2.getOptionManager().getOption()) {
                IVarTool.this.view.noteCurrentOption(optionEvent.getOption());
            }
        }

        public void optionContentsChanged(OptionEvent optionEvent, EventObject eventObject) {
            if (optionEvent.getOption() == IVarTool.this.ip2.getOptionManager().getOption()) {
                IVarTool.this.view.noteCurrentOption(optionEvent.getOption());
            }
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", (Object)IVarTool.this);
            IVarTool.this.view.reset();
        }
    }
}

