/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.applet.AppletCommunicationStrategy;
import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.iface.util.IFUtil;
import ix.iface.util.ToolFrame;
import ix.iface.util.XColors;
import ix.ip2.Ip2;
import ix.ip2.Ip2Frame;
import ix.ip2.NewIp2Frame;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Proc;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class Ip2Applet
extends Applet {
    public static final String INITIAL_SYMBOL_NAME = " I-P2 Applet ";
    AppletIp2 ip2;

    public void init() {
        Debug.noteln("Applet init() called");
        Debug.noteThreads = true;
        Debug.noteln("Running in deamon thead", Thread.currentThread().isDaemon());
        IXAgent iXAgent = IXAgent.getAgent();
        if (iXAgent != null) {
            Debug.noteln("An I-X agent already exists");
            this.setBackground(XColors.LightSeaGreen);
            this.ip2 = (AppletIp2)iXAgent;
            this.ip2.restart(this);
            return;
        }
        Parameters.setApplet(this);
        Parameters.setParameter("ipc", "ix.applet.AppletCommunicationStrategy");
        Parameters.setParameter("symbol-name", INITIAL_SYMBOL_NAME);
        this.setBackground(Color.white);
        this.ip2 = new AppletIp2();
        this.ip2.mainStartup(new String[0]);
    }

    public void start() {
        Debug.noteln("Applet start() called");
        this.ip2.start();
    }

    public void stop() {
        Debug.noteln("Applet stop() called");
        this.ip2.stop();
    }

    public void destroy() {
        Debug.noteln("Applet destroy() called");
        this.ip2.destroy();
    }

    static class AppletIp2Frame
    extends NewIp2Frame {
        public AppletIp2Frame(Ip2 ip2) {
            super(ip2);
        }

        protected JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = super.makeMenuBar();
            JMenu jMenu = IFUtil.getMenuBarMenu(jMenuBar, "Help", true);
            jMenu.add((Component)this.makeMenuItem("Applet Help"), 1);
            return jMenuBar;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("I-P2 Applet action:", (Object)string);
            if (string.equals("Applet Help")) {
                this.ensureHelpFrame("ip2-applet-help.html");
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public class AppletIp2
    extends Ip2 {
        Plan savedPlan = null;
        Domain savedDomain = null;
        AppletCommunicationStrategy commStrategy = null;

        AppletIp2() {
        }

        public Applet getApplet() {
            return Ip2Applet.this;
        }

        protected Ip2Frame makeIp2Frame() {
            return new AppletIp2Frame(this);
        }

        protected void startServer(Object object, String string) {
            Debug.noteln("AppletIp2 startServer method called");
            super.startServer(object, string);
            this.commStrategy = (AppletCommunicationStrategy)IPC.getCommunicationStrategy();
        }

        public void exit() {
            this.disposeFrames();
            this.savedPlan = null;
            this.savedDomain = null;
            IXAgent.mainAgent = null;
        }

        public void start() {
            this.commStrategy.appletStart();
        }

        public void stop() {
            this.commStrategy.appletStop();
        }

        public void destroy() {
            this.commStrategy.appletDestroy();
            this.savedPlan = this.controller.getModelManager().getPlan();
            this.savedDomain = new Domain();
            this.savedDomain.takeFrom(this.domain);
            this.reset();
            this.disposeFrames();
        }

        void restart(Ip2Applet ip2Applet) {
            AppletIp2 appletIp2;
            IXAgent iXAgent = mainAgent;
            mainAgent = null;
            Debug.noteln("oldIp2 == this =>", iXAgent == this);
            ip2Applet.ip2 = appletIp2 = ip2Applet.new AppletIp2();
            Parameters.setParameter("symbol-name", iXAgent.getAgentSymbolName());
            if (this.savedDomain != null) {
                appletIp2.domain = this.savedDomain;
            }
            appletIp2.contactManager = iXAgent.getContactManager();
            appletIp2.mainStartup(new String[0]);
            if (this.savedPlan != null) {
                appletIp2.loadPlan(this.savedPlan);
            }
        }

        void disposeFrames() {
            this.frame.dispose();
            ToolFrame.walkToolFrames(new Proc(){

                public void call(Object object) {
                    ToolFrame toolFrame = (ToolFrame)object;
                    toolFrame.dispose();
                }
            });
        }
    }
}

