/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.ConstraintManager;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constrainer;
import ix.icore.domain.Constraint;
import ix.icore.domain.ContextListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.log.BindingEvent;
import ix.icore.plan.Plan;
import ix.icore.process.AbstractPMM;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.icore.process.TimePoint;
import ix.ip2.ActivityItem;
import ix.ip2.AdviceManager;
import ix.ip2.AgendaItem;
import ix.ip2.ComputeInterpreter;
import ix.ip2.ConstraintAssociator;
import ix.ip2.ConsumeTheOnlyCM;
import ix.ip2.Ip2;
import ix.ip2.Ip2WorldStateManager;
import ix.ip2.LispComputeInterpreter;
import ix.ip2.PlanInstaller;
import ix.ip2.PlanMaker;
import ix.ip2.Scrum;
import ix.ip2.UndoException;
import ix.ip2.UseCM;
import ix.ip2.VariableManager;
import ix.iplan.TimePointNet;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.ObjectWalker;
import ix.util.Parameters;
import ix.util.Proc;
import ix.util.Strings;
import ix.util.UndoAction;
import ix.util.Util;
import ix.util.context.Context;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMultiHashMap;
import ix.util.context.ContextMultiMap;
import ix.util.context.LLQueue;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.Bindings;
import ix.util.match.MatchChoice;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ip2ModelManager
extends AbstractPMM {
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    protected static final Symbol S_COMPUTE_SUPPORT_CODE = Symbol.intern("compute-support-code");
    protected Ip2 ip2;
    protected LLQueue<ActivityItem> nodes = new LLQueue();
    protected ContextHashMap varEnv = new ContextHashMap();
    protected LLQueue sentinels = new LLQueue();
    protected ConstraintAssociator constraintAssociator = new ConstraintAssociator(this);
    protected VariableManager variableManager = this.makeVariableManager();
    protected Ip2WorldStateManager worldStateCM = this.makeWorldStateManager();
    protected TimePointNet tpnm = this.makeTPNManager();
    protected AdviceManager adviceManager = this.makeAdviceManager();
    protected LLQueue otherConstraints = new LLQueue();
    protected ContextMultiMap nodeFilterConstraints = new ContextMultiHashMap(){

        public Collection makeValueCollection(Object object) {
            ContextListOfConstraint contextListOfConstraint = new ContextListOfConstraint();
            contextListOfConstraint.add(object);
            return contextListOfConstraint;
        }
    };
    protected ContextMultiMap nodeTimeConstraints = new ContextMultiHashMap();
    protected ContextMultiMap otherNodeConstraints = new ContextMultiHashMap();
    private long markCounter = 0L;
    protected Object computeSupportCode = null;
    public boolean computeStatus = true;

    public Ip2ModelManager(Ip2 ip2) {
        this.ip2 = ip2;
        Context context = Context.getContext();
        if (context != Context.rootContext && context.getParent() != Context.rootContext) {
            Context.printContextTree();
            Debug.noteln("Context holder:", (Object)Context.getContextHolder());
            throw new ConsistencyException("initial context " + context + " isn't root or root-child " + "but instead has ancestry " + context.getAncestors());
        }
        Context.pushContext();
        this.addConstraintManager(this.tpnm);
        this.addConstraintManager(new Scrum());
        this.addConstraintManager(new UseCM(this));
        this.addConstraintManager(new ConsumeTheOnlyCM());
    }

    @Override
    public void reset() {
        this.nodes.clearCompletely();
        this.varEnv.clearCompletely();
        this.sentinels.clearCompletely();
        this.variableManager.reset();
        this.worldStateCM.reset();
        this.tpnm.reset();
        this.adviceManager.reset();
        this.otherConstraints.clearCompletely();
        this.nodeFilterConstraints.clearCompletely();
        this.nodeTimeConstraints.clearCompletely();
        this.otherNodeConstraints.clearCompletely();
        this.clearAnnotationsCompletely();
        this.markCounter = 0L;
        Context.clearContexts();
        Context.pushContext();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.varEnv.clear();
        this.sentinels.clear();
        this.constraintAssociator.clear();
        this.variableManager.clear();
        this.worldStateCM.clear();
        this.tpnm.clear();
        this.otherConstraints.clear();
        this.nodeFilterConstraints.clear();
        this.nodeTimeConstraints.clear();
        this.otherNodeConstraints.clear();
        this.clearAnnotations();
    }

    public Ip2 getIp2() {
        return this.ip2;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    protected VariableManager makeVariableManager() {
        return new VariableManager(this);
    }

    protected Ip2WorldStateManager makeWorldStateManager() {
        return new Ip2WorldStateManager(this);
    }

    protected TimePointNet makeTPNManager() {
        return new TimePointNet();
    }

    public TimePointNet getTPNManager() {
        return this.tpnm;
    }

    protected AdviceManager makeAdviceManager() {
        return new AdviceManager(this);
    }

    public AdviceManager getAdviceManager() {
        return this.adviceManager;
    }

    protected ComputeInterpreter makeComputeInterpreter() {
        return new LispComputeInterpreter(this);
    }

    public ComputeInterpreter getComputeInterpreter() {
        return this.getVariableManager().getComputeInterpreter();
    }

    public void addConstraintManager(ConstraintManager constraintManager) {
        constraintManager.registerWith(this.constraintAssociator);
    }

    public List<ConstraintManager> getConstraintManagers(Constraint constraint) {
        return this.constraintAssociator.getConstraintManagers(constraint);
    }

    @Override
    public void addVariable(Variable variable) {
        Debug.expect(this.varEnv.get(variable.getName()) == null, "Variable already exists");
        this.varEnv.put(variable.getName(), variable);
    }

    @Override
    public Variable getVariable(Object object) {
        return (Variable)this.varEnv.get(object);
    }

    @Override
    public Map getVarEnv() {
        return this.varEnv;
    }

    @Override
    public void addNode(PNode pNode) {
        Debug.noteln("PMM adding node", (Object)pNode);
        pNode.setModelManager(this);
        this.nodes.add((ActivityItem)pNode);
        this.tpnm.addTimeConstraintElseFail(pNode.getBegin(), pNode.getEnd());
        this.loadAnyNewComputeSupportCode();
    }

    public void removeNode(PNode pNode) {
        if (pNode.isExpanded()) {
            throw new IllegalArgumentException("Attempt to delete a node that has been expanded " + pNode);
        }
        Debug.noteln("PMM removing node", (Object)pNode);
        pNode.unlink();
        this.nodes.remove(pNode);
    }

    public void addNodesBefore(PNode pNode, List list) {
        Object object2;
        Debug.noteln("PMM adding nodes", (Object)list);
        Debug.noteln("before", (Object)pNode);
        for (Object object2 : list) {
            ((PNode)object2).setModelManager(this);
        }
        LList lList = this.nodes.contents();
        object2 = (LList)Collect.insertBeforeFirst(pNode, lList, list);
        this.nodes.setContents((List)object2);
    }

    @Override
    public List<ActivityItem> getNodes() {
        return this.nodes.contents();
    }

    public long nextMark() {
        return ++this.markCounter;
    }

    public void walkNodes(Proc proc) {
        for (ActivityItem activityItem : this.getNodes()) {
            proc.call(activityItem);
        }
    }

    public void walkTopNodes(Proc proc) {
        for (ActivityItem activityItem : this.getNodes()) {
            if (activityItem.getParent() != null) continue;
            proc.call(activityItem);
        }
    }

    public void walkNodeChildren(ActivityItem activityItem, Proc proc) {
        for (ActivityItem activityItem2 : activityItem.getChildren()) {
            proc.call(activityItem2);
        }
    }

    public void walkNodeEnds(Proc proc) {
        for (ActivityItem activityItem : this.getNodes()) {
            proc.call(activityItem.getBegin());
            proc.call(activityItem.getEnd());
        }
    }

    public List<PNodeEnd> getNodeEnds() {
        LinkedList<PNodeEnd> linkedList = new LinkedList<PNodeEnd>();
        for (ActivityItem activityItem : this.getNodes()) {
            linkedList.add(activityItem.getBegin());
            linkedList.add(activityItem.getEnd());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindVariables(Map map) {
        this.beginUndoableTransaction("Bind variables");
        try {
            this.do_bindVariables(map);
        }
        finally {
            this.endUndoableTransaction("Bind variables");
        }
    }

    private void do_bindVariables(Map map) {
        this.variableManager.tryBindings(map);
        for (Map.Entry entry : map.entrySet()) {
            Variable variable = (Variable)entry.getKey();
            Object v = entry.getValue();
            if (variable.getValue() == v) {
                Debug.noteln("Already has desired value", (Object)variable);
                continue;
            }
            variable.setValue(v);
        }
        this.fireNewBindings(map);
        this.runSentinels();
        this.variableManager.newBindings(map);
    }

    protected void forcedBindings(MatchEnv matchEnv) {
        if (Parameters.isInteractive()) {
            Util.displayAndWait(null, Strings.foldLongLine("Discovered necessary bindings " + matchEnv));
        }
        this.bindVariables(matchEnv);
    }

    public void applyEnv(MatchEnv matchEnv) {
        Map map = matchEnv.getVariableBindings(Variable.class);
        if (map != null) {
            this.bindVariables(map);
        }
    }

    public void logBindings(Map map) {
        if (this.ip2.getOptionManager().canTakeInput()) {
            this.ip2.log(new BindingEvent((Map)Variable.revertAllVars(map)));
        }
    }

    @Override
    public void addConstraint(Constrainer constrainer) {
        this.addConstraint(null, constrainer);
    }

    public void addConstraint(Map map, Constrainer constrainer) {
        Symbol symbol = constrainer.getType();
        Symbol symbol2 = constrainer.getRelation();
        if (symbol == S_WORLD_STATE) {
            if (ObjectWalker.findIf(constrainer, Fn.isInstanceOf(ItemVar.class)) != null) {
                throw new IllegalArgumentException("Variables are not allowed in " + constrainer);
            }
            if (symbol2 == S_EFFECT) {
                Constraint constraint = (Constraint)constrainer;
                PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
                this.handleEffects(Lisp.list(patternAssignment));
                return;
            }
        }
        if (symbol == Ordering.S_TEMPORAL && symbol2 == Ordering.S_ORDERING) {
            Debug.expect(map != null, "no idToItemMap for", constrainer);
            PNodeEnd.addOrdering(map, (Ordering)constrainer);
            this.tpnm.addOrdering(map, (Ordering)constrainer);
            return;
        }
        if (symbol == MatchChoice.S_VARIABLE && symbol2 == MatchChoice.S_MATCH_CHOICE) {
            Constraint constraint = (Constraint)constrainer;
            this.variableManager.add(new MatchChoice(constraint));
            return;
        }
        Debug.noteln("Can't handle " + constrainer);
        if (!this.otherConstraints.contains(constrainer)) {
            this.otherConstraints.add(constrainer);
        }
    }

    @Override
    public void addConstraint(PNode pNode, Constraint constraint) {
        this.markUndoPoint("Add constraint");
        Symbol symbol = constraint.getType();
        if (symbol == S_WORLD_STATE) {
            this.worldStateCM.addConstraint(pNode, constraint);
            if (constraint.getRelation() != S_EFFECT) {
                this.nodeFilterConstraints.addValue(pNode, constraint);
            }
            return;
        }
        if (symbol == AdviceManager.S_ADVICE) {
            this.adviceManager.addConstraint(pNode, constraint);
            this.otherNodeConstraints.addValue(pNode, constraint);
            return;
        }
        if (symbol == Refinement.S_COMPUTE) {
            this.nodeFilterConstraints.addValue(pNode, constraint);
            return;
        }
        if (symbol == Ordering.S_TEMPORAL) {
            this.tpnm.addConstraint(pNode, constraint);
            this.nodeTimeConstraints.addValue(pNode, constraint);
            return;
        }
        this.constraintAssociator.addConstraint(pNode, constraint);
        this.otherNodeConstraints.addValue(pNode, constraint);
    }

    public void evalAtBegin(PNodeEnd pNodeEnd, List<Constraint> list) {
        for (Constraint constraint : list) {
            this.constraintAssociator.evalAtBegin(pNodeEnd, constraint);
        }
    }

    public void evalAtEnd(PNodeEnd pNodeEnd, List<Constraint> list) {
        for (Constraint constraint : list) {
            this.constraintAssociator.evalAtEnd(pNodeEnd, constraint);
        }
    }

    public void linkBefore(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        pNodeEnd.linkBefore(pNodeEnd2);
        this.tpnm.addTimeConstraintElseFail(pNodeEnd, pNodeEnd2);
    }

    public void linkAfter(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        this.linkBefore(pNodeEnd2, pNodeEnd);
    }

    public void addOrderingsAsTimeConstraints(PNode pNode, ListOfOrdering listOfOrdering) {
        Object object22;
        if (listOfOrdering != null) {
            for (Object object22 : listOfOrdering) {
                PNodeEnd pNodeEnd = pNode.refToTimePoint(((Ordering)object22).getFrom());
                PNodeEnd timePoint = pNode.refToTimePoint(((Ordering)object22).getTo());
                this.tpnm.addTimeConstraintElseFail(pNodeEnd, timePoint);
            }
        }
        PNodeEnd pNodeEnd = pNode.getBegin();
        object22 = pNode.getEnd();
        for (PNode pNode2 : pNode.getChildren()) {
            PNodeEnd pNodeEnd2 = pNode2.getBegin();
            PNodeEnd pNodeEnd3 = pNode2.getEnd();
            if (pNodeEnd2.getPreConstraints().isEmpty()) {
                this.tpnm.addTimeConstraintElseFail(pNodeEnd, pNodeEnd2);
            }
            if (!pNodeEnd3.getPostConstraints().isEmpty()) continue;
            this.tpnm.addTimeConstraintElseFail(pNodeEnd3, (TimePoint)object22);
        }
    }

    @Override
    public void deleteConstraint(Constraint constraint) {
        Debug.noteln("Asked to delete", (Object)constraint);
        Symbol symbol = constraint.getType();
        Symbol symbol2 = constraint.getRelation();
        if (symbol == S_WORLD_STATE && symbol2 == S_EFFECT) {
            PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
            this.deleteEffect(patternAssignment);
            return;
        }
        if (this.otherConstraints.contains(constraint)) {
            this.otherConstraints.remove(constraint);
            return;
        }
        throw new IllegalArgumentException("No matching constraint to delete: " + constraint);
    }

    @Override
    public ListOfConstraint getNodeConditions(PNode pNode) {
        return this.getNodeFilters(pNode);
    }

    public ListOfConstraint getNodeFilters(PNode pNode) {
        ListOfConstraint listOfConstraint = (ListOfConstraint)this.nodeFilterConstraints.get(pNode);
        if (listOfConstraint == null) {
            listOfConstraint = new ContextListOfConstraint();
        }
        return listOfConstraint;
    }

    public List getNodeEffects(PNode pNode) {
        return this.worldStateCM.getNodeEffects(pNode);
    }

    public List<Constraint> getNodeTimeConstraints(PNode pNode) {
        return (List)this.nodeTimeConstraints.get(pNode);
    }

    public List<Constraint> getOtherNodeConstraints(PNode pNode) {
        return (List)this.otherNodeConstraints.get(pNode);
    }

    public List getOtherConstraints() {
        return this.otherConstraints;
    }

    public Map getWorldStateMap() {
        return this.worldStateCM.getWorldStateMap();
    }

    public void setWorldStateMap(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object getWorldStateValue(LList lList) {
        return this.worldStateCM.getPatternValue(lList);
    }

    public void loadAnyNewComputeSupportCode() {
        Object object = this.getAnyNewComputeSupportCode();
        if (object != null) {
            this.variableManager.computeInterpreter.loadSupportCode(object);
        }
    }

    protected Object getAnyNewComputeSupportCode() {
        Object object = this.ip2.domain.getAnnotation(S_COMPUTE_SUPPORT_CODE);
        if (object != this.computeSupportCode) {
            this.computeSupportCode = object;
            return this.computeSupportCode;
        }
        return null;
    }

    @Override
    public void setAnnotation(Object object, Object object2) {
        this.markUndoPoint("Set annotation");
        super.setAnnotation(object, object2);
    }

    public boolean undoIsEnabled() {
        return this.ip2.getOptionManager() != null;
    }

    public void undo() {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().undo();
        }
    }

    public void undo(String string) {
        if (this.undoIsEnabled()) {
            List<UndoAction> list = this.getUndoTrail();
            if (!list.isEmpty() && list.get(0).getNote().equals(string)) {
                this.undo();
            } else {
                this.ip2.getOptionManager().printUndoTrail();
                throw new UndoException("Didn't find expected undo record for " + string);
            }
        }
    }

    public List<UndoAction> getUndoTrail() {
        return this.undoIsEnabled() ? this.ip2.getOptionManager().getUndoTrail() : null;
    }

    public void markUndoPoint(String string) {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().markUndoPoint(string);
        }
    }

    public void saveUndoAction(UndoAction undoAction) {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().saveUndoAction(undoAction);
        }
    }

    public void undoableTransaction(String string, Runnable runnable) {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().undoableTransaction(string, runnable);
        } else {
            runnable.run();
        }
    }

    public void beginUndoableTransaction(String string) {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().beginUndoableTransaction(string);
        }
    }

    public void endUndoableTransaction(String string) {
        if (this.undoIsEnabled()) {
            this.ip2.getOptionManager().endUndoableTransaction(string);
        }
    }

    @Override
    public List evalFilters(ListOfConstraint listOfConstraint, MatchEnv matchEnv) {
        Map map = this.worldStateCM.getWorldStateMap();
        return this.variableManager.evalFilters(listOfConstraint, map, matchEnv);
    }

    @Override
    public ListOfConstraint testFilters(ListOfConstraint listOfConstraint, MatchEnv matchEnv) {
        Map map = this.worldStateCM.getWorldStateMap();
        return this.variableManager.testFilters(listOfConstraint, map, matchEnv);
    }

    public List reevaluateFilters(ListOfConstraint listOfConstraint) {
        Debug.noteln("");
        Debug.noteln("Re-evaluating filters", (Object)listOfConstraint);
        Map map = this.worldStateCM.getWorldStateMap();
        MatchEnv matchEnv = new MatchEnv();
        List list = this.variableManager.evalFilters(listOfConstraint, map, matchEnv);
        MatchChoice matchChoice = this.addMatchChoice(list);
        Debug.noteln("");
        return matchChoice.getLiveBranches();
    }

    public MatchChoice addMatchChoice(List list) {
        List list2 = Bindings.mapsToBindings(list);
        MatchChoice matchChoice = new MatchChoice(list2);
        this.variableManager.add(matchChoice);
        this.variableManager.recalculate();
        this.variableManager.showState();
        return matchChoice;
    }

    @Override
    public void statusChanged(PNode pNode) {
        Debug.noteln("PMM sees new status of", (Object)pNode);
        if (pNode.getStatus() == Status.COMPLETE) {
            this.handleCompletion(pNode);
        }
    }

    protected void handleCompletion(PNode pNode) {
        List list = this.getNodeEffects(pNode);
        if (list == null) {
            return;
        }
        Set set = Variable.varsAnywhereIn(list);
        Set set2 = Variable.unboundVarsIn(set);
        if (!set2.isEmpty()) {
            Debug.noteln("Unbound vars on completion of", (Object)pNode);
            Debug.noteln("Vars are ", (Object)set2);
            if (Parameters.isInteractive()) {
                JOptionPane.showMessageDialog(null, new Object[]{"Unbound vars on completion of " + pNode, "Vars are: " + set2}, "Warning", 2);
            }
            pNode.setStatus(Status.IMPOSSIBLE);
            this.addSentinel(new BindingSentinel(pNode, set2));
        } else {
            this.handleEffects(pNode, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEffects(PNode pNode, List list) {
        if (list.isEmpty()) {
            return;
        }
        this.beginUndoableTransaction("Effects at " + pNode);
        try {
            Map map = this.worldStateCM.handleEffects(pNode, list);
            this.fireStateChange(map);
            this.runSentinels();
        }
        finally {
            this.endUndoableTransaction("Effects at " + pNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEffects(List list) {
        if (list.isEmpty()) {
            return;
        }
        this.beginUndoableTransaction("Handle effects");
        try {
            Map map = this.worldStateCM.handleEffects(list);
            this.fireStateChange(map);
            this.runSentinels();
        }
        finally {
            this.endUndoableTransaction("Handle effects");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEffect(PatternAssignment patternAssignment) {
        this.beginUndoableTransaction("Delete effect");
        try {
            this.worldStateCM.deleteEffect(patternAssignment);
        }
        finally {
            this.endUndoableTransaction("Delete effect");
        }
        HashMap<LList, Object> hashMap = new HashMap<LList, Object>();
        hashMap.put(patternAssignment.getPattern(), patternAssignment.getValue());
        this.fireStateDeletion(hashMap);
    }

    public List satisfyRefinementPreconditions(Activity activity, Refinement refinement) {
        LList lList = activity.getPattern();
        lList = this.putVariablesInPattern(lList);
        MatchEnv matchEnv = Matcher.match(refinement.getPattern(), lList);
        if (matchEnv == null) {
            return null;
        }
        ListOfConstraint listOfConstraint = refinement.getFilterConstraints();
        if (listOfConstraint.isEmpty()) {
            return Collections.singletonList(matchEnv);
        }
        List list = this.evalFilters(listOfConstraint, matchEnv);
        Debug.noteln("satisfyPreconditions(" + activity + ", " + refinement + ") ==> " + list);
        return list;
    }

    public Refinement fillInRefinement(Refinement refinement, MatchEnv matchEnv) {
        return refinement.instantiate(matchEnv);
    }

    public void executeRefinementEffects(Refinement refinement, MatchEnv matchEnv) {
        ListOfConstraint listOfConstraint;
        Map map = matchEnv.getVariableBindings(Variable.class);
        if (map != null) {
            this.bindVariables(map);
        }
        if (!(listOfConstraint = refinement.getEffectConstraints()).isEmpty()) {
            this.addConstraints(listOfConstraint);
        }
    }

    @Override
    public Plan getPlan() {
        return new PlanMaker(this.ip2).getPlan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlan(Plan plan) {
        this.beginUndoableTransaction("Load plan");
        try {
            PlanInstaller planInstaller = new PlanInstaller(this.ip2, plan);
            planInstaller.installPlan();
            this.postProcessInstalledPlan(planInstaller);
        }
        finally {
            this.endUndoableTransaction("Load plan");
        }
    }

    protected void postProcessInstalledPlan(PlanInstaller planInstaller) {
        planInstaller.walkInstalledPlan(new PlanInstaller.PlanWalker(){

            public void visitAgendaItem(AgendaItem agendaItem) {
                if (!(agendaItem instanceof ActivityItem)) {
                    return;
                }
                if (agendaItem.getStatus() == Status.POSSIBLE && !Collect.isEmpty(agendaItem.getChildren()) && Collect.isEmpty(Ip2ModelManager.this.getNodeConditions(agendaItem))) {
                    agendaItem.setStatus(Status.EXECUTING);
                }
            }
        });
    }

    @Override
    public void addSentinel(AbstractPMM.Sentinel sentinel) {
        this.sentinels.add(sentinel);
    }

    @Override
    public void removeSentinel(AbstractPMM.Sentinel sentinel) {
        this.sentinels.remove(sentinel);
    }

    @Override
    protected List getSentinels() {
        return this.sentinels;
    }

    protected class BindingSentinel
    implements AbstractPMM.Sentinel {
        PNode node;
        Set unbound;

        BindingSentinel(PNode pNode, Set set) {
            this.node = pNode;
            this.unbound = new HashSet(set);
        }

        public boolean isReady() {
            Debug.noteln("Testing BindingSentinel for", (Object)this.node);
            Set set = Variable.unboundVarsIn(this.unbound);
            return set.isEmpty();
        }

        public void run() {
            Debug.noteln("Able to complete", (Object)this.node);
            Debug.noteln("Because all variables bound.");
            this.node.setStatus(Status.COMPLETE);
        }
    }
}

