/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ip2.AgendaViewer;
import ix.ip2.ItemEditor;
import ix.util.Debug;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

class IssueEditor
extends ItemEditor {
    IssueEditor(AgendaViewer agendaViewer, String string) {
        super(agendaViewer, string);
        this.itemType = "Issue";
    }

    protected ItemEditor.EditPanel makeEditPanel() {
        return new IssueEditPanel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("IssueEditor action:", (Object)string);
        if (!this.handleViewCommand(actionEvent)) {
            if (string.equals("Close")) {
                this.frame.setVisible(false);
            } else {
                Debug.noteln("Nothing to do for", (Object)string);
            }
        }
    }

    class IssueEditPanel
    extends ItemEditor.EditPanel {
        IssueEditPanel() {
            super(IssueEditor.this);
            this.modifyButton = this.makeButton("Modify Issue");
            this.setUp();
        }

        protected void setUp() {
            this.setBorder(BorderFactory.createTitledBorder("Issue"));
            this.addFixedHeight(this.makeLeftLabel("Issue Pattern Text"));
            this.add(new JScrollPane(this.itemText));
            this.addFixedHeight(this.makeLeftLabel("Annotations"));
            this.add(new JScrollPane(this.commentText));
            this.newItemButtons.add(this.makeButton("Add Issue"));
            this.newItemButtons.add(this.makeButton("Clear"));
            this.newItemButtons.add(this.makeButton("Cancel"));
            this.editItemButtons.add(this.modifyButton);
            this.editItemButtons.add(this.makeButton("Copy Issue"));
            this.editItemButtons.add(this.makeButton("Clear"));
            this.editItemButtons.add(this.makeButton("Cancel"));
            this.addFixedHeight(this.newItemButtons);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Issue action:", (Object)string);
            if (string.equals("Add Issue")) {
                this.addItem();
            } else if (string.equals("Modify Issue")) {
                this.modifyItem();
            } else if (string.equals("Copy Issue")) {
                this.copyItem();
            } else if (string.equals("Clear")) {
                this.showNewItem();
            } else if (string.equals("Cancel")) {
                IssueEditor.this.frame.setVisible(false);
                this.showNewItem();
            } else {
                throw new UnsupportedOperationException("Nothing to do for " + string);
            }
        }
    }
}

