/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.DashSyntaxClassFinder;
import java.lang.reflect.Constructor;
import java.util.List;

public abstract class ItemHandler {
    protected String actionDescription;
    private static ClassFinder handlerClassFinder = new DashSyntaxClassFinder(){

        protected void addInitialImports() {
            this.addImport("ix.ip2.*");
            this.addImport("ix.test.*");
        }
    };

    public ItemHandler(String string) {
        this.actionDescription = string;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public List getSyntaxList() {
        return null;
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        return true;
    }

    public boolean isAutomatic() {
        return false;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new HandlerAction.Automatic(this));
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        throw new UnsupportedOperationException(this + "cannot revise handler actions");
    }

    public void handle(AgendaItem agendaItem) {
        Debug.noteln(this + " handling " + agendaItem);
    }

    public String toString() {
        return "ItemHandler[" + this.getActionDescription() + "]";
    }

    public static ItemHandler makeHandler(Ip2 ip2, String string) {
        Class clazz = handlerClassFinder.classForName(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot find a handler class named " + Strings.quote(string));
        }
        if (!ItemHandler.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + string + " is not a handler class.");
        }
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (ItemHandler)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            try {
                Constructor constructor = clazz.getConstructor(Ip2.class);
                return (ItemHandler)constructor.newInstance(ip2);
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Cannot make an instance of handler class " + string + " because trying to use the () constructor" + " threw " + Debug.describeException(exception) + " and trying to use the (Ip2) constructor" + " threw " + Debug.describeException(exception2));
            }
        }
    }
}

