/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Domain;
import ix.iface.util.ToolController;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.UnboundVariablesUnreadyReason;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.List;
import javax.swing.JOptionPane;

public class LoadDomainHandler
extends ActivityHandler {
    public static final Symbol S_NEW_DOMAIN = Symbol.intern("new-domain");
    public static final Symbol S_INCLUDE_DOMAIN = Symbol.intern("include-domain");
    public static final Symbol S_LOAD_DOMAIN = Symbol.intern("load-domain");
    protected Ip2 ip2;

    public LoadDomainHandler(Ip2 ip2) {
        super("Load or include a domain");
        this.ip2 = ip2;
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((new-domain ?domain) (include-domain ?domain) (load-domain ?domain))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        Object object = this.getVerb(lList);
        return lList.length() == 2 && (object == S_NEW_DOMAIN || object == S_INCLUDE_DOMAIN || object == S_LOAD_DOMAIN);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        Object object = this.getVerb(agendaItem.getPattern());
        if (object == S_NEW_DOMAIN) {
            agendaItem.addAction(new NewDomainAction(agendaItem));
        } else if (object == S_INCLUDE_DOMAIN) {
            agendaItem.addAction(new IncludeDomainAction(agendaItem));
        } else if (object == S_LOAD_DOMAIN) {
            agendaItem.addAction(new IncludeDomainAction(agendaItem));
            agendaItem.addAction(new NewDomainAction(agendaItem));
        } else {
            throw new ConsistencyException("Invalid verb");
        }
    }

    protected Object getVerb(LList lList) {
        return lList.length() > 0 ? lList.get(0) : null;
    }

    public void handle(AgendaItem agendaItem) {
        throw new ConsistencyException(this + " called directly");
    }

    class IncludeDomainAction
    extends AbstractLoadDomainAction {
        IncludeDomainAction(AgendaItem agendaItem) {
            super(agendaItem);
            this.shortDescription = "Include domain";
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            if (!this.existsDomainEditor() || this.askIfSafe()) {
                Domain domain = this.getDomain(agendaItem.getPattern());
                LoadDomainHandler.this.ip2.getDomain().takeFrom(domain);
                agendaItem.setStatus(Status.COMPLETE);
            }
        }
    }

    class NewDomainAction
    extends AbstractLoadDomainAction {
        NewDomainAction(AgendaItem agendaItem) {
            super(agendaItem);
            this.shortDescription = "New domain";
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            if (!this.existsDomainEditor() || this.askIfSafe()) {
                Domain domain = this.getDomain(agendaItem.getPattern());
                LoadDomainHandler.this.ip2.getDomain().clear();
                LoadDomainHandler.this.ip2.getDomain().takeFrom(domain);
                agendaItem.setStatus(Status.COMPLETE);
            }
        }
    }

    abstract class AbstractLoadDomainAction
    extends HandlerAction {
        AgendaItem item;

        AbstractLoadDomainAction(AgendaItem agendaItem) {
            this.item = agendaItem;
        }

        public boolean isReady() {
            return Variable.isFullyBound(this.item.getPattern());
        }

        public ActionUnreadyReason getUnreadyReason() {
            return new UnboundVariablesUnreadyReason((HandlerAction)this, this.item);
        }

        Domain getDomain(LList lList) {
            LList lList2 = (LList)Variable.removeVars(lList);
            Object object = lList.get(1);
            if (object instanceof Domain) {
                return (Domain)object;
            }
            if (object instanceof Symbol || object instanceof String) {
                return this.readDomain(object.toString());
            }
            throw new IllegalArgumentException(object + " is not a valid reference to a domain");
        }

        Domain readDomain(String string) {
            Domain domain = new Domain();
            LoadDomainHandler.this.ip2.readDomain(domain, string);
            return domain;
        }

        boolean existsDomainEditor() {
            ToolController toolController = LoadDomainHandler.this.ip2.frame.toolManager.findTool("Domain Editor");
            return toolController != null && toolController.getTool() != null;
        }

        boolean askIfSafe() {
            switch (JOptionPane.showConfirmDialog(LoadDomainHandler.this.ip2.frame, "Have you saved any changes made in the domain editor?", "Confirm", 0)) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw new ConsistencyException("Not yes or no");
        }
    }
}

