/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ip2.ObjectView;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMap;
import ix.util.context.LLQueue;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.Map;

public class ObjectWorld {
    public static final Symbol S_TRUE = Symbol.intern("true");
    protected ContextMap objectTable = new ContextHashMap(100);

    public ObjectWorld() {
    }

    public ObjectWorld(Map map) {
        this.addState(map);
    }

    public Object getPropValue(Symbol symbol, Object object) {
        Object object2 = this._getPropValue(symbol, object);
        return object2 instanceof LLQueue ? ((LLQueue)object2).contents() : object2;
    }

    protected Object _getPropValue(Symbol symbol, Object object) {
        Object v;
        Map map = (Map)this.objectTable.get(object);
        if (map != null && (v = map.get(symbol)) != null) {
            return v;
        }
        return ObjectView.NO_VALUE;
    }

    public void setPropValue(Symbol symbol, Object object, Object object2) {
        ContextHashMap<Symbol, Object> contextHashMap = (ContextHashMap<Symbol, Object>)this.objectTable.get(object);
        if (contextHashMap == null) {
            contextHashMap = new ContextHashMap<Symbol, Object>(5);
            this.objectTable.put(object, contextHashMap);
        }
        contextHashMap.put(symbol, object2);
    }

    public void addPropValueIfNew(Symbol symbol, Object object, Object object2) {
        LLQueue<Object> lLQueue = (LLQueue<Object>)this._getPropValue(symbol, object);
        if (lLQueue == null || lLQueue == ObjectView.NO_VALUE) {
            lLQueue = new LLQueue<Object>();
            lLQueue.add(object2);
            this.setPropValue(symbol, object, lLQueue);
        } else if (!lLQueue.contains(object2)) {
            lLQueue.add(object2);
        }
    }

    public void removePropValueElement(Symbol symbol, Object object, Object object2) {
        LLQueue lLQueue = (LLQueue)this._getPropValue(symbol, object);
        if (lLQueue == null) {
            throw new ConsistencyException("Property value (" + symbol + " " + object + ") " + "does not exist");
        }
        Debug.expect(lLQueue.remove(object2), "No value " + object2 + " to remove from " + " the value of property (" + symbol + " " + object + ")");
    }

    public void addState(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            if (this.isPropertyPattern(lList)) {
                this.setPropValue((Symbol)lList.get(0), lList.get(1), v);
                continue;
            }
            if (v != S_TRUE || !this.isDistributedSetPattern(lList)) continue;
            this.addPropValueIfNew((Symbol)lList.get(0), lList.get(1), lList.get(2));
        }
    }

    public void deleteState(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            if (this.isPropertyPattern(lList)) {
                this.setPropValue((Symbol)lList.get(0), lList.get(1), ObjectView.NO_VALUE);
                continue;
            }
            if (v != S_TRUE || !this.isDistributedSetPattern(lList)) continue;
            this.removePropValueElement((Symbol)lList.get(0), lList.get(1), lList.get(2));
        }
    }

    public boolean isPropertyPattern(LList lList) {
        return lList.car() instanceof Symbol && lList.cdr() != Lisp.NIL && lList.cdr().cdr() == Lisp.NIL;
    }

    public boolean isDistributedSetPattern(LList lList) {
        return lList.car() instanceof Symbol && lList.length() == 3;
    }
}

