/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ichat.ChatFrame;
import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.event.AgentNameEvent;
import ix.icore.event.AgentNameListener;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.ChainingMenu;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.iface.util.ToolManager;
import ix.ip2.test.TestElement;
import ix.itest.SendPanel;
import ix.iview.InternalDomainEditor;
import ix.iview.SimpleDomainEditor;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.XML;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class PanelFrame
extends JFrame
implements ActionListener,
AgentNameListener {
    protected IXAgent agent;
    protected ToolManager toolManager = new ToolManager();
    protected JMenu testMenu = new ChainingMenu("Test", true);

    public PanelFrame(IXAgent iXAgent) {
        super(iXAgent.getAgentDisplayName());
        this.agent = iXAgent;
        iXAgent.addAgentNameListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.noteln("Main frame windowClosing event");
                if (Util.dialogConfirms(PanelFrame.this, "Are you sure you want to exit?")) {
                    PanelFrame.this.agent.exit();
                }
            }
        });
    }

    public IXAgent getAgent() {
        return this.agent;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void symbolNameChanged(AgentNameEvent agentNameEvent) {
        this.setTitle(this.agent.getAgentDisplayName());
    }

    public InternalDomainEditor makeDomainEditor(IXAgent iXAgent, Domain domain) {
        String string = Parameters.getParameter("domain-editor-class", "ix.iview.DomainEditor");
        try {
            Debug.noteln("Trying domain editor class", (Object)string);
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{IXAgent.class, Domain.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            InternalDomainEditor internalDomainEditor = (InternalDomainEditor)constructor.newInstance(iXAgent, domain);
            if (internalDomainEditor instanceof JFrame) {
                ((JFrame)((Object)internalDomainEditor)).setIconImage(IconImage.getIconImage("ip2-edit-icon.gif"));
            }
            return internalDomainEditor;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Debug.noteln("Creating a SimpleDomainEditor instead.");
            return new SimpleDomainEditor(iXAgent, domain);
        }
    }

    public InternalDomainEditor getDomainEditor() {
        return (InternalDomainEditor)this.toolManager.findToolElseError("Domain Editor").ensureToolVisible();
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void addTool(ToolController toolController) {
        this.toolManager.addTool(toolController);
    }

    public SendPanel getSendPanelVisible() {
        return this.getChatFrameVisible().getSendPanel();
    }

    public SendPanel ensureSendPanelExists() {
        return this.ensureChatFrameExists().getSendPanel();
    }

    public ChatFrame getChatFrameVisible() {
        return (ChatFrame)this.toolManager.findToolElseError("Messenger").ensureToolVisible();
    }

    public ChatFrame ensureChatFrameExists() {
        return (ChatFrame)this.toolManager.findToolElseError("Messenger").ensureTool();
    }

    public void addTest(String string, ActionListener actionListener) {
        Debug.noteln("Adding test", (Object)string);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(actionListener));
        this.testMenu.setEnabled(true);
        this.testMenu.add(jMenuItem);
    }

    public void addTestSeparator() {
        this.testMenu.addSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestSubmenu(String string, List list) {
        ChainingMenu chainingMenu = new ChainingMenu(string);
        this.testMenu.add(chainingMenu);
        this.testMenu.setEnabled(true);
        JMenu jMenu = this.testMenu;
        try {
            this.testMenu = chainingMenu;
            this.addTests(list);
        }
        finally {
            this.testMenu = jMenu;
        }
    }

    public void addTestResources(List list) {
        for (String string : list) {
            try {
                this.addTests(string);
            }
            catch (Throwable throwable) {
                Debug.displayException("Problem loading test-menu " + Strings.quote(string), throwable);
            }
        }
    }

    public void addTests(String string) throws IOException {
        Debug.noteln("Loading tests from", (Object)string);
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find test menu " + Strings.quote(string));
        }
        List list = XML.readObject(List.class, uRL);
        this.addTests(list);
    }

    public void addTests(List list) {
        if (list != null) {
            for (TestElement testElement : list) {
                testElement.addToMenu(this);
            }
        }
    }
}

