/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.AbstractIXObject;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.Constrainer;
import ix.icore.domain.Constraint;
import ix.icore.domain.ListOfOrdering;
import ix.icore.plan.AbstractPlanItem;
import ix.icore.plan.ListOfPlanIssue;
import ix.icore.plan.ListOfPlanNode;
import ix.icore.plan.ListOfPlanVariableDeclaration;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanIssue;
import ix.icore.plan.PlanIssueRefinement;
import ix.icore.plan.PlanNode;
import ix.icore.plan.PlanRefinement;
import ix.icore.plan.PlanVariable;
import ix.icore.plan.PlanVariableDeclaration;
import ix.icore.plan.VariableScope;
import ix.icore.plan.inspect.PlanInspector;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueItem;
import ix.ip2.PanelController;
import ix.ip2.VariableManager;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.ObjectCopier;
import ix.util.lisp.ItemVar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanInstaller {
    PanelController controller;
    Ip2ModelManager modelManager;
    VariableManager variableManager;
    Plan plan;
    Map idToVarMap = new HashMap();
    Map idToItemMap = new HashMap();

    public PlanInstaller(Ip2 ip2, Plan plan) {
        this.plan = plan;
        this.controller = ip2.getController();
        this.modelManager = (Ip2ModelManager)ip2.getModelManager();
        this.variableManager = this.modelManager.variableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPlan() {
        this.checkPlanCompatibility();
        boolean bl = this.modelManager.computeStatus;
        this.modelManager.computeStatus = false;
        try {
            this.do_installPlan();
        }
        finally {
            this.modelManager.computeStatus = bl;
        }
        this.walkInstalledPlan(new PlanWalker(){

            public void visitAgendaItem(AgendaItem agendaItem) {
                agendaItem.computeStatus();
                PlanInstaller.this.walkInstalledChildren(agendaItem, this);
            }
        });
        this.variableManager.recalculate();
        this.variableManager.showState();
        this.walkInstalledPlan(new PlanWalker(){

            public void visitAgendaItem(AgendaItem agendaItem) {
                agendaItem.clearActions();
                PlanInstaller.this.getAgendaFor(agendaItem).addHandlerActions(agendaItem);
                PlanInstaller.this.walkInstalledChildren(agendaItem, this);
            }
        });
    }

    public void walkInstalledPlan(PlanWalker planWalker) {
        AgendaItem agendaItem;
        TaskItem taskItem;
        AbstractPlanItem abstractPlanItem;
        Iterator iterator = Collect.iterator(this.plan.getPlanNodes());
        while (iterator.hasNext()) {
            abstractPlanItem = (PlanNode)iterator.next();
            taskItem = ((PlanNode)abstractPlanItem).getActivity();
            agendaItem = this.findItemForActivity((Activity)taskItem);
            planWalker.visitAgendaItem(agendaItem);
        }
        iterator = Collect.iterator(this.plan.getPlanIssues());
        while (iterator.hasNext()) {
            abstractPlanItem = (PlanIssue)iterator.next();
            taskItem = ((PlanIssue)abstractPlanItem).getIssue();
            agendaItem = this.findItemForIssue((Issue)taskItem);
            planWalker.visitAgendaItem(agendaItem);
        }
    }

    public void walkInstalledChildren(AgendaItem agendaItem, PlanWalker planWalker) {
        for (AgendaItem agendaItem2 : agendaItem.getChildren()) {
            planWalker.visitAgendaItem(agendaItem2);
        }
    }

    Agenda getAgendaFor(AgendaItem agendaItem) {
        if (agendaItem instanceof ActivityItem) {
            return this.controller.getActivityAgenda();
        }
        if (agendaItem instanceof IssueItem) {
            return this.controller.getIssueAgenda();
        }
        throw new ConsistencyException("No agenda for", agendaItem);
    }

    void checkPlanCompatibility() {
        PlanInspector planInspector = new PlanInspector(this.plan);
        List list = this.controller.getIssueAgenda().getItems();
        List list2 = this.controller.getActivityAgenda().getItems();
        if (Collect.haveCommonElements(planInspector.getIssueIdSet(), this.idSet(list)) || Collect.haveCommonElements(planInspector.getActivityIdSet(), this.idSet(list2))) {
            throw new UnsupportedOperationException("The plan contains issues or activities which are already present in this I-P2.");
        }
    }

    Set idSet(List list) {
        HashSet<Name> hashSet = new HashSet<Name>();
        Iterator iterator = Collect.iterator(list);
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            TaskItem taskItem = agendaItem.getAbout();
            if (taskItem.getId() == null) continue;
            hashSet.add(taskItem.getId());
        }
        return hashSet;
    }

    void do_installPlan() {
        AbstractIXObject abstractIXObject;
        Object object2;
        ListOfPlanVariableDeclaration listOfPlanVariableDeclaration = this.plan.getAllPlanVariableDeclarations();
        for (Object object2 : listOfPlanVariableDeclaration) {
            this.idToVarMap.put(((PlanVariableDeclaration)object2).getId(), this.mapVariableDeclaration((PlanVariableDeclaration)object2));
        }
        Debug.noteln("idToVarMap", (Object)this.idToVarMap);
        this.plan = (Plan)new Pass1().copy(this.plan);
        if (this.plan.getWorldState() != null) {
            this.modelManager.handleEffects(this.plan.getWorldState());
        }
        Object object3 = Collect.iterator(this.plan.getPlanIssues());
        while (object3.hasNext()) {
            object2 = (PlanIssue)object3.next();
            abstractIXObject = ((PlanIssue)object2).getIssue();
            this.controller.addIssue((Issue)abstractIXObject);
            if (((AbstractPlanItem)object2).getExpansion() == null) continue;
            this.installIssueExpansion((PlanIssue)object2);
        }
        object3 = Collect.iterator(this.plan.getPlanNodes());
        while (object3.hasNext()) {
            object2 = (PlanNode)object3.next();
            abstractIXObject = ((PlanNode)object2).getActivity();
            this.controller.addActivity((Activity)abstractIXObject);
            this.idToItemMap.put(((AbstractPlanItem)object2).getId(), this.findItemForActivity((Activity)abstractIXObject));
            if (((AbstractPlanItem)object2).getExpansion() == null) continue;
            this.installExpansion((PlanNode)object2);
        }
        this.walkInstalledPlan(new PlanWalker(){

            public void visitAgendaItem(AgendaItem agendaItem) {
                agendaItem.assignStatus(agendaItem.getStatus());
                agendaItem.fireStatusChanged();
                PlanInstaller.this.walkInstalledChildren(agendaItem, this);
            }
        });
        object3 = this.plan.getConstraints();
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                abstractIXObject = (Constrainer)object2.next();
                this.modelManager.addConstraint(this.idToItemMap, (Constrainer)abstractIXObject);
            }
        }
        if ((object2 = this.plan.getAnnotations()) != null) {
            this.modelManager.takeAnnotations((Map)object2);
        }
    }

    public Variable mapVariableDeclaration(PlanVariableDeclaration planVariableDeclaration) {
        ItemVar itemVar = (ItemVar)planVariableDeclaration.getName();
        if (planVariableDeclaration.getScope() == VariableScope.GLOBAL) {
            Variable variable = this.modelManager.getVariable(itemVar);
            if (variable == null) {
                variable = new Variable(itemVar);
                this.modelManager.addVariable(variable);
            }
            return variable;
        }
        return new Variable(itemVar);
    }

    Variable getVariableFromId(Name name) {
        return (Variable)this.idToVarMap.get(name);
    }

    void installIssueExpansion(PlanIssue planIssue) {
        Issue issue = planIssue.getIssue();
        IssueItem issueItem = this.findItemForIssue(issue);
        PlanIssueRefinement planIssueRefinement = this.plan.getPlanIssueRefinement(planIssue.getExpansion());
        Debug.expect(planIssueRefinement.getExpands().equals(planIssue.getId()));
        issueItem.setVarTable(this.makeVarTable(issueItem, planIssueRefinement.getPlanVariableDeclarations()));
        ListOfPlanIssue listOfPlanIssue = planIssueRefinement.getPlanIssues();
        if (listOfPlanIssue != null) {
            LinkedList linkedList = new LinkedList();
            for (PlanIssue planIssue2 : listOfPlanIssue) {
                Issue issue2 = planIssue2.getIssue();
                IssueItem issueItem2 = new IssueItem(issueItem, issue2);
                linkedList.add(issueItem2);
            }
            Object object = this.controller.getIssueAgenda();
            this.installSubitems((Agenda)object, issueItem, linkedList, listOfPlanIssue);
        }
        if (listOfPlanIssue != null) {
            for (Object object : listOfPlanIssue) {
                if (((AbstractPlanItem)object).getExpansion() == null) continue;
                this.installIssueExpansion((PlanIssue)object);
            }
        }
    }

    void installExpansion(PlanNode planNode) {
        ListOfPlanNode listOfPlanNode;
        Activity activity = planNode.getActivity();
        ActivityItem activityItem = this.findItemForActivity(activity);
        PlanRefinement planRefinement = this.plan.getPlanRefinement(planNode.getExpansion());
        Debug.expect(planRefinement.getExpands().equals(planNode.getId()));
        if (!planRefinement.isNotExpansion()) {
            activityItem.setVarTable(this.makeVarTable(activityItem, planRefinement.getPlanVariableDeclarations()));
        }
        if ((listOfPlanNode = planRefinement.getPlanNodes()) == null) {
            Debug.expect(planRefinement.getOrderings().isEmpty());
        } else {
            List list = this.makeSubactivities(activityItem, listOfPlanNode);
            Object object = this.controller.getActivityAgenda();
            this.installSubitems((Agenda)object, activityItem, list, listOfPlanNode);
            this.installOrderings(activityItem, planRefinement.getOrderings());
            activityItem.ensureChildrenLinkedToParent();
        }
        this.installConstraints(activityItem, planRefinement.getConstraints(Constraint.class));
        Debug.expect(planRefinement.isNotExpansion() != activityItem.isExpanded());
        activityItem.fireAgendaItemEdited();
        if (listOfPlanNode != null) {
            for (Object object : listOfPlanNode) {
                if (((AbstractPlanItem)object).getExpansion() == null) continue;
                this.installExpansion((PlanNode)object);
            }
        }
    }

    ActivityItem findItemForActivity(Activity activity) {
        List list = this.controller.getActivityAgenda().getItems();
        return (ActivityItem)this.findItem(activity, list);
    }

    IssueItem findItemForIssue(Issue issue) {
        List list = this.controller.getIssueAgenda().getItems();
        return (IssueItem)this.findItem(issue, list);
    }

    AgendaItem findItem(TaskItem taskItem, List list) {
        for (AgendaItem agendaItem : list) {
            if (agendaItem.getAbout() != taskItem) continue;
            return agendaItem;
        }
        throw new IllegalArgumentException("Can't find item for " + taskItem);
    }

    Map makeVarTable(AgendaItem agendaItem, List list) {
        HashMap<Object, Variable> hashMap = new HashMap<Object, Variable>();
        Iterator iterator = Collect.iterator(list);
        while (iterator.hasNext()) {
            PlanVariableDeclaration planVariableDeclaration = (PlanVariableDeclaration)iterator.next();
            Variable variable = this.getVariableFromId(planVariableDeclaration.getId());
            hashMap.put(variable.getName(), variable);
            variable.setSourceNode(agendaItem);
        }
        return hashMap;
    }

    List makeSubactivities(ActivityItem activityItem, List list) {
        LinkedList<ActivityItem> linkedList = new LinkedList<ActivityItem>();
        for (PlanNode planNode : list) {
            Activity activity = planNode.getActivity();
            ActivityItem activityItem2 = new ActivityItem(activityItem, activity);
            this.idToItemMap.put(planNode.getId(), activityItem2);
            linkedList.add(activityItem2);
        }
        return linkedList;
    }

    void installSubitems(Agenda agenda, AgendaItem agendaItem, List list, List list2) {
        Map map = this.makeNameToChildMap(list, list2);
        agendaItem.setChildren(list);
        agendaItem.setNameToChildMap(map);
        for (AgendaItem agendaItem2 : list) {
            Debug.expect(agendaItem2.getParent() == agendaItem);
            Debug.expect(agendaItem2.getLevel() == agendaItem.getLevel() + 1);
            agenda.addItem(agendaItem2);
        }
    }

    Map makeNameToChildMap(List list, List list2) {
        Debug.expect(list.size() == list2.size());
        HashMap<Name, AgendaItem> hashMap = new HashMap<Name, AgendaItem>();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            AbstractPlanItem abstractPlanItem = (AbstractPlanItem)iterator2.next();
            hashMap.put(abstractPlanItem.getId(), agendaItem);
        }
        return hashMap;
    }

    void installOrderings(ActivityItem activityItem, ListOfOrdering listOfOrdering) {
        if (!listOfOrdering.isEmpty()) {
            activityItem.processOrderings(listOfOrdering);
        }
        this.modelManager.addOrderingsAsTimeConstraints(activityItem, listOfOrdering);
    }

    void installConstraints(ActivityItem activityItem, List list) {
        if (list != null) {
            this.modelManager.addConstraints(activityItem, list);
        }
    }

    class Pass1
    extends ObjectCopier {
        Pass1() {
        }

        public Object mapElement(Object object) {
            return object instanceof PlanVariable ? this.mapPlanVariable((PlanVariable)object) : this.copy(object);
        }

        Variable mapPlanVariable(PlanVariable planVariable) {
            Variable variable = PlanInstaller.this.getVariableFromId(planVariable.getId());
            Debug.expect(variable != null, "Unknown variable", planVariable);
            return variable;
        }
    }

    public static interface PlanWalker {
        public void visitAgendaItem(AgendaItem var1);
    }
}

