/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.net.URL;
import java.util.List;

public class ShowURLHandler
extends ActivityHandler {
    public static final Symbol S_SHOW_URL = Symbol.intern("show-url");
    protected Ip2 ip2;

    public ShowURLHandler(Ip2 ip2) {
        super("Show URL");
        this.ip2 = ip2;
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((show-url ?url))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() == 2 && lList.get(0) == S_SHOW_URL;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new HandlerAction.AutomaticWhenBound(agendaItem, this));
    }

    public void handle(AgendaItem agendaItem) {
        LList lList = (LList)Variable.removeVars(agendaItem.getPattern());
        String string = lList.get(1).toString();
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't make a URL from " + Strings.quote(string));
        }
        this.ip2.frame.ensureHTMLViewer().displayURL(uRL);
        agendaItem.setStatus(Status.COMPLETE);
    }
}

