/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.PatternAssignment;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.SyncStateClient;
import ix.ip2.SyncStateServer;
import ix.iplan.IPlanOptionManager;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class SyncState {
    protected static final Symbol SYNCHRONIZE_STATE = Symbol.intern("synchronize_state");
    protected Ip2 ip2;
    protected Ip2ModelManager mm;
    protected IPlanOptionManager optMan;

    public SyncState(Ip2 ip2) {
        this.ip2 = ip2;
        this.mm = ip2.getIp2ModelManager();
        this.optMan = ip2.getOptionManager();
    }

    protected Activity makeSyncStateActivity(Operation operation) {
        Activity activity = new Activity(Lisp.list(SYNCHRONIZE_STATE, operation));
        return activity;
    }

    protected void send(String string, Operation operation) {
        IPC.sendObject(string, this.makeSyncStateActivity(operation));
    }

    protected void deletionUtility(ListOfPatternAssignment listOfPatternAssignment) {
        Debug.expect(listOfPatternAssignment.size() == 1, "delete for != 1 constraint");
        ListOfPatternAssignment listOfPatternAssignment2 = listOfPatternAssignment;
        PatternAssignment patternAssignment = (PatternAssignment)listOfPatternAssignment2.get(0);
        Object object = this.mm.getWorldStateValue(patternAssignment.getPattern());
        if (object != null) {
            if (!patternAssignment.getValue().equals(object)) {
                patternAssignment.setValue(object);
            }
            this.mm.deleteEffect(patternAssignment);
        }
    }

    public static class ServerStateDeletion
    extends ServerStateDelta {
        public ServerStateDeletion() {
            this(null);
        }

        public ServerStateDeletion(Map map) {
            super(map);
        }

        public void run(SyncStateClient syncStateClient) {
            syncStateClient.handle(this);
        }
    }

    public static class ServerFullState
    extends ServerStateDelta {
        public ServerFullState() {
            this(null);
        }

        public ServerFullState(Map map) {
            super(map);
        }

        public void run(SyncStateClient syncStateClient) {
            syncStateClient.handle(this);
        }
    }

    public static class ServerStateChange
    extends ServerStateDelta {
        public ServerStateChange() {
            this(null);
        }

        public ServerStateChange(Map map) {
            super(map);
        }

        public void run(SyncStateClient syncStateClient) {
            syncStateClient.handle(this);
        }
    }

    public static abstract class ServerStateDelta
    extends AbstractClientOperation {
        protected ListOfPatternAssignment delta;

        public ServerStateDelta(Map map) {
            if (map != null) {
                this.delta = PatternAssignment.mapToAssignments(map);
            }
        }

        public ListOfPatternAssignment getDelta() {
            return this.delta;
        }

        public void setDelta(ListOfPatternAssignment listOfPatternAssignment) {
            this.delta = listOfPatternAssignment;
        }
    }

    public static abstract class AbstractClientOperation
    implements ClientOperation {
    }

    public static class ClientStateDeletion
    extends ClientStateDelta {
        public ClientStateDeletion() {
            this(null, null);
        }

        public ClientStateDeletion(String string, Map map) {
            super(string, map);
        }

        public void run(SyncStateServer syncStateServer) {
            syncStateServer.handle(this);
        }
    }

    public static class ClientStateChange
    extends ClientStateDelta {
        public ClientStateChange() {
            this(null, null);
        }

        public ClientStateChange(String string, Map map) {
            super(string, map);
        }

        public void run(SyncStateServer syncStateServer) {
            syncStateServer.handle(this);
        }
    }

    public static class RegisterClient
    extends ClientStateDelta {
        public RegisterClient() {
            this(null, null);
        }

        public RegisterClient(String string, Map map) {
            super(string, map);
        }

        public void run(SyncStateServer syncStateServer) {
            syncStateServer.handle(this);
        }
    }

    public static abstract class ClientStateDelta
    extends AbstractServerOperation {
        protected ListOfPatternAssignment delta;

        public ClientStateDelta(String string, Map map) {
            super(string);
            if (map != null) {
                this.delta = PatternAssignment.mapToAssignments(map);
            }
        }

        public ListOfPatternAssignment getDelta() {
            return this.delta;
        }

        public void setDelta(ListOfPatternAssignment listOfPatternAssignment) {
            this.delta = listOfPatternAssignment;
        }
    }

    public static abstract class AbstractServerOperation
    implements ServerOperation {
        protected String clientName;

        public AbstractServerOperation(String string) {
            this.clientName = string;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String string) {
            this.clientName = string;
        }
    }

    public static interface ClientOperation
    extends Operation {
        public void run(SyncStateClient var1);
    }

    public static interface ServerOperation
    extends Operation {
        public String getClientName();

        public void run(SyncStateServer var1);
    }

    public static interface Operation
    extends Serializable {
    }

    public static abstract class SyncStateHandler
    extends ActivityHandler {
        protected Ip2 ip2;

        public SyncStateHandler(Ip2 ip2, String string) {
            super(string);
            this.ip2 = ip2;
        }

        public List getSyntaxList() {
            return (LList)Lisp.readFromString("((synchronize-state ?sync-state-operation))");
        }

        public boolean appliesTo(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            return lList.get(0) == SYNCHRONIZE_STATE && lList.get(1) instanceof Operation;
        }

        protected Operation getOperation(AgendaItem agendaItem) {
            return (Operation)agendaItem.getPattern().get(1);
        }

        public boolean isAutomatic() {
            return true;
        }

        public void addHandlerActions(AgendaItem agendaItem) {
            agendaItem.addAction(new HandlerAction.AutomaticWhenBound(agendaItem, this));
        }

        public abstract void handle(AgendaItem var1);
    }
}

