/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgentExtension;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.process.event.ProcessStatusEvent;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.NullStateViewer;
import ix.ip2.StateViewer;
import ix.ip2.SyncState;
import ix.iplan.IPlanOptionManager;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.StableHashMap;
import ix.util.Util;
import java.util.Map;

public class SyncStateClient
extends SyncState
implements IXAgentExtension {
    protected String serverName;
    protected String clientName;
    StateViewer processListener = new ProcessListener();
    protected boolean doingUpdateFromServer = false;

    public SyncStateClient(Ip2 ip2) {
        super(ip2);
    }

    public void installExtension() {
        this.serverName = Parameters.requireParameter("sync-state-server");
        this.clientName = this.ip2.getAgentSymbolName();
        this.ip2.getController().addActivityHandler(new SyncStateClientHandler(this.ip2));
        this.ip2.addStartupHook(new StartupHook());
        this.ip2.addResetHook(new ResetHook());
    }

    protected void handleOperation(SyncState.ClientOperation clientOperation) {
        Debug.noteln("Sync-state client handing", (Object)clientOperation);
        clientOperation.run(this);
    }

    public void handle(SyncState.ServerStateChange serverStateChange) {
        if (this.optMan.canTakeInput()) {
            this.handleServerStateChange(serverStateChange.getDelta());
        } else {
            this.optMan.getOptionForInput().recordDelayedInput(new ChangeMessage(serverStateChange.getDelta()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServerStateChange(ListOfPatternAssignment listOfPatternAssignment) {
        try {
            this.doingUpdateFromServer = true;
            this.mm.handleEffects(listOfPatternAssignment);
        }
        finally {
            this.doingUpdateFromServer = false;
        }
    }

    public void handle(SyncState.ServerFullState serverFullState) {
        Debug.noteln("Full state from sync-state server.");
        if (this.optMan.canTakeInput()) {
            this.handleServerStateChange(serverFullState.getDelta());
        } else {
            this.optMan.getOptionForInput().recordDelayedInput(new ChangeMessage(serverFullState.getDelta()));
        }
    }

    public void handle(SyncState.ServerStateDeletion serverStateDeletion) {
        if (this.optMan.canTakeInput()) {
            this.handleServerStateDeletion(serverStateDeletion.getDelta());
        } else {
            this.optMan.getOptionForInput().recordDelayedInput(new DeleteMessage(serverStateDeletion.getDelta()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServerStateDeletion(ListOfPatternAssignment listOfPatternAssignment) {
        try {
            this.doingUpdateFromServer = true;
            this.deletionUtility(listOfPatternAssignment);
        }
        finally {
            this.doingUpdateFromServer = false;
        }
    }

    protected class DeleteMessage
    extends IPlanOptionManager.PseudoMessage {
        DeleteMessage(ListOfPatternAssignment listOfPatternAssignment) {
            super(listOfPatternAssignment);
        }

        public void receivedBy(IPlanOptionManager.Opt opt, Ip2 ip2) {
            Debug.noteln("Delayed state deletion in", (Object)opt);
            Debug.expectSame(SyncStateClient.this.ip2, ip2);
            SyncStateClient.this.handleServerStateDeletion((ListOfPatternAssignment)this.getContents());
        }
    }

    protected class ChangeMessage
    extends IPlanOptionManager.PseudoMessage {
        ChangeMessage(ListOfPatternAssignment listOfPatternAssignment) {
            super(listOfPatternAssignment);
        }

        public void receivedBy(IPlanOptionManager.Opt opt, Ip2 ip2) {
            Debug.noteln("Delayed state change in", (Object)opt);
            Debug.expectSame(SyncStateClient.this.ip2, ip2);
            SyncStateClient.this.handleServerStateChange((ListOfPatternAssignment)this.getContents());
        }
    }

    public class SyncStateClientHandler
    extends SyncState.SyncStateHandler {
        public SyncStateClientHandler(Ip2 ip2) {
            super(ip2, "Synchronize state in client");
        }

        public void handle(AgendaItem agendaItem) {
            SyncStateClient.this.handleOperation((SyncState.ClientOperation)this.getOperation(agendaItem));
        }
    }

    protected class ProcessListener
    extends NullStateViewer {
        protected ProcessListener() {
        }

        public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
            if (!SyncStateClient.this.ip2.isReloadingViewers() && SyncStateClient.this.optMan.canTakeInput() && !SyncStateClient.this.doingUpdateFromServer) {
                SyncStateClient.this.send(SyncStateClient.this.serverName, new SyncState.ClientStateChange(SyncStateClient.this.clientName, map));
            }
        }

        public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
            Debug.expect(!SyncStateClient.this.ip2.isReloadingViewers());
            if (SyncStateClient.this.optMan.canTakeInput() && !SyncStateClient.this.doingUpdateFromServer) {
                SyncStateClient.this.send(SyncStateClient.this.serverName, new SyncState.ClientStateDeletion(SyncStateClient.this.clientName, map));
            }
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
            SyncStateClient.this.processListener.reset();
        }
    }

    protected class StartupHook
    implements Runnable {
        protected StartupHook() {
        }

        public void run() {
            Map map = SyncStateClient.this.ip2.getIp2ModelManager().getWorldStateMap();
            map = new StableHashMap(map);
            while (true) {
                try {
                    SyncStateClient.this.send(SyncStateClient.this.serverName, new SyncState.RegisterClient(SyncStateClient.this.clientName, map));
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                    if (this.tryRegisteringAgain()) continue;
                    return;
                }
                break;
            }
            SyncStateClient.this.ip2.getModelManager().addProcessStatusListener(SyncStateClient.this.processListener);
        }

        boolean tryRegisteringAgain() {
            Object[] objectArray = new Object[]{"Could not register " + SyncStateClient.this.clientName + " with sync-state server " + SyncStateClient.this.serverName, "Do you want to try again?"};
            return Util.dialogConfirms(SyncStateClient.this.ip2.getFrame(), objectArray);
        }
    }
}

