/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2.test;

import ix.ichat.ChatMessage;
import ix.icore.Report;
import ix.icore.Sendable;
import ix.icore.TaskItem;
import ix.ip2.test.PanelTest;
import ix.ip2.test.TestItem;
import ix.ip2.test.TestSequence;
import ix.util.Debug;
import ix.util.PatternParser;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.xml.XML;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TestSequenceGenerator
extends PanelTest {
    protected static final int UNSPECIFIED = -1;
    protected int initialDelay = -1;
    protected int delayBetween = -1;
    protected TestItem template;
    protected List toNames;
    protected List contentStrings;

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int n) {
        this.initialDelay = n;
    }

    public int getDelayBetween() {
        return this.delayBetween;
    }

    public void setDelayBetween(int n) {
        this.delayBetween = n;
    }

    public TestItem getTemplate() {
        return this.template;
    }

    public void setTemplate(TestItem testItem) {
        this.template = testItem;
    }

    public List getToNames() {
        return this.toNames;
    }

    public void setToNames(List list) {
        this.toNames = list;
    }

    public List getContentStrings() {
        return this.contentStrings;
    }

    public void setContentStrings(List list) {
        this.contentStrings = list;
    }

    public List getTestItems() {
        return this.generateTestSequence().getTestItems();
    }

    public TestSequence generateTestSequence() {
        TestItem testItem;
        TestSequence testSequence = new TestSequence();
        LinkedList linkedList = new LinkedList();
        if (this.toNames != null && this.contentStrings != null) {
            throw new IllegalArgumentException("Test sequence cannot be generated from both names and content strings.");
        }
        if (this.toNames != null) {
            this.generateForNames(this.toNames, linkedList);
        } else if (this.contentStrings != null) {
            this.generateForContents(this.contentStrings, linkedList);
        } else {
            throw new IllegalArgumentException("One of names or content strings must be specified for test sequence");
        }
        Iterator iterator = linkedList.iterator();
        if (iterator.hasNext()) {
            testItem = (TestItem)iterator.next();
            if (this.initialDelay != -1) {
                testItem.setDelayBefore(this.initialDelay);
            }
        }
        if (this.delayBetween != -1) {
            while (iterator.hasNext()) {
                testItem = (TestItem)iterator.next();
                testItem.setDelayBefore(this.delayBetween);
            }
        }
        testSequence.setMenuText(this.menuText);
        testSequence.setTestItems(linkedList);
        Debug.noteln("Generated sequence:", (Object)XML.objectToXMLString(testSequence));
        return testSequence;
    }

    protected void generateForNames(List list, List list2) {
        for (String string : list) {
            TestItem testItem = this.copyTemplate();
            testItem.setToName(string);
            list2.add(testItem);
        }
    }

    protected void generateForContents(List list, List list2) {
        for (String string : list) {
            Debug.noteln("String", (Object)string);
            TestItem testItem = this.copyTemplate();
            this.setContent(testItem.getContents(), string);
            list2.add(testItem);
        }
    }

    protected TestItem copyTemplate() {
        TestItem testItem = new TestItem();
        testItem.setDelayBefore(this.template.getDelayBefore());
        testItem.setToName(this.template.getToName());
        testItem.setContents((Sendable)Util.clone(this.template.getContents()));
        return testItem;
    }

    protected void setContent(Sendable sendable, String string) {
        if (sendable instanceof TaskItem) {
            TaskItem taskItem = (TaskItem)sendable;
            LList lList = PatternParser.parse(string);
            taskItem.setPattern(lList);
        } else if (sendable instanceof Report) {
            Report report = (Report)sendable;
            report.setText(string);
        } else if (sendable instanceof ChatMessage) {
            ChatMessage chatMessage = (ChatMessage)sendable;
            chatMessage.setText(string);
        } else {
            throw new IllegalArgumentException("Cannot set contents of " + sendable);
        }
    }
}

