/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.iplan.IPlan;
import ix.iplan.NoPlanException;
import ix.iplan.PlanStats;
import ix.iplan.Planner;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Predicate1;
import ix.util.Util;

public class FilteredPlanner
implements Planner {
    protected Planner planner;
    protected Predicate1 filter;
    protected boolean filterPlans = true;
    protected Plan plan = null;

    public FilteredPlanner(Planner planner, Predicate1 predicate1) {
        this.planner = planner;
        this.filter = predicate1;
        this.filterPlans = Parameters.getBoolean("filter-plans", this.filterPlans);
    }

    public void setDomain(Domain domain) {
        this.planner.setDomain(domain);
    }

    public void loadPlan(Plan plan) {
        this.planner.loadPlan(plan);
    }

    public void plan() {
        this.planner.plan();
        this.plan = this.filteredPlan();
    }

    public void replan() {
        this.planner.replan();
        this.plan = this.filteredPlan();
    }

    public Plan getPlan() {
        if (this.plan != null) {
            return this.plan;
        }
        throw new IllegalStateException("This planner has not yet found a plan.");
    }

    public PlanStats getStatistics() {
        return this.planner.getStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plan filteredPlan() {
        int n = 0;
        while (true) {
            Plan plan = this.planner.getPlan();
            if (!this.filterPlans) {
                return plan;
            }
            if (this.filter.trueOf(plan)) {
                return plan;
            }
            this.rejectPlan(plan, ++n);
            try {
                this.planner.replan();
                continue;
            }
            finally {
                this.recordRejectCount(n);
                continue;
            }
            break;
        }
    }

    private void rejectPlan(Plan plan, int n) {
        Debug.noteln("Plan rejected by", (Object)this.filter);
        if (n % 50 == 0 && Parameters.isInteractive()) {
            String[] stringArray = new String[]{n + " duplicate plans have been rejected", "Do you want to continue?"};
            if (!Util.dialogConfirms(IPlan.displayFrame(), stringArray)) {
                throw new NoPlanException();
            }
        }
    }

    private void recordRejectCount(int n) {
        PlanStats planStats = this.planner.getStatistics();
        if (n > 0) {
            planStats.recordStat("Number of rejected plans", new Integer(n));
        }
    }
}

