/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.process.ProcessModelManager;
import ix.iface.util.ToolController;
import ix.iface.util.ToolManager;
import ix.ip2.Ip2;
import ix.ip2.Ip2Frame;
import ix.iplan.FilteredPlanner;
import ix.iplan.IPlanCompletionHandler;
import ix.iplan.IPlanExpandHandler;
import ix.iplan.IPlanFrame;
import ix.iplan.IPlanModelManager;
import ix.iplan.IPlanTool;
import ix.iplan.Planner;
import ix.iplan.Slip;
import ix.test.DigestSet;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.context.Context;
import ix.util.context.ContextHolder;
import ix.util.context.ContextLockingProxy;
import java.awt.Component;

public class IPlan
extends Ip2 {
    public IPlan() {
        this(true);
    }

    protected IPlan(boolean bl) {
        super(bl);
        this.agentTypeName = "I-X Planner";
        this.logoLine1 = "I-X Planner";
        this.displayName = this.agentTypeName;
        this.showOptions = true;
        Parameters.setParameter("plan-state-to-save", "*");
        Parameters.getParameter("plan-state-to-save");
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-Plan");
        new IPlan().mainStartup(stringArray);
    }

    public void setDomain(Domain domain) {
        domain.checkConsistency();
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Planner makeDefaultPlanner() {
        Slip slip;
        Object object;
        ContextHolder contextHolder = Context.getContextHolder();
        Context context = contextHolder.getContext();
        try {
            object = new Context();
            contextHolder.setContext((Context)object);
            Debug.noteln("Making default planner in " + object + " with ancestors " + ((Context)object).getAncestors());
            slip = new Slip(false);
            slip.mainStartup(new String[0]);
        }
        finally {
            contextHolder.setContext(context);
        }
        object = ContextLockingProxy.newProxyInstance(Planner.class, slip);
        DigestSet.IsNewPredciate isNewPredciate = new DigestSet.IsNewPredciate(new DigestSet());
        return new FilteredPlanner((Planner)object, isNewPredciate);
    }

    protected ProcessModelManager makeModelManager() {
        return new IPlanModelManager(this);
    }

    protected Ip2Frame makeIp2Frame() {
        return new IPlanFrame(this);
    }

    protected void initOptions() {
        this.optionManager.initOptions();
    }

    static Component displayFrame() {
        IXAgent iXAgent = IXAgent.getAgent();
        if (!(iXAgent instanceof Ip2)) {
            return null;
        }
        Ip2 ip2 = (Ip2)iXAgent;
        Ip2Frame ip2Frame = ip2.getFrame();
        if (ip2Frame == null) {
            return null;
        }
        ToolManager toolManager = ip2Frame.getToolManager();
        if (toolManager == null) {
            return ip2Frame;
        }
        ToolController toolController = toolManager.findTool("I-Plan");
        if (toolController == null) {
            return ip2Frame;
        }
        IPlanTool iPlanTool = (IPlanTool)toolController.getTool();
        if (iPlanTool == null) {
            return ip2Frame;
        }
        return iPlanTool.getFrame();
    }

    protected void addHandlers() {
        this.controller.addItemHandler(new IPlanCompletionHandler(this));
        this.controller.addActivityHandler(new IPlanExpandHandler(this));
    }
}

