/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.Ip2ModelManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Proc;
import ix.util.Ref;
import ix.util.lisp.LList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanModelComparer {
    Ip2ModelManager originalMM;
    Ip2ModelManager copyMM;
    Map<ActivityItem, ActivityItem> nodeMap;

    public PlanModelComparer(Ip2ModelManager ip2ModelManager, Ip2ModelManager ip2ModelManager2) {
        this.originalMM = ip2ModelManager;
        this.copyMM = ip2ModelManager2;
    }

    public void compare() throws PlanDifferenceException {
        this.nodeMap = this.makeNodeMap();
        this.compareOrderings();
    }

    private PlanDifferenceException problem(String string) {
        return new PlanDifferenceException(string);
    }

    private Map<ActivityItem, ActivityItem> makeNodeMap() {
        LinkedHashMap<ActivityItem, ActivityItem> linkedHashMap = new LinkedHashMap<ActivityItem, ActivityItem>();
        Iterator<ActivityItem> iterator = this.getActivities(this.copyMM).iterator();
        for (ActivityItem activityItem : this.getActivities(this.originalMM)) {
            LList lList;
            if (!iterator.hasNext()) {
                throw this.problem("Too few nodes in copy");
            }
            ActivityItem activityItem2 = iterator.next();
            LList lList2 = (LList)Variable.removeVars(activityItem.getPattern());
            if (lList2.equals(lList = (LList)Variable.removeVars(activityItem2.getPattern()))) {
                linkedHashMap.put(activityItem, activityItem2);
                continue;
            }
            throw this.problem("Mismatch: " + lList2 + " vs " + lList);
        }
        if (iterator.hasNext()) {
            throw this.problem("Too many nodes in copy");
        }
        return linkedHashMap;
    }

    private List<ActivityItem> getActivities(final Ip2ModelManager ip2ModelManager) {
        final LinkedList<ActivityItem> linkedList = new LinkedList<ActivityItem>();
        final Ref<1> ref = new Ref<1>();
        ref.set(new Proc(){

            public void call(Object object) {
                ActivityItem activityItem = (ActivityItem)object;
                linkedList.add(activityItem);
                ip2ModelManager.walkNodeChildren(activityItem, (Proc)ref.get());
            }
        });
        ip2ModelManager.walkTopNodes((Proc)ref.get());
        return linkedList;
    }

    private void compareOrderings() {
        for (ActivityItem activityItem : this.nodeMap.keySet()) {
            ActivityItem activityItem2 = this.nodeMap.get(activityItem);
            this.compareOrderings(activityItem.getBegin(), activityItem2.getBegin());
            this.compareOrderings(activityItem.getEnd(), activityItem2.getEnd());
        }
    }

    private void compareOrderings(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(pNodeEnd.getSuccessors());
        List list = this.mapEndsToCopy(linkedHashSet);
        List list2 = pNodeEnd2.getSuccessors();
        List list3 = (List)Collect.difference(list2, list);
        List list4 = (List)Collect.difference(list, list2);
        this.dropOkMissingSuccessors(pNodeEnd2, list4);
        if (!list3.isEmpty() || !list4.isEmpty()) {
            throw this.problem(pNodeEnd + " has different successors.\n" + "   copy extras: " + list3 + "\n" + "   copy missing: " + list4);
        }
    }

    private void dropOkMissingSuccessors(PNodeEnd pNodeEnd, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.okMissingSuccessor(pNodeEnd, (PNodeEnd)iterator.next())) continue;
            iterator.remove();
        }
    }

    protected boolean okMissingSuccessor(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        return this.okMissingSuccessor1(pNodeEnd, pNodeEnd2) || this.okMissingSuccessor2(pNodeEnd, pNodeEnd2);
    }

    private boolean okMissingSuccessor1(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        return pNodeEnd.getNode().isParentOf(pNodeEnd2.getNode()) && pNodeEnd.getEnd() == End.BEGIN && pNodeEnd2.getEnd() == End.BEGIN && pNodeEnd.getShadowedEnds().contains(pNodeEnd2) || pNodeEnd2.getNode().isParentOf(pNodeEnd.getNode()) && pNodeEnd.getEnd() == End.END && pNodeEnd2.getEnd() == End.END && pNodeEnd.getShadowedEnds().contains(pNodeEnd2);
    }

    private boolean okMissingSuccessor2(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        return pNodeEnd.getNode().isParentOf(pNodeEnd2.getNode()) && pNodeEnd.getEnd() == End.BEGIN && pNodeEnd2.getEnd() == End.END || pNodeEnd2.getNode().isParentOf(pNodeEnd.getNode()) && pNodeEnd2.getEnd() == End.END && pNodeEnd.getEnd() == End.BEGIN;
    }

    private List mapEndsToCopy(Collection collection) {
        LinkedList<PNodeEnd> linkedList = new LinkedList<PNodeEnd>();
        for (Object e : collection) {
            PNodeEnd pNodeEnd = (PNodeEnd)e;
            PNodeEnd pNodeEnd2 = this.getCopyEnd(pNodeEnd);
            Debug.expect(pNodeEnd2 != null);
            linkedList.add(pNodeEnd2);
        }
        return linkedList;
    }

    private PNodeEnd getCopyEnd(PNodeEnd pNodeEnd) {
        PNode pNode = this.nodeMap.get(pNodeEnd.getNode());
        return pNodeEnd.getEnd() == End.BEGIN ? pNode.getBegin() : pNode.getEnd();
    }

    public static class PlanDifferenceException
    extends RuntimeException {
        PlanDifferenceException(String string) {
            super(string);
        }
    }
}

