/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.plan.Plan;
import ix.iface.util.Reporting;
import ix.iplan.IPlan;
import ix.iplan.PlanStats;
import ix.iplan.Planner;
import ix.test.OPlanPSGraph;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.xml.XML;
import java.io.IOException;

public abstract class PlannerBase
extends IPlan
implements Planner {
    private boolean standAlone;

    public PlannerBase(boolean bl) {
        super(bl);
        this.standAlone = bl;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void plan() {
        throw new UnsupportedOperationException();
    }

    public void replan() {
        throw new UnsupportedOperationException("This planning algorithm cannot replan.");
    }

    public PlanStats getStatistics() {
        throw new UnsupportedOperationException("This planning algorithm does not produce statistics.");
    }

    public void startup() {
        this.modelManager = this.makeModelManager();
        this.controller = this.makeController();
        this.controller.connectTo(this.modelManager);
        this.addHandlers();
        if (!this.isStandAlone()) {
            return;
        }
        this.readDomain(this.getDomain());
        String string = Parameters.getParameter("plan");
        if (string != null) {
            this.loadPlan(string);
        }
    }

    protected void startServer(Object object, String string) {
        if (this.isStandAlone()) {
            super.startServer(object, string);
        }
    }

    protected void completeStartup() {
        throw new UnsupportedOperationException("completeStartup");
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        Object object = inputMessage.getContents();
        throw new UnsupportedOperationException("Received " + Reporting.description(object));
    }

    protected void addHandlers() {
    }

    protected void initOptions() {
        throw new UnsupportedOperationException("initOptions");
    }

    protected void outputPlan() {
        String string = Parameters.getParameter("output");
        if (string == null) {
            return;
        }
        Plan plan = this.modelManager.getPlan();
        XML.writeObject(plan, string);
        if (Parameters.haveParameter("output-psgraph-data")) {
            this.outputPlanPSGraphData(plan);
        }
    }

    protected void outputPlanPSGraphData(Plan plan) {
        String string = Parameters.getParameter("output-psgraph-data");
        OPlanPSGraph oPlanPSGraph = new OPlanPSGraph();
        oPlanPSGraph.outputPlanForOPlan(plan, string);
    }

    protected void outputOwlSPlan() throws IOException {
        String string = Parameters.getParameter("owls-out");
        if (string == null) {
            return;
        }
        Object object = this.makeInstance("ix.util.owls.PlanToOWLS");
        if (object == null) {
            return;
        }
        throw new UnsupportedOperationException("OWL-S output");
    }

    protected Object makeInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return Util.makeInstance(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.noteln("Can't make class", (Object)string);
            return null;
        }
    }
}

