/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.domain.Domain;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.icore.process.TimePoint;
import ix.ip2.ActivityItem;
import ix.ip2.Ip2ModelManager;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.TimePointNet;
import ix.util.Inf;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SanityChecker {
    protected static final Symbol TRUE = Symbol.intern("true");
    protected static final Symbol FALSE = Symbol.intern("false");
    protected PlanCheckingSimulator sim;
    protected Ip2ModelManager mm;

    public SanityChecker(PlanCheckingSimulator planCheckingSimulator) {
        this.sim = planCheckingSimulator;
        this.mm = planCheckingSimulator.getModelManagerBeingChecked();
    }

    public void checkPlan() {
        this.sim.traceln("Running sanity check.");
        this.checkNodesVsNodeEnds();
        this.checkExpansionRefinements();
        this.checkForMinimalNodes();
        this.checkForMaximalNodes();
        this.checkStartAndFinishTimes();
        this.checkOrderingLinkConnectivity();
        this.checkTemporalConstraintConnectivity();
        this.checkTemporalConstraintsAgainstLinks();
        this.checkLinksAgainstTemporalConstraints();
    }

    public void checkNodesVsNodeEnds() {
        HashSet<PNodeEnd> hashSet = new HashSet<PNodeEnd>(this.mm.getNodeEnds());
        for (ActivityItem activityItem : this.mm.getNodes()) {
            if (!hashSet.remove(activityItem.getBegin())) {
                this.sim.problem("Missing " + activityItem.getBegin());
            }
            if (hashSet.remove(activityItem.getEnd())) continue;
            this.sim.problem("Missing " + activityItem.getEnd());
        }
        if (!hashSet.isEmpty()) {
            this.sim.problem("Stray ends " + hashSet);
        }
    }

    public void checkExpansionRefinements() {
        Domain domain = this.mm.getIp2().getDomain();
        for (ActivityItem activityItem : this.mm.getNodes()) {
            if (!activityItem.isExpanded() || domain.isEmpty() && domain.getName() != null && domain.getName().equals("empty-domain")) continue;
            String string = activityItem.getExpansionRefinementName();
            if (string == null) {
                this.sim.problem("No expansion refinements for " + activityItem);
                continue;
            }
            Refinement refinement = domain.getNamedRefinement(string);
            if (refinement == null) {
                this.sim.problem("No refinement named " + Strings.quote(string) + " for expanding " + activityItem);
                continue;
            }
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), activityItem.getPattern());
            if (matchEnv == null) {
                this.sim.problem(refinement + " doesn't match " + activityItem);
            }
            ListOfNodeSpec listOfNodeSpec = refinement.getNodes();
            List<PNode> list = activityItem.getChildren();
            if (listOfNodeSpec == null || listOfNodeSpec.isEmpty()) {
                if (list == null || list.isEmpty()) continue;
                this.sim.problem("Children of " + activityItem + " that weren't in " + refinement + ": " + list);
                continue;
            }
            if (list == null || list.isEmpty()) {
                this.sim.problem("Subnodes of " + refinement + " that weren't subactivities of " + activityItem + ": " + listOfNodeSpec);
                continue;
            }
            if (listOfNodeSpec.size() != list.size()) {
                this.sim.problem(activityItem + " has the wrong number of subnodes for " + refinement);
                continue;
            }
            Iterator iterator = listOfNodeSpec.iterator();
            for (PNode pNode : list) {
                NodeSpec nodeSpec = (NodeSpec)iterator.next();
                if (Matcher.match(nodeSpec.getPattern(), pNode.getPattern()) != null) continue;
                this.sim.problem(activityItem + " child " + pNode + " does not match " + nodeSpec + " from " + refinement);
            }
        }
    }

    public void checkForMinimalNodes() {
        for (ActivityItem activityItem : this.mm.getNodes()) {
            if (!activityItem.getBegin().getPredecessors().isEmpty()) continue;
            return;
        }
        this.sim.problem("No minimal nodes.");
    }

    public void checkForMaximalNodes() {
        for (ActivityItem activityItem : this.mm.getNodes()) {
            if (!activityItem.getEnd().getSuccessors().isEmpty()) continue;
            return;
        }
        this.sim.problem("No maximal nodes.");
    }

    public void checkStartAndFinishTimes() {
        for (ActivityItem activityItem : this.mm.getNodes()) {
            this.mustNotBeLater(activityItem.getBegin(), activityItem.getEnd());
            PNode pNode = activityItem.getParentPNode();
            if (pNode == null) continue;
            this.mustNotBeLater(pNode.getBegin(), activityItem.getBegin());
            this.mustNotBeLater(activityItem.getEnd(), pNode.getEnd());
        }
    }

    private void mustNotBeLater(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        this.mustBeLE(pNodeEnd, pNodeEnd2, "start", pNodeEnd.getMinTime(), pNodeEnd2.getMinTime());
        this.mustBeLE(pNodeEnd, pNodeEnd2, "finish", pNodeEnd.getMaxTime(), pNodeEnd2.getMaxTime());
    }

    private void mustBeLE(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2, String string, long l, long l2) {
        if (l > l2) {
            this.sim.problem(pNodeEnd + " at " + Inf.asString(l) + " can " + string + " after " + pNodeEnd2 + " at " + Inf.asString(l2));
        }
    }

    public void checkOrderingLinkConnectivity() {
        this.checkOrderingLinkConnectivityForward();
        this.checkOrderingLinkConnectivityBackward();
    }

    public void checkOrderingLinkConnectivityForward() {
        new ForwardOrderingLinkChecker().checkConnectivity();
    }

    public void checkOrderingLinkConnectivityBackward() {
        new BackwardOrderingLinkChecker().checkConnectivity();
    }

    public void checkTemporalConstraintConnectivity() {
        this.checkTemporalConstraintConnectivityForward();
    }

    public void checkTemporalConstraintConnectivityForward() {
        new ForwardTemporalLinkChecker().checkConnectivity();
    }

    public void checkTemporalConstraintsAgainstLinks() {
        for (PNodeEnd pNodeEnd : this.mm.getNodeEnds()) {
            block1: for (Object e : pNodeEnd.getSuccessors()) {
                PNodeEnd pNodeEnd2 = (PNodeEnd)e;
                for (Object e2 : pNodeEnd.getPostConstraints()) {
                    TimePointNet.TimeConstraint timeConstraint = (TimePointNet.TimeConstraint)e2;
                    if (timeConstraint.getPrePoint() != pNodeEnd || timeConstraint.getPostPoint() != pNodeEnd2) continue;
                    continue block1;
                }
                this.sim.problem("No temporal constraint from " + pNodeEnd + " to " + pNodeEnd2);
            }
        }
    }

    public void checkLinksAgainstTemporalConstraints() {
        for (PNodeEnd pNodeEnd : this.mm.getNodeEnds()) {
            for (Object e : pNodeEnd.getPostConstraints()) {
                TimePointNet.TimeConstraint timeConstraint = (TimePointNet.TimeConstraint)e;
                TimePoint timePoint = timeConstraint.getPostPoint();
                if (pNodeEnd.getSuccessors().contains(timePoint)) continue;
                this.sim.problem("No link from " + pNodeEnd + " to " + timePoint);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ReachableWithin<T, L> {
        protected ReachableWithin() {
        }

        abstract Collection<L> getSuccessorLinks(T var1);

        abstract T getSuccessor(L var1);

        abstract boolean isWithin(Object var1, T var2);

        public Set<T> collect(Object object, T t) {
            HashSet hashSet = new HashSet();
            this.walk(t, object, hashSet);
            return hashSet;
        }

        private void walk(T t, Object object, Set<T> set) {
            if (!this.isWithin(object, t) || set.contains(t)) {
                return;
            }
            set.add(t);
            for (L l : this.getSuccessorLinks(t)) {
                this.walk(this.getSuccessor(l), object, set);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class NodeEndConnectivityChecker<L>
    extends ReachableWithin<PNodeEnd, L> {
        protected NodeEndConnectivityChecker() {
        }

        @Override
        boolean isWithin(Object object, PNodeEnd pNodeEnd) {
            return pNodeEnd.getNode() == object || pNodeEnd.getNode().getParentPNode() == object;
        }

        abstract PNodeEnd getStartingEndForWalk(PNode var1);

        void checkConnectivity() {
            for (ActivityItem activityItem : SanityChecker.this.mm.getNodes()) {
                PNodeEnd pNodeEnd = this.getStartingEndForWalk(activityItem);
                PNodeEnd pNodeEnd2 = pNodeEnd.getOtherNodeEnd();
                Set<PNodeEnd> set = this.collect(activityItem, pNodeEnd);
                if (!set.contains(pNodeEnd2)) {
                    this.doesntReach(pNodeEnd, pNodeEnd2);
                }
                for (PNode pNode : activityItem.getChildren()) {
                    if (!set.contains(pNode.getBegin())) {
                        this.doesntReach(pNodeEnd, pNode.getBegin());
                    }
                    if (set.contains(pNode.getEnd())) continue;
                    this.doesntReach(pNodeEnd, pNode.getEnd());
                }
            }
        }

        void doesntReach(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
            String string = Strings.afterLast("$", this.getClass().getName());
            SanityChecker.this.sim.problem(string + ": " + pNodeEnd + " doesn't connect to " + pNodeEnd2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForwardTemporalLinkChecker
    extends NodeEndConnectivityChecker<TimePointNet.TimeConstraint> {
        private ForwardTemporalLinkChecker() {
        }

        @Override
        PNodeEnd getStartingEndForWalk(PNode pNode) {
            return pNode.getBegin();
        }

        @Override
        Collection<TimePointNet.TimeConstraint> getSuccessorLinks(PNodeEnd pNodeEnd) {
            return pNodeEnd.getPostConstraints();
        }

        @Override
        PNodeEnd getSuccessor(TimePointNet.TimeConstraint timeConstraint) {
            return Util.mustBe(PNodeEnd.class, timeConstraint.getPostPoint());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackwardOrderingLinkChecker
    extends ForwardOrderingLinkChecker {
        private BackwardOrderingLinkChecker() {
        }

        @Override
        PNodeEnd getStartingEndForWalk(PNode pNode) {
            return pNode.getEnd();
        }

        @Override
        Collection<Object> getSuccessorLinks(PNodeEnd pNodeEnd) {
            return pNodeEnd.getPredecessors();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForwardOrderingLinkChecker
    extends NodeEndConnectivityChecker<Object> {
        private ForwardOrderingLinkChecker() {
        }

        @Override
        PNodeEnd getStartingEndForWalk(PNode pNode) {
            return pNode.getBegin();
        }

        @Override
        Collection<Object> getSuccessorLinks(PNodeEnd pNodeEnd) {
            return pNodeEnd.getSuccessors();
        }

        @Override
        PNodeEnd getSuccessor(Object object) {
            return (PNodeEnd)object;
        }
    }
}

