/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.iplan.DomainAnalyser;
import ix.iplan.Slip;
import ix.iplan.SlipFindExecutable;
import ix.iplan.SlipSatisfyConds;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.Matcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class SlipAchieveConds
implements Slip.Step {
    Slip slip;
    AgendaItem item;
    ListOfConstraint conds;

    SlipAchieveConds(Slip slip, PNode pNode, ListOfConstraint listOfConstraint) {
        this.slip = slip;
        this.item = (AgendaItem)pNode;
        this.conds = listOfConstraint;
    }

    public void run() {
        Debug.expect(!this.slip.isWaitingForAchieve(this.item));
        this.slip.recordAsWaitingForAchieve(this.item);
        LinkedList linkedList = new LinkedList();
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        LinkedListOfConstraint linkedListOfConstraint2 = new LinkedListOfConstraint();
        if (!this.findSatisfactionMethods(linkedList, linkedListOfConstraint, linkedListOfConstraint2)) {
            throw this.slip.poison("Cannot satisfy conditions at " + this.item + ": " + linkedListOfConstraint2);
        }
        Debug.expect(!Collect.isEmpty(linkedList), "no goal nodes");
        Agenda agenda = this.slip.getController().getActivityAgenda();
        agenda.addItemsBefore(this.item, linkedList);
        for (PNode pNode : linkedList) {
            this.slip.setStatus(pNode.getBegin(), Status.POSSIBLE);
            pNode.getEnd().linkBefore(this.item.getBegin());
        }
        Debug.expectSame(Status.POSSIBLE, this.slip.getStatus(this.item.getBegin()));
        Debug.expectSame(Status.BLANK, this.slip.getStatus(this.item.getEnd()));
        this.slip.setStatus(this.item.getBegin(), Status.BLANK);
        if (linkedListOfConstraint.isEmpty()) {
            this.slip.setNextStep(new SlipFindExecutable(this.slip));
        } else {
            Debug.noteln("evalNow:", (Object)linkedListOfConstraint);
            this.slip.setNextStep(new SatisfyEvalNowConds(this.slip, this.item, linkedListOfConstraint));
        }
    }

    boolean findSatisfactionMethods(List list, List list2, List list3) {
        Debug.expect(list.isEmpty());
        Debug.expect(list2.isEmpty());
        Debug.expect(list3.isEmpty());
        PNodeEnd pNodeEnd = this.item.getBegin();
        long l = -1L;
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        for (Constraint constraint : this.conds) {
            Object object;
            if (constraint.getType() != Refinement.S_WORLD_STATE) {
                if (constraint.getType() != Refinement.S_COMPUTE || !this.willBindVars(list2, constraint)) continue;
                list2.add(constraint);
                continue;
            }
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            List list4 = this.slip.getAchieversForCond(constraint);
            if (!list4.isEmpty()) {
                object = this.slip.makeGoalNode(patternAssignment, list4, pNodeEnd);
                list.add(object);
                continue;
            }
            if (l == -1L) {
                l = this.item.getBegin().markShadowedEnds(0);
            }
            if (this.parallelMightSatisfy(patternAssignment, l)) continue;
            list2.add(constraint);
            linkedListOfConstraint.clear();
            linkedListOfConstraint.add(constraint);
            object = this.slip.MM().testFilters(linkedListOfConstraint, Matcher.emptyEnv);
            if (!object.isEmpty()) continue;
            list3.add(constraint);
        }
        return list3.isEmpty();
    }

    boolean willBindVars(List list, Constraint constraint) {
        Debug.expectSame(Refinement.S_COMPUTE, constraint.getType());
        Debug.noteln("willBindVars in " + constraint + " from " + list);
        Set set = Variable.unboundVarsAnywhereIn(constraint.getPattern());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Debug.noteln("Need", (Object)set);
            if (set.isEmpty()) {
                return true;
            }
            Constraint constraint2 = (Constraint)iterator.next();
            set.removeAll(Variable.varsAnywhereIn(constraint2.getPatternAssignment()));
        }
        Debug.noteln("Finally need", (Object)set);
        return set.isEmpty();
    }

    boolean parallelMightSatisfy(PatternAssignment patternAssignment, long l) {
        Debug.noteln("Parallel might satisfy:", (Object)patternAssignment);
        DomainAnalyser domainAnalyser = this.slip.analysis;
        for (PNodeEnd pNodeEnd : this.slip.MM().getNodeEnds()) {
            Set set;
            if (this.slip.getStatus(pNodeEnd) == Status.COMPLETE || pNodeEnd.isMarked(0, l) || !domainAnalyser.mightSatisfy(patternAssignment, set = this.slip.getPossibleEffects(pNodeEnd))) continue;
            return true;
        }
        return false;
    }

    static class SatisfyEvalNowConds
    extends SlipSatisfyConds {
        SatisfyEvalNowConds(Slip slip, PNode pNode, ListOfConstraint listOfConstraint) {
            super(slip, pNode, listOfConstraint);
        }

        void adjustStatus(AgendaItem agendaItem) {
            Debug.noteln("Satisfied eval-now conds for", (Object)agendaItem);
            Debug.noteln("Eval-now conds:", (Object)this.conds);
        }

        void checkCondsSatisfied(List list) {
            if (list.isEmpty()) {
                throw this.slip.poison("cannot satisfy eval-now conditions at " + this.item + ": " + this.conds);
            }
        }
    }
}

