/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Issue;
import ix.icore.Variable;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.Refinement;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.iplan.IPlanModelManager;
import ix.iplan.ServiceSymbols;
import ix.iplan.Slip;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class SlipExpander
implements ServiceSymbols {
    Slip slip;
    AgendaItem item;
    Refinement refinement;
    MatchEnv refinementMatchEnv;
    List filterEnvs;

    SlipExpander(Slip slip, AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv, List list) {
        this.slip = slip;
        this.item = agendaItem;
        this.refinement = refinement;
        this.refinementMatchEnv = matchEnv;
        this.filterEnvs = list;
    }

    boolean isExpandLater() {
        return this.filterEnvs == null;
    }

    boolean isStillValid() {
        return this.slip.MM().getVariableManager().consistentBindings(this.getInstantiationEnv());
    }

    void doExpansion() {
        Object object;
        Object object2;
        IPlanModelManager iPlanModelManager = this.slip.MM();
        Debug.noteln("Expanding using", (Object)this.refinement);
        MatchEnv matchEnv = this.getInstantiationEnv();
        Debug.noteln("Using env", (Object)matchEnv);
        matchEnv = this.bindAnyOutputs(matchEnv);
        this.item.expandOneLevel(this.refinement, matchEnv);
        iPlanModelManager.applyEnv(matchEnv);
        Agenda agenda = this.slip.getController().getActivityAgenda();
        Object object3 = Collect.iterator(this.item.getChildren());
        while (object3.hasNext()) {
            object2 = (AgendaItem)object3.next();
            agenda.addItem((AgendaItem)object2);
        }
        object3 = this.item.getRefinement().getIssues();
        object2 = Collect.iterator((Collection)object3);
        while (object2.hasNext()) {
            object = (Issue)object2.next();
            this.slip.getController().addIssue((Issue)object);
        }
        object2 = this.item.getRefinement().getOrderings();
        try {
            iPlanModelManager.addOrderingsAsTimeConstraints(this.item, (ListOfOrdering)object2);
            object = this.item.getRefinement().getConstraints();
            if (object != null) {
                iPlanModelManager.addConstraints(this.item, (List)object);
            }
        }
        catch (FailureException failureException) {
            throw this.slip.poison(failureException);
        }
    }

    private MatchEnv getInstantiationEnv() {
        if (this.filterEnvs != null && !this.filterEnvs.isEmpty() && this.filterEnvs.size() == 1) {
            return (MatchEnv)this.filterEnvs.get(0);
        }
        return this.refinementMatchEnv;
    }

    private MatchEnv bindAnyOutputs(MatchEnv matchEnv) {
        List list = (List)this.refinement.getAnnotation(S_OUTPUT_OBJECTS);
        if (list == null) {
            return matchEnv;
        }
        Debug.noteln("Output Objects", (Object)list);
        MatchEnv matchEnv2 = new MatchEnv((Map)matchEnv);
        for (List list2 : list) {
            Comparable comparable;
            ItemVar itemVar = (ItemVar)list2.get(0);
            Symbol symbol = (Symbol)list2.get(1);
            Object v = matchEnv2.get(itemVar);
            if (v == null) {
                comparable = this.slip.generateObjectName(symbol);
                matchEnv2.put(itemVar, comparable);
                continue;
            }
            if (v instanceof Variable) {
                comparable = (Variable)v;
                if (((Variable)comparable).isBound()) {
                    if (this.isInputVar(itemVar)) continue;
                    throw this.slip.poison(itemVar + " bound to " + comparable + " can't be a generated " + symbol);
                }
                Symbol symbol2 = this.slip.generateObjectName(symbol);
                matchEnv2.put(itemVar, symbol2);
                matchEnv2.put(comparable, symbol2);
                continue;
            }
            if (this.isInputVar(itemVar)) continue;
            throw this.slip.poison(itemVar + " bound to " + v + " can't be a generated " + symbol);
        }
        Debug.noteln("Env with generated objects", (Object)matchEnv2);
        return matchEnv2;
    }

    private boolean isInputVar(ItemVar itemVar) {
        List list = (List)this.refinement.getAnnotation(S_INPUT_OBJECTS);
        if (list != null) {
            for (List list2 : list) {
                if (itemVar != list2.get(0)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SlipExpander[" + this.refinement + "]";
    }
}

