/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.AdviceManager;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.iplan.Alternative;
import ix.iplan.DomainAnalyser;
import ix.iplan.Slip;
import ix.iplan.SlipAchieveConds;
import ix.iplan.SlipAchiever;
import ix.iplan.SlipExpandNode;
import ix.iplan.SlipExpander;
import ix.iplan.SlipSatisfyConds;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListIterator;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlipFindExecutable
implements Slip.Step {
    Slip slip;

    SlipFindExecutable(Slip slip) {
        this.slip = slip;
    }

    @Override
    public void run() {
        LList lList = this.getNodeEnds();
        this.findNext(lList, this.endIterator(lList));
    }

    void findNext(LList lList, LListIterator lListIterator) {
        while (true) {
            List<Constraint> list;
            Object object;
            PNodeEnd pNodeEnd = this.nextExecutable(lListIterator);
            Debug.noteln("SlipFindExecutable considering", (Object)pNodeEnd);
            if (pNodeEnd.getEnd() == End.END) {
                if (!this.slip.canExecEnd(pNodeEnd)) continue;
                Debug.noteln("Can execute", (Object)pNodeEnd);
                this.postFindNextAlt(pNodeEnd, lList, lListIterator, "exec end");
                this.slip.execEnd(pNodeEnd);
                lListIterator = this.endIterator(lList);
                continue;
            }
            PNode pNode = pNodeEnd.getNode();
            if (this.slip.isGoalNode(pNodeEnd)) {
                Debug.noteln("Examining goal node", (Object)pNodeEnd);
                object = this.slip.getGoalCond(pNodeEnd);
                list = new LinkedListOfConstraint();
                list.add(this.makeCondition((PatternAssignment)object));
                Debug.noteln("Goal cond", object);
                List list2 = this.slip.MM().evalFilters((ListOfConstraint)list, new MatchEnv());
                if (!list2.isEmpty()) {
                    List list3;
                    Debug.noteln("Envs for goal cond", (Object)list2);
                    this.postFindNextAlt(pNodeEnd, lList, lListIterator, "delete");
                    if (this.slip.liberalAchieveSemantics) {
                        this.maybePostExpandGoalAlt(pNodeEnd);
                    }
                    Debug.expect(!(list3 = this.slip.MM().reevaluateFilters((ListOfConstraint)list)).isEmpty(), "Cannot match goal", object);
                    this.slip.setStatus(pNode.getEnd(), Status.COMPLETE);
                    this.slip.releaseWaitingEnds(pNode.getBegin());
                    this.slip.releaseWaitingEnds(pNode.getEnd());
                    ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
                    Agenda agenda = this.slip.getController().getActivityAgenda();
                    Debug.noteln("Deleting goal node", (Object)activityItem);
                    agenda.removeItem(activityItem);
                    lList = this.getNodeEnds();
                    lListIterator = this.endIterator(lList);
                    continue;
                }
                Debug.expect(!pNode.isExpanded());
            }
            if (this.isAlreadyExpanded(pNodeEnd)) {
                Debug.noteln("Is already expanded");
                object = this.slip.MM().getNodeConditions(pNode);
                if (object == null || object.isEmpty()) {
                    Debug.noteln("No conditions");
                    this.postFindNextAlt(pNodeEnd, lList, lListIterator, "exec expanded primitive");
                    this.slip.execBegin(pNodeEnd);
                    lListIterator = this.endIterator(lList);
                    continue;
                }
                list = this.slip.MM().evalFilters((ListOfConstraint)object, new MatchEnv());
                Debug.noteln("Conditions", object);
                Debug.noteln("Envs", list);
                if (list.isEmpty()) {
                    Debug.noteln("Cannot satisfy conds");
                    if (this.slip.isWaitingForAchieve(pNode) || !this.mightAchieveConds((ListOfConstraint)object)) continue;
                    this.postSatisfyByAchieveAlt(pNode, (ListOfConstraint)object);
                    continue;
                }
                this.postFindNextAlt(pNodeEnd, lList, lListIterator, "satisfy conds for expanded");
                this.satisfyNodeEndConds(pNodeEnd, (ListOfConstraint)object, list);
                lListIterator = this.endIterator(lList);
                continue;
            }
            Debug.noteln("Trying refinements");
            object = new LinkedList();
            list = new LinkedList();
            if (!this.nodeExpanders(pNodeEnd, (LinkedList)object, (LinkedList)list)) {
                Debug.noteln("No refinements apply");
                this.postFindNextAlt(pNodeEnd, lList, lListIterator, "exec primitive");
                this.slip.execBegin(pNodeEnd);
                lListIterator = this.endIterator(lList);
                continue;
            }
            Debug.noteln("useNow", object);
            Debug.noteln("useLater", (Object)list);
            if (!((AbstractCollection)object).isEmpty()) {
                Debug.noteln("Can expand");
                this.postFindNextAlt(pNodeEnd, lList, lListIterator, "expand");
                if (!((AbstractCollection)((Object)list)).isEmpty()) {
                    this.postExpandLaterAlt(pNode, (LinkedList)list);
                }
                this.slip.setNextStep(new SlipExpandNode(this.slip, pNode, (LinkedList)object));
                return;
            }
            if (!((AbstractCollection)((Object)list)).isEmpty()) {
                this.postExpandLaterAlt(pNode, (LinkedList)list);
            }
            Debug.noteln("No refinement can expand now");
        }
    }

    void maybePostExpandGoalAlt(PNodeEnd pNodeEnd) {
        LinkedList linkedList;
        LinkedList linkedList2;
        Debug.expect(this.slip.liberalAchieveSemantics);
        Debug.expect(this.slip.isGoalNode(pNodeEnd));
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        PatternAssignment patternAssignment = this.slip.getGoalCond(pNodeEnd);
        if (Variable.isFullyBoundEverywhere(patternAssignment)) {
            // empty if block
        }
        if (!this.nodeExpanders(pNodeEnd, linkedList2 = new LinkedList(), linkedList = new LinkedList())) {
            return;
        }
        if (!linkedList.isEmpty()) {
            Debug.noteln("Can expand later");
            Debug.noteln("useLater", linkedList);
            this.postExpandLaterAlt(pNode, linkedList);
        }
        if (!linkedList2.isEmpty()) {
            Debug.noteln("Can expand goal now");
            Debug.noteln("useNow", linkedList2);
            this.slip.postAlternative(new ExpandGoalAlt(pNode, linkedList2));
        }
    }

    void postFindNextAlt(PNodeEnd pNodeEnd, LList lList, LListIterator lListIterator, String string) {
        LListListIterator lListListIterator;
        PNodeEnd pNodeEnd2;
        List<PNodeEnd> list = null;
        if (!this.slip.domainSays("iplan-try-pointless-permutations") && this.slip.useDomainAnalysis) {
            list = this.findInteractingEnds(pNodeEnd);
            if (list.isEmpty()) {
                Debug.noteln("No interactions with", (Object)pNodeEnd);
                return;
            }
            Debug.noteln(pNodeEnd + " interacts with", list);
        }
        if (string.equals("expand") && this.slip.noPossibleTopLevelConstraints(pNodeEnd)) {
            Debug.noteln("No possible top-level constraints when expanding.");
            return;
        }
        if (lListIterator.hasNext() && (pNodeEnd2 = this.slip.findExecutable(lListListIterator = new LListListIterator(lListIterator.getTail()))) != null) {
            lListListIterator.previous();
            this.slip.postAlternative(new Resume(lList, lListListIterator, pNodeEnd, list, string));
        }
    }

    List<PNodeEnd> findInteractingEnds(PNodeEnd pNodeEnd) {
        DomainAnalyser domainAnalyser = this.slip.analysis;
        boolean bl = this.slip.isGoalNode(pNodeEnd);
        PNodeEnd pNodeEnd2 = bl ? this.slip.getAtEndForGoal(pNodeEnd) : null;
        LinkedList<PNodeEnd> linkedList = new LinkedList<PNodeEnd>();
        Set set = this.slip.getPossibleConditions(pNodeEnd);
        Set set2 = this.slip.getPossibleEffects(pNodeEnd);
        Set set3 = this.slip.getPossibleOtherConstraints(pNodeEnd);
        long l = pNodeEnd.markShadowedEnds(0);
        for (PNodeEnd pNodeEnd3 : this.slip.MM().getNodeEnds()) {
            if (pNodeEnd3 == pNodeEnd || this.slip.getStatus(pNodeEnd3) != Status.POSSIBLE && this.slip.getStatus(pNodeEnd3) != Status.BLANK || pNodeEnd3.isMarked(0, l)) continue;
            if (bl && this.slip.isGoalNode(pNodeEnd3) && pNodeEnd2 == this.slip.getAtEndForGoal(pNodeEnd3)) {
                linkedList.add(pNodeEnd3);
                continue;
            }
            if (this.interactingCondsAndEffects(pNodeEnd, set, set2, pNodeEnd3)) {
                linkedList.add(pNodeEnd3);
                continue;
            }
            if (!this.slip.possiblyInteractingConstraints(pNodeEnd, set3, pNodeEnd3)) continue;
            linkedList.add(pNodeEnd3);
        }
        return linkedList;
    }

    boolean interactingCondsAndEffects(PNodeEnd pNodeEnd, Set set, Set set2, PNodeEnd pNodeEnd2) {
        DomainAnalyser domainAnalyser = this.slip.analysis;
        Set set3 = this.slip.getPossibleEffects(pNodeEnd2);
        if (domainAnalyser.haveCommonPatterns(set, set3)) {
            return true;
        }
        Set set4 = this.slip.getPossibleConditions(pNodeEnd2);
        if (domainAnalyser.haveCommonPatterns(set2, set4) && this.couldStillSatisfyConds(pNodeEnd2, pNodeEnd)) {
            return true;
        }
        if (domainAnalyser.haveCommonPatterns(set2, set3)) {
            long l = pNodeEnd2.markEndsBefore(1);
            for (PNodeEnd pNodeEnd3 : this.slip.MM().getNodeEnds()) {
                Set set5;
                if (this.slip.getStatus(pNodeEnd3) == Status.COMPLETE || pNodeEnd3.isMarked(1, l) || pNodeEnd3 == pNodeEnd || !domainAnalyser.haveCommonPatterns(set2, set5 = this.slip.getPossibleConditions(pNodeEnd3))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean couldStillSatisfyConds(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        long l = pNodeEnd2.getMark(0);
        long l2 = pNodeEnd.markShadowedEnds(1);
        if (this.isAlreadyExpanded(pNodeEnd)) {
            ListOfConstraint listOfConstraint = this.slip.MM().getNodeConditions(pNode);
            return this.canSatisfyAll(listOfConstraint, l, l2);
        }
        if (this.slip.isGoalNode(pNodeEnd)) {
            List list = this.slip.getGoalAchievers(pNode);
            for (SlipAchiever slipAchiever : list) {
                Refinement refinement = slipAchiever.refinement;
                Debug.expect(!Collect.isEmpty(refinement.getConstraints()));
                ListOfConstraint listOfConstraint = refinement.getFilterConstraints();
                if (!this.canSatisfyAll(listOfConstraint, l, l2)) continue;
                return true;
            }
            return false;
        }
        AdviceManager adviceManager = this.slip.MM().getAdviceManager();
        LList lList = pNode.getPattern();
        for (Refinement refinement : this.slip.getDomain().getRefinements()) {
            ListOfConstraint listOfConstraint;
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), lList);
            if (matchEnv == null || !adviceManager.isUsableRefinement(refinement) || !this.canSatisfyAll(listOfConstraint = refinement.getFilterConstraints(), l, l2)) continue;
            return true;
        }
        return false;
    }

    private boolean canSatisfyAll(ListOfConstraint listOfConstraint, long l, long l2) {
        DomainAnalyser domainAnalyser = this.slip.analysis;
        block0: for (Constraint constraint : listOfConstraint) {
            if (constraint.getType() != Refinement.S_WORLD_STATE || this.worldStateSatisfiesCond(constraint) || this.slip.existsAchieversForCond(constraint)) continue;
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            for (PNodeEnd pNodeEnd : this.slip.MM().getNodeEnds()) {
                Set set;
                if (this.slip.getStatus(pNodeEnd) == Status.COMPLETE || pNodeEnd.isMarked(0, l) || pNodeEnd.isMarked(1, l2) || !domainAnalyser.mightSatisfy(patternAssignment, set = this.slip.getPossibleEffects(pNodeEnd))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    Constraint makeCondition(PatternAssignment patternAssignment) {
        return new Constraint(Refinement.S_WORLD_STATE, Refinement.S_CONDITION, (List)Lisp.list(patternAssignment));
    }

    void satisfyNodeEndConds(PNodeEnd pNodeEnd, ListOfConstraint listOfConstraint, List list) {
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        if (list.size() == 1) {
            this.slip.MM().satisfyConds(agendaItem, listOfConstraint, (MatchEnv)list.get(0));
            this.slip.execBegin(pNodeEnd);
            return;
        }
        LinkedList linkedList = (LinkedList)list;
        MatchEnv matchEnv = (MatchEnv)linkedList.removeFirst();
        SlipSatisfyConds slipSatisfyConds = new SlipSatisfyConds(this.slip);
        slipSatisfyConds.getClass();
        this.slip.postAlternative(new SlipSatisfyConds.ResumeSatisfaction(slipSatisfyConds, agendaItem, listOfConstraint, linkedList));
        this.slip.MM().satisfyConds(agendaItem, listOfConstraint, matchEnv);
        this.slip.execBegin(pNodeEnd);
    }

    void postSatisfyByAchieveAlt(PNode pNode, ListOfConstraint listOfConstraint) {
        this.slip.postAlternative(new SatisfyByAchieveAlt(pNode, listOfConstraint));
    }

    boolean mightAchieveConds(ListOfConstraint listOfConstraint) {
        boolean bl = false;
        for (Constraint constraint : listOfConstraint) {
            if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
            if (this.condMightBeAchieved(constraint)) {
                bl = true;
                continue;
            }
            if (this.worldStateSatisfiesCond(constraint)) continue;
            return false;
        }
        return bl;
    }

    boolean worldStateSatisfiesCond(Constraint constraint) {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        linkedListOfConstraint.add(constraint);
        List list = this.slip.MM().evalFilters(linkedListOfConstraint, new MatchEnv());
        return !list.isEmpty();
    }

    private boolean condMightBeAchieved(Constraint constraint) {
        return this.slip.existsAchieversForCond(constraint);
    }

    LList getNodeEnds() {
        return LList.newLList(this.slip.MM().getNodeEnds());
    }

    LListIterator endIterator(LList lList) {
        if (!this.slip.domainSays("iplan-try-pointless-permutations")) {
            this.executeTrivialEnds(lList);
        }
        return (LListIterator)lList.iterator();
    }

    void executeTrivialEnds(LList lList) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (PNodeEnd pNodeEnd : lList) {
                if (this.slip.getStatus(pNodeEnd) != Status.POSSIBLE || !this.isTrivial(pNodeEnd)) continue;
                Debug.noteln("Pre-executing", (Object)pNodeEnd);
                this.slip.setStatus(pNodeEnd, Status.COMPLETE);
                bl = true;
            }
        }
    }

    boolean isTrivial(PNodeEnd pNodeEnd) {
        PNode pNode = pNodeEnd.getNode();
        if (pNodeEnd.getEnd() == End.BEGIN) {
            if (this.slip.isGoalNode(pNodeEnd)) {
                return false;
            }
            if (!this.isAlreadyExpanded(pNodeEnd)) {
                return !this.someRefinementApplies(pNode);
            }
            ListOfConstraint listOfConstraint = this.slip.MM().getNodeConditions(pNode);
            if (listOfConstraint != null && !listOfConstraint.isEmpty()) {
                return false;
            }
            List<Constraint> list = this.slip.MM().getOtherNodeConstraints(pNode);
            return list == null || list.isEmpty();
        }
        List list = this.slip.MM().getNodeEffects(pNode);
        if (list != null && !list.isEmpty()) {
            return false;
        }
        List<Constraint> list2 = this.slip.MM().getOtherNodeConstraints(pNode);
        return list2 == null || list2.isEmpty();
    }

    boolean someRefinementApplies(PNode pNode) {
        LList lList = pNode.getPattern();
        for (Refinement refinement : this.slip.getDomain().getRefinements()) {
            if (!this.refinementApplies(refinement, lList)) continue;
            return true;
        }
        return false;
    }

    boolean refinementApplies(Refinement refinement, LList lList) {
        int n;
        LList lList2 = refinement.getPattern();
        if (!lList2.car().equals(lList.car())) {
            return false;
        }
        int n2 = lList2.length();
        return n2 == (n = lList.length()) || n2 - 2 <= n && lList2.contains(Matcher.REST);
    }

    PNodeEnd nextExecutable(Iterator iterator) {
        PNodeEnd pNodeEnd = this.slip.findExecutable(iterator);
        if (pNodeEnd == null) {
            if (this.slip.planIsComplete()) {
                throw new Slip.HavePlanException();
            }
            throw this.slip.poison("no executable node-end");
        }
        return pNodeEnd;
    }

    boolean isAlreadyExpanded(PNodeEnd pNodeEnd) {
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        if (pNode.isExpanded()) {
            Debug.expect(!this.slip.isGoalNode(pNodeEnd));
            return true;
        }
        Debug.expect(pNode.getChildren().isEmpty(), "Has children when not expanded", pNode);
        Debug.expect(Collect.isEmpty(this.slip.MM().getNodeConditions(pNode)), "Has conds when not expanded", pNode);
        return false;
    }

    boolean nodeExpanders(PNodeEnd pNodeEnd, LinkedList linkedList, LinkedList linkedList2) {
        if (this.slip.isGoalNode(pNodeEnd)) {
            return this.goalExpanders(pNodeEnd, linkedList, linkedList2);
        }
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        boolean bl = false;
        AdviceManager adviceManager = this.slip.MM().getAdviceManager();
        for (Refinement refinement : this.slip.getDomain().getRefinements()) {
            LList lList = agendaItem.getPattern();
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), lList);
            if (matchEnv == null || !adviceManager.isUsableRefinement(refinement)) {
                bl = bl || this.refinementApplies(refinement, lList);
                continue;
            }
            if (Collect.isEmpty(refinement.getNodes()) && Collect.isEmpty(refinement.getConstraints())) {
                linkedList.add(this.makeManualExpander(agendaItem, refinement, matchEnv));
                continue;
            }
            SlipExpander slipExpander = this.makeExpander(agendaItem, refinement, matchEnv);
            SlipExpander slipExpander2 = null;
            if (slipExpander == null || this.slip.liberalAchieveSemantics) {
                slipExpander2 = this.makeLaterExpander(agendaItem, refinement, matchEnv);
            }
            if (slipExpander != null) {
                linkedList.add(slipExpander);
            }
            if (slipExpander2 != null) {
                linkedList2.add(slipExpander2);
            }
            if (slipExpander != null || slipExpander2 != null) continue;
            bl = true;
        }
        return bl || !linkedList.isEmpty() || !linkedList2.isEmpty();
    }

    boolean goalExpanders(PNodeEnd pNodeEnd, LinkedList linkedList, LinkedList linkedList2) {
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        List list = this.slip.getGoalAchievers(agendaItem);
        for (SlipAchiever slipAchiever : list) {
            SlipExpander slipExpander;
            Refinement refinement = slipAchiever.refinement;
            Debug.expect(!Collect.isEmpty(refinement.getConstraints()));
            MatchEnv matchEnv = slipAchiever.rematchCond();
            if (matchEnv == null) {
                Debug.noteln("Can't use " + slipAchiever + " for goal " + agendaItem + " because " + slipAchiever.condMatchEnv + " no longer applies");
                continue;
            }
            SlipExpander slipExpander2 = this.makeExpander(agendaItem, refinement, matchEnv);
            if (slipExpander2 != null) {
                linkedList.add(slipExpander2);
                if (!this.slip.liberalAchieveSemantics) continue;
            }
            if ((slipExpander = this.makeLaterExpander(agendaItem, refinement, matchEnv)) != null) {
                linkedList2.add(slipExpander);
                continue;
            }
            if (slipExpander2 != null) continue;
            Debug.noteln("Can't use " + slipAchiever + " for goal " + agendaItem);
        }
        if (linkedList.isEmpty() && linkedList2.isEmpty()) {
            Debug.noteln("Cannot expand goal", (Object)agendaItem);
        }
        return true;
    }

    SlipExpander makeManualExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        Cons cons = Lisp.list(matchEnv);
        return new SlipExpander(this.slip, agendaItem, refinement, matchEnv, cons);
    }

    SlipExpander makeExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        boolean bl;
        MatchEnv matchEnv2 = matchEnv;
        ListOfConstraint listOfConstraint = refinement.getFilterConstraints();
        List list = listOfConstraint.isEmpty() ? Collections.EMPTY_LIST : this.slip.MM().evalFilters(listOfConstraint, matchEnv2);
        boolean bl2 = bl = listOfConstraint.isEmpty() || !list.isEmpty();
        if (bl) {
            return new SlipExpander(this.slip, agendaItem, refinement, matchEnv2, list);
        }
        return null;
    }

    SlipExpander makeLaterExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        if (!this.slip.isWaitingForAchieve(agendaItem) && this.mightAchieveConds(refinement.getFilterConstraints())) {
            return new SlipExpander(this.slip, agendaItem, refinement, matchEnv, null);
        }
        return null;
    }

    void postExpandLaterAlt(PNode pNode, LinkedList linkedList) {
        this.slip.postAlternative(new ExpandLaterAlt(pNode, linkedList));
    }

    class ExpandLaterAlt
    extends Alternative {
        PNode node;
        LinkedList useLater;

        ExpandLaterAlt(PNode pNode, LinkedList linkedList) {
            this.node = pNode;
            this.useLater = linkedList;
        }

        public void run() {
            SlipFindExecutable.this.slip.releaseWaitingEnds(this.node.getBegin());
            SlipFindExecutable.this.slip.setNextStep(new SlipExpandNode(SlipFindExecutable.this.slip, this.node, this.useLater));
        }

        protected String extraToStringContents() {
            return " to expand " + Variable.removeVars(this.node.getPattern());
        }
    }

    class SatisfyByAchieveAlt
    extends Alternative {
        PNode node;
        ListOfConstraint conds;

        SatisfyByAchieveAlt(PNode pNode, ListOfConstraint listOfConstraint) {
            this.node = pNode;
            this.conds = listOfConstraint;
        }

        public void run() {
            SlipFindExecutable.this.slip.setNextStep(new SlipAchieveConds(SlipFindExecutable.this.slip, this.node, this.conds));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Resume
    extends Alternative {
        LList allNodeEnds;
        LListIterator nodeEndIter;
        String doing;
        PNodeEnd selected;
        List<PNodeEnd> interacting;

        Resume(LList lList, LListIterator lListIterator, PNodeEnd pNodeEnd, List<PNodeEnd> list, String string) {
            this.allNodeEnds = lList;
            this.nodeEndIter = lListIterator;
            this.selected = pNodeEnd;
            this.interacting = list;
            this.doing = string;
            this.isLocalChoice = true;
        }

        @Override
        public void run() {
            SlipFindExecutable.this.findNext(this.allNodeEnds, this.nodeEndIter);
        }

        @Override
        public void whenPicked() {
            Debug.expect(this.selected != null);
            if (this.interacting != null) {
                Debug.noteln(this.selected + " must wait for one of " + this.interacting);
                SlipFindExecutable.this.slip.isWaiting.put(this.selected, Boolean.TRUE);
                for (PNodeEnd pNodeEnd : this.interacting) {
                    SlipFindExecutable.this.slip.unwaitTable.addValue(pNodeEnd, this.selected);
                }
            }
        }

        @Override
        protected String extraToStringContents() {
            return " instead of " + this.doing + " " + this.selected;
        }
    }

    class ExpandGoalAlt
    extends Alternative {
        PNode node;
        LinkedList useNow;

        ExpandGoalAlt(PNode pNode, LinkedList linkedList) {
            this.node = pNode;
            this.useNow = linkedList;
        }

        public void run() {
            SlipFindExecutable.this.slip.setNextStep(new SlipExpandNode(SlipFindExecutable.this.slip, this.node, this.useNow));
        }

        protected String extraToStringContents() {
            return " to expand " + Variable.removeVars(this.node.getPattern());
        }
    }
}

