/*
 * Decompiled with CFR 0.152.
 */
package ix.iquery;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.iface.util.Reporting;
import ix.iface.util.ToolController;
import ix.iquery.LookupHandler;
import ix.util.CatchingThread;
import ix.util.TextAreaFrame;
import ix.util.Util;

public abstract class IQuery
extends IXAgent {
    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
    }

    protected void startup() {
        Util.swingAndWait(new Runnable(){

            public void run() {
                IQuery.this.setupGUI();
            }
        });
    }

    protected void setupGUI() {
        this.textFrame = new TextAreaFrame("Messages for " + this.ipcName, new String[]{"Exit"});
        this.textFrame.setFoldLongLines(0);
        this.textFrame.addToolManager();
        this.textFrame.addListener(new TextAreaFrame.TListener(){

            public void buttonPressed(String string) {
                if (string.equals("Exit") && Util.dialogConfirms(IQuery.this.textFrame, "Are you sure you want to exit?")) {
                    IQuery.this.exit();
                }
            }
        });
    }

    public void exit() {
        System.exit(0);
    }

    public void addTool(ToolController toolController) {
        this.textFrame.addTool(toolController);
    }

    public void do_transcript(String string) {
        this.textFrame.appendLine(string);
        if (!this.textFrame.getFrame().isShowing()) {
            this.textFrame.setVisible(true);
        }
    }

    public void handleNewActivity(Activity activity) {
        this.handleReceivedReport(activity);
        this.do_transcript(Reporting.activityDescription(activity));
        if (this.isLookupActivity(activity)) {
            this.handleLookupActivity(activity);
        }
    }

    protected void handleLookupActivity(Activity activity) {
        new LookupThread(activity).start();
    }

    protected abstract boolean isLookupActivity(Activity var1);

    protected abstract LookupHandler makeLookupHandler(IQuery var1, Activity var2);

    protected class LookupThread
    extends CatchingThread {
        Activity act;

        LookupThread(Activity activity) {
            this.act = activity;
        }

        public void innerRun() {
            IQuery.this.makeLookupHandler(IQuery.this, this.act).handleLookup();
        }
    }
}

